/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.ExpressionIndexSupport$;
import org.apache.hudi.HoodieCatalystUtils$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieSparkExpressionIndex;
import org.apache.hudi.RecordLevelIndexSupport$;
import org.apache.hudi.SparkBaseIndexSupport;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.parallel.mutable.ParHashMap;
import scala.collection.parallel.mutable.ParHashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001\u0002\u0013&\u00011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011!9\u0006\u0001#b\u0001\n\u0013A\u0006\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\ti\u0003\u0001Q\u0001\n\u0005u\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!!<\u0001\t\u0013\ty\u000fC\u0004\u0003\u0006\u0001!\tAa\u0002\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!I!1\u0005\u0001\u0012\u0002\u0013\u0005!Q\u0005\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqA!\u0013\u0001\t\u0013\u0011Y\u0005C\u0004\u0003`\u0001!IA!\u0019\t\u000f\t5\u0004\u0001\"\u0003\u0003p!9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0005GC\u0011B!-\u0001#\u0003%\tAa-\t\u000f\t]\u0006\u0001\"\u0003\u0003:\u001e9!QY\u0013\t\u0002\t\u001dgA\u0002\u0013&\u0011\u0003\u0011I\r\u0003\u0004Q9\u0011\u0005!\u0011\u001b\u0005\n\u0005'd\"\u0019!C\u0001\u0005+D\u0001Ba7\u001dA\u0003%!q\u001b\u0005\n\u0005;d\"\u0019!C\u0005\u0005?D\u0001Ba:\u001dA\u0003%!\u0011\u001d\u0005\n\u0005Sd\"\u0019!C\u0005\u0005WDqA!<\u001dA\u0003%!H\u0001\fFqB\u0014Xm]:j_:Le\u000eZ3y'V\u0004\bo\u001c:u\u0015\t1s%\u0001\u0003ik\u0012L'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001[A\u0011afL\u0007\u0002K%\u0011\u0001'\n\u0002\u0016'B\f'o\u001b\"bg\u0016Le\u000eZ3y'V\u0004\bo\u001c:u\u0003\u0015\u0019\b/\u0019:l!\t\u0019t'D\u00015\u0015\t)d'A\u0002tc2T!!M\u0014\n\u0005a\"$\u0001D*qCJ\\7+Z:tS>t\u0017a\u0003;bE2,7k\u00195f[\u0006\u0004\"a\u000f \u000e\u0003qR!!\u0010\u001b\u0002\u000bQL\b/Z:\n\u0005}b$AC*ueV\u001cG\u000fV=qK\u0006qQ.\u001a;bI\u0006$\u0018mQ8oM&<\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0019\u0019wN\u001c4jO*\u0011a)J\u0001\u0007G>lWn\u001c8\n\u0005!\u001b%\u0001\u0006%p_\u0012LW-T3uC\u0012\fG/Y\"p]\u001aLw-\u0001\u0006nKR\f7\t\\5f]R\u0004\"a\u0013(\u000e\u00031S!!T#\u0002\u000bQ\f'\r\\3\n\u0005=c%!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI\u001bF+\u0016,\u0011\u00059\u0002\u0001\"B\u0019\u0006\u0001\u0004\u0011\u0004\"B\u001d\u0006\u0001\u0004Q\u0004\"\u0002!\u0006\u0001\u0004\t\u0005\"B%\u0006\u0001\u0004Q\u0015aG2bG\",GmQ8mk6t7\u000b^1ug&sG-\u001a=WS\u0016<8/F\u0001Z!\u0011Q6-Z=\u000e\u0003mS!\u0001X/\u0002\u000f5,H/\u00192mK*\u0011alX\u0001\ta\u0006\u0014\u0018\r\u001c7fY*\u0011\u0001-Y\u0001\u000bG>dG.Z2uS>t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\\&A\u0003)be\"\u000b7\u000f['baB\u0019aM\\9\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u00016,\u0003\u0019a$o\\8u}%\t!-\u0003\u0002nC\u00069\u0001/Y2lC\u001e,\u0017BA8q\u0005\r\u0019V-\u001d\u0006\u0003[\u0006\u0004\"A\u001d<\u000f\u0005M$\bC\u00015b\u0013\t)\u0018-\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;b!\rQ\u0018\u0011\u0002\b\u0004w\u0006\u001dab\u0001?\u0002\u00069\u0019Q0a\u0001\u000f\u0007y\f\tA\u0004\u0002i\u007f&\t!&\u0003\u0002)S%\u0011\u0011gJ\u0005\u0003kYJ!!\u001c\u001b\n\t\u0005-\u0011Q\u0002\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u001c\u001b)\u0007\u0019\t\t\u0002\u0005\u0003\u0002\u0014\u0005UQ\"A1\n\u0007\u0005]\u0011MA\u0005ue\u0006t7/[3oi\u0006Y\u0012N\\'f[>\u0014\u0018\u0010\u0015:pU\u0016\u001cG/[8o)\"\u0014Xm\u001d5pY\u0012,\"!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005!A.\u00198h\u0015\t\t9#\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003C\u0011q!\u00138uK\u001e,'/\u0001\u000fj]6+Wn\u001c:z!J|'.Z2uS>tG\u000b\u001b:fg\"|G\u000e\u001a\u0011\u0002\u0019\u001d,G/\u00138eKbt\u0015-\\3\u0016\u0003E\f\u0011dY8naV$XmQ1oI&$\u0017\r^3GS2,g*Y7fgRa\u0011qGA\"\u0003\u001b\n\u0019'a\u001a\u0002\u0012B1\u00111CA\u001d\u0003{I1!a\u000fb\u0005\u0019y\u0005\u000f^5p]B!!/a\u0010r\u0013\r\t\t\u0005\u001f\u0002\u0004'\u0016$\bbBA#\u0015\u0001\u0007\u0011qI\u0001\nM&dW-\u00138eKb\u00042ALA%\u0013\r\tY%\n\u0002\u0010\u0011>|G-[3GS2,\u0017J\u001c3fq\"9\u0011q\n\u0006A\u0002\u0005E\u0013\u0001D9vKJLh)\u001b7uKJ\u001c\b\u0003\u00024o\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0006fqB\u0014Xm]:j_:\u001c(bAA/i\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002b\u0005]#AC#yaJ,7o]5p]\"1\u0011Q\r\u0006A\u0002\u0015\fa#];fef\u0014VMZ3sK:\u001cW\rZ\"pYVlgn\u001d\u0005\b\u0003SR\u0001\u0019AA6\u0003u\u0001(/\u001e8fIB\u000b'\u000f^5uS>t7/\u00118e\r&dWm\u00157jG\u0016\u001c\b\u0003\u00024o\u0003[\u0002\u0002\"a\u0005\u0002p\u0005M\u00141Q\u0005\u0004\u0003c\n'A\u0002+va2,'\u0007\u0005\u0004\u0002\u0014\u0005e\u0012Q\u000f\t\u0005\u0003o\niHD\u0002/\u0003sJ1!a\u001f&\u0003a\u0011\u0015m]3I_>$\u0017.\u001a+bE2,g)\u001b7f\u0013:$W\r_\u0005\u0005\u0003\u007f\n\tIA\u0007QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u0006\u0004\u0003w*\u0003\u0003\u00024o\u0003\u000b\u0003B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017+\u0015!B7pI\u0016d\u0017\u0002BAH\u0003\u0013\u0013\u0011BR5mKNc\u0017nY3\t\u000f\u0005M%\u00021\u0001\u0002\u0016\u0006I2\u000f[8vY\u0012\u0004Vo\u001d5E_^tg)\u001b7fg\u001aKG\u000e^3s!\u0011\t\u0019\"a&\n\u0007\u0005e\u0015MA\u0004C_>dW-\u00198\u0002\u001d1|\u0017\r\u001a+sC:\u001c\bo\\:fIV!\u0011qTAT))\t\t+a1\u0002H\u0006-\u0017\u0011\u001e\u000b\u0005\u0003G\u000bI\f\u0005\u0003\u0002&\u0006\u001dF\u0002\u0001\u0003\b\u0003S[!\u0019AAV\u0005\u0005!\u0016\u0003BAW\u0003g\u0003B!a\u0005\u00020&\u0019\u0011\u0011W1\u0003\u000f9{G\u000f[5oOB!\u00111CA[\u0013\r\t9,\u0019\u0002\u0004\u0003:L\bbBA^\u0017\u0001\u0007\u0011QX\u0001\u0006E2|7m\u001b\t\b\u0003'\ty,_AR\u0013\r\t\t-\u0019\u0002\n\rVt7\r^5p]FBa!!2\f\u0001\u0004)\u0017!\u0004;be\u001e,GoQ8mk6t7\u000fC\u0004\u0002J.\u0001\r!!&\u0002%MDw.\u001e7e%\u0016\fG-\u00138NK6|'/\u001f\u0005\b\u0003\u001b\\\u0001\u0019AAh\u00039\u0019w\u000e\\*uCR\u0014VmY8sIN\u0004b!!5\u0002X\u0006mWBAAj\u0015\r\t).R\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0002Z\u0006M'A\u0003%p_\u0012LW\rR1uCB!\u0011Q\\As\u001b\t\tyN\u0003\u0003\u0002\f\u0006\u0005(bAArK\u0005!\u0011M\u001e:p\u0013\u0011\t9/a8\u00033!{w\u000eZ5f\u001b\u0016$\u0018\rZ1uC\u000e{G.^7o'R\fGo\u001d\u0005\b\u0003W\\\u0001\u0019AA*\u0003Q)\u0007\u0010\u001d:fgNLwN\\%oI\u0016D\u0018+^3ss\u0006IAO]1ogB|7/\u001a\u000b\t\u0003c\fY0a@\u0003\u0004A9\u00111CA8\u0003gT\u0004CBAi\u0003/\f)\u0010E\u00024\u0003oL1!!?5\u0005\r\u0011vn\u001e\u0005\b\u0003{d\u0001\u0019AAh\u0003=\u0019w\u000e\\*uCR\u001c(+Z2pe\u0012\u001c\bB\u0002B\u0001\u0019\u0001\u0007Q-\u0001\u0007rk\u0016\u0014\u0018pQ8mk6t7\u000fC\u0004\u0002l2\u0001\r!a\u0015\u0002%\r|W\u000e]8tK&sG-\u001a=TG\",W.\u0019\u000b\u000b\u0005\u0013\u0011YAa\u0004\u0003\u0014\tU\u0001CBA\n\u0003_RT\r\u0003\u0004\u0003\u000e5\u0001\r!Z\u0001\u0012i\u0006\u0014x-\u001a;D_2,XN\u001c(b[\u0016\u001c\bb\u0002B\t\u001b\u0001\u0007\u0011QH\u0001\u000fS:$W\r_3e\u0007>dW/\u001c8t\u0011\u0015IT\u00021\u0001;\u0011\u001d\tY/\u0004a\u0001\u0003'\n1\u0004\\8bI\u000e{G.^7o'R\fGo]%oI\u0016D(+Z2pe\u0012\u001cH\u0003CAh\u00057\u0011iB!\t\t\r\u0005\u0015g\u00021\u0001f\u0011%\u0011yB\u0004I\u0001\u0002\u0004\t9$\u0001\tqeVtW\r\u001a)beRLG/[8og\"9\u0011\u0011\u001a\bA\u0002\u0005U\u0015!\n7pC\u0012\u001cu\u000e\\;n]N#\u0018\r^:J]\u0012,\u0007PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119C\u000b\u0003\u00028\t%2F\u0001B\u0016!\u0011\u0011iCa\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0005g\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tU\u0012-\u0001\u0006b]:|G/\u0019;j_:LAA!\u000f\u00030\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!%tg/\u00197jI\u0006$XmQ1dQ\u0016\u001cHC\u0001B !\u0011\t\u0019B!\u0011\n\u0007\t\r\u0013M\u0001\u0003V]&$\u0018\u0001E5t\u0013:$W\r_!wC&d\u0017M\u00197f+\t\t)*\u0001\u0013gS2$XM])vKJLWm],ji\"4UO\\2uS>t\u0017\r\u001c$jYR,'oS3z)\u0019\u0011iEa\u0016\u0003ZA)aMa\u0014\u0003T%\u0019!\u0011\u000b9\u0003\t1K7\u000f\u001e\t\t\u0003'\ty'a\u0015\u0003VA!aMa\u0014r\u0011\u001d\tyE\u0005a\u0001\u0003#BqAa\u0017\u0013\u0001\u0004\u0011i&\u0001\bt_V\u00148-\u001a$jK2$w\n\u001d;\u0011\u000b\u0005M\u0011\u0011H9\u0002M\u001d,G/\u0012=qe\u0016\u001c8/[8o\u0013:$W\r\u001f)beRLG/[8o\u0003:$G*\u001b;fe\u0006d7\u000f\u0006\u0003\u0003d\t-\u0004CBA\n\u0003s\u0011)\u0007E\u0005\u0002\u0014\t\u001d\u0014/a\u0015\u0003V%\u0019!\u0011N1\u0003\rQ+\b\u000f\\34\u0011\u001d\tye\u0005a\u0001\u0003#\nq#\u001a=ue\u0006\u001cG/U;fef\fe\u000e\u001a'ji\u0016\u0014\u0018\r\\:\u0015\r\tE$1\u000fB;!\u0019\t\u0019\"!\u000f\u0003T!9\u0011q\n\u000bA\u0002\u0005E\u0003b\u0002B<)\u0001\u0007!\u0011P\u0001\u0010S:$W\r\u001f#fM&t\u0017\u000e^5p]B!\u0011q\u0011B>\u0013\u0011\u0011i(!#\u0003+!{w\u000eZ5f\u0013:$W\r\u001f#fM&t\u0017\u000e^5p]\u0006QBn\\1e\u000bb\u0004(/Z:tS>t\u0017J\u001c3fqJ+7m\u001c:egRA\u0011q\u001aBB\u0005\u000f\u0013I\t\u0003\u0004\u0003\u0006V\u0001\r!]\u0001\u000fS:$W\r\u001f)beRLG/[8o\u0011\u001d\u0011y\"\u0006a\u0001\u0003{Aq!!3\u0016\u0001\u0004\t)*\u0001\u000fm_\u0006$W\t\u001f9sKN\u001c\u0018n\u001c8J]\u0012,\u0007\u0010R1uC\u001a\u0013\u0018-\\3\u0015\u000fe\u0014yI!%\u0003\u0014\"1!Q\u0011\fA\u0002EDqAa\b\u0017\u0001\u0004\ti\u0004C\u0004\u0002JZ\u0001\r!!&\u0002K1|\u0017\rZ#yaJ,7o]5p]&sG-\u001a=G_J\u001cu\u000e\\;n]NLe\u000e^3s]\u0006dGCCAh\u00053\u0013YJ!(\u0003 \"1\u0011QY\fA\u0002\u0015DqAa\b\u0018\u0001\u0004\ti\u0004\u0003\u0004\u0003\u0006^\u0001\r!\u001d\u0005\b\u0003\u0013<\u0002\u0019AAK\u0003\t:W\r\u001e)sk:,G\rU1si&$\u0018n\u001c8t\u0003:$g)\u001b7f\u001d\u0006lWm]'baR1!Q\u0015BV\u0005[\u0003bA\u001dBTc\u0006u\u0012b\u0001BUq\n\u0019Q*\u00199\t\u000f\u0005%\u0004\u00041\u0001\u0002l!I!q\u0016\r\u0011\u0002\u0003\u0007\u0011QS\u0001\u0010S:\u001cG.\u001e3f\u0019><g)\u001b7fg\u0006as-\u001a;QeVtW\r\u001a)beRLG/[8og\u0006sGMR5mK:\u000bW.Z:NCB$C-\u001a4bk2$HEM\u000b\u0003\u0005kSC!!&\u0003*\u0005Ar-\u001a;DC:$\u0017\u000eZ1uK\u001aKG.Z:G_J\\U-_:\u0015\u0011\u0005u\"1\u0018B_\u0005\u0003DaA!\"\u001b\u0001\u0004\t\bb\u0002B`5\u0001\u0007!QU\u0001\u001caJ,h.\u001a3QCJ$\u0018\u000e^5p]\u0006sGMR5mK:\u000bW.Z:\t\u000f\t\r'\u00041\u0001\u0003V\u0005!1.Z=t\u0003Y)\u0005\u0010\u001d:fgNLwN\\%oI\u0016D8+\u001e9q_J$\bC\u0001\u0018\u001d'\ra\"1\u001a\t\u0005\u0003'\u0011i-C\u0002\u0003P\u0006\u0014a!\u00118z%\u00164GC\u0001Bd\u0003)Ie\nR#Y?:\u000bU*R\u000b\u0003\u0005/\u0004B!a\b\u0003Z&\u0019q/!\t\u0002\u0017%sE)\u0012-`\u001d\u0006kU\tI\u0001\u001ei\u0006\u0014x-\u001a;D_2,XN\\*uCR\u001c\u0018J\u001c3fq\u000e{G.^7ogV\u0011!\u0011\u001d\t\u0007\u0005G\u0014)Oa6\u000e\u0003}K!a\\0\u0002=Q\f'oZ3u\u0007>dW/\u001c8Ti\u0006$8/\u00138eKb\u001cu\u000e\\;n]N\u0004\u0013aG2pYVlgn\u0015;biN\u0014VmY8sIN#(/^2u)f\u0004X-F\u0001;\u0003q\u0019w\u000e\\;n]N#\u0018\r^:SK\u000e|'\u000fZ*ueV\u001cG\u000fV=qK\u0002\u0002")
public class ExpressionIndexSupport
extends SparkBaseIndexSupport {
    private transient ParHashMap<Seq<String>, Dataset<Row>> cachedColumnStatsIndexViews;
    private final SparkSession spark;
    private final StructType tableSchema;
    private final HoodieMetadataConfig metadataConfig;
    private final HoodieTableMetaClient metaClient;
    private final Integer inMemoryProjectionThreshold;
    private volatile transient boolean bitmap$trans$0;

    public static String INDEX_NAME() {
        return ExpressionIndexSupport$.MODULE$.INDEX_NAME();
    }

    private ParHashMap<Seq<String>, Dataset<Row>> cachedColumnStatsIndexViews$lzycompute() {
        ExpressionIndexSupport expressionIndexSupport = this;
        synchronized (expressionIndexSupport) {
            if (!this.bitmap$trans$0) {
                this.cachedColumnStatsIndexViews = (ParHashMap)ParHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.bitmap$trans$0 = true;
            }
        }
        return this.cachedColumnStatsIndexViews;
    }

    private ParHashMap<Seq<String>, Dataset<Row>> cachedColumnStatsIndexViews() {
        if (!this.bitmap$trans$0) {
            return this.cachedColumnStatsIndexViews$lzycompute();
        }
        return this.cachedColumnStatsIndexViews;
    }

    private Integer inMemoryProjectionThreshold() {
        return this.inMemoryProjectionThreshold;
    }

    @Override
    public String getIndexName() {
        return ExpressionIndexSupport$.MODULE$.INDEX_NAME();
    }

    @Override
    public Option<Set<String>> computeCandidateFileNames(HoodieFileIndex fileIndex, Seq<Expression> queryFilters, Seq<String> queryReferencedColumns, Seq<Tuple2<Option<BaseHoodieTableFileIndex.PartitionPath>, Seq<FileSlice>>> prunedPartitionsAndFileSlices, boolean shouldPushDownFilesFilter) {
        LazyRef expressionIndexPartitionOpt$lzy = new LazyRef();
        if (this.isIndexAvailable() && queryFilters.nonEmpty() && this.expressionIndexPartitionOpt$1(expressionIndexPartitionOpt$lzy, queryFilters).nonEmpty()) {
            Tuple3 tuple3 = (Tuple3)this.expressionIndexPartitionOpt$1(expressionIndexPartitionOpt$lzy, queryFilters).get();
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String indexPartition = (String)tuple3._1();
            Expression expressionIndexQuery = (Expression)tuple3._2();
            List literals = (List)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)indexPartition, (Object)expressionIndexQuery, (Object)literals);
            String indexPartition2 = (String)tuple32._1();
            Expression expressionIndexQuery2 = (Expression)tuple32._2();
            List literals2 = (List)tuple32._3();
            HoodieIndexDefinition indexDefinition = this.metaClient.getIndexMetadata().get().getIndexDefinitions().get(indexPartition2);
            if (indexDefinition.getIndexType().equals("column_stats")) {
                boolean readInMemory = this.shouldReadInMemory(fileIndex, queryReferencedColumns, this.inMemoryProjectionThreshold());
                Tuple2<Set<String>, Set<String>> tuple2 = this.getPrunedPartitionsAndFileNames(fileIndex, prunedPartitionsAndFileSlices);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Set prunedPartitions = (Set)tuple2._1();
                Set prunedFileNames = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)prunedPartitions, (Object)prunedFileNames);
                Set prunedPartitions2 = (Set)tuple22._1();
                Set prunedFileNames2 = (Set)tuple22._2();
                HoodieData<HoodieMetadataColumnStats> expressionIndexRecords = this.loadExpressionIndexRecords(indexPartition2, (Set<String>)prunedPartitions2, readInMemory);
                return (Option)this.loadTransposed(queryReferencedColumns, readInMemory, expressionIndexRecords, expressionIndexQuery2, (Function1 & Serializable & scala.Serializable)transposedColStatsDF -> new Some(this.getCandidateFiles((Dataset<Row>)transposedColStatsDF, (Seq<Expression>)((Seq)new .colon.colon((Object)expressionIndexQuery2, (List)Nil$.MODULE$)), (Set<String>)prunedFileNames2, true)));
            }
            if (indexDefinition.getIndexType().equals("bloom_filters")) {
                scala.collection.immutable.Map<String, Set<String>> prunedPartitionAndFileNames = this.getPrunedPartitionsAndFileNamesMap(prunedPartitionsAndFileSlices, true);
                return Option$.MODULE$.apply(this.getCandidateFilesForKeys(indexPartition2, prunedPartitionAndFileNames, (List<String>)literals2));
            }
            return Option$.MODULE$.empty();
        }
        return Option$.MODULE$.empty();
    }

    public <T> T loadTransposed(Seq<String> targetColumns, boolean shouldReadInMemory, HoodieData<HoodieMetadataColumnStats> colStatRecords, Expression expressionIndexQuery, Function1<Dataset<Row>, T> block) {
        Option option = this.cachedColumnStatsIndexViews().get(targetColumns);
        if (option instanceof Some) {
            Some some = (Some)option;
            Dataset cachedDF = (Dataset)some.value();
            return (T)block.apply((Object)cachedDF);
        }
        if (None$.MODULE$.equals(option)) {
            HoodieData<HoodieMetadataColumnStats> colStatsRecords = colStatRecords;
            return HoodieCatalystUtils$.MODULE$.withPersistedData(colStatsRecords, StorageLevel$.MODULE$.MEMORY_ONLY(), (Function0 & Serializable & scala.Serializable)() -> {
                Dataset<Row> dataset;
                Tuple2<HoodieData<Row>, StructType> tuple2 = this.transpose(colStatsRecords, targetColumns, expressionIndexQuery);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                HoodieData transposedRows = (HoodieData)tuple2._1();
                StructType indexSchema = (StructType)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)transposedRows, (Object)indexSchema);
                HoodieData transposedRows2 = (HoodieData)tuple22._1();
                StructType indexSchema2 = (StructType)tuple22._2();
                if (shouldReadInMemory) {
                    dataset = HoodieUnsafeUtils$.MODULE$.createDataFrameFromRows($this.spark, (Seq<Row>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(transposedRows2.collectAsList()).asScala()).toSeq(), indexSchema2);
                } else {
                    JavaRDD rdd = HoodieJavaRDD.getJavaRDD(transposedRows2);
                    dataset = $this.spark.createDataFrame(rdd, indexSchema2);
                }
                Dataset<Row> df = dataset;
                boolean allowCaching = false;
                if (allowCaching) {
                    this.cachedColumnStatsIndexViews().put((Object)targetColumns, df);
                    df.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
                    return block.apply(df);
                }
                return HoodieCatalystUtils$.MODULE$.withPersistedDataset(df, HoodieCatalystUtils$.MODULE$.withPersistedDataset$default$2(), (Function0 & Serializable & scala.Serializable)() -> block.apply((Object)df));
            });
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<HoodieData<Row>, StructType> transpose(HoodieData<HoodieMetadataColumnStats> colStatsRecords, Seq<String> queryColumns, Expression expressionIndexQuery) {
        scala.collection.immutable.Map tableSchemaFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        TreeSet sortedTargetColumnsSet = (TreeSet)TreeSet$.MODULE$.apply(queryColumns, (Ordering)Ordering.String$.MODULE$);
        Set indexedColumns = queryColumns.toSet();
        Tuple2<StructType, Seq<String>> tuple2 = this.composeIndexSchema((Seq<String>)sortedTargetColumnsSet.toSeq(), (Set<String>)indexedColumns, this.tableSchema, expressionIndexQuery);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType indexSchema = (StructType)tuple2._1();
        Seq targetIndexedColumns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexSchema, (Object)targetIndexedColumns);
        StructType indexSchema2 = (StructType)tuple22._1();
        Seq targetIndexedColumns2 = (Seq)tuple22._2();
        HoodieData transposedRows = colStatsRecords.filter(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)r -> Predef$.MODULE$.boolean2Boolean(sortedTargetColumnsSet.contains((Object)r.getColumnName())))).mapToPair(JFunction$.MODULE$.toJavaSerializablePairFunction((Function1 & Serializable & scala.Serializable)r -> {
            if (r.getMinValue() == null && r.getMaxValue() == null) {
                return Pair.of(r.getFileName(), r);
            }
            Object minValueWrapper = r.getMinValue();
            Object maxValueWrapper = r.getMaxValue();
            ValidationUtils.checkState(minValueWrapper != null && maxValueWrapper != null, "Invalid Column Stats record: either both min/max have to be null, or both have to be non-null");
            String colName = r.getColumnName();
            DataType colType = ((StructField)tableSchemaFieldMap.apply((Object)colName)).dataType();
            Object minValue = ColumnStatsIndexSupport$.MODULE$.deserialize(ColumnStatsIndexSupport$.MODULE$.tryUnpackValueWrapper(minValueWrapper), colType);
            Object maxValue = ColumnStatsIndexSupport$.MODULE$.deserialize(ColumnStatsIndexSupport$.MODULE$.tryUnpackValueWrapper(maxValueWrapper), colType);
            r.setMinValue(minValue);
            r.setMaxValue(maxValue);
            return Pair.of(r.getFileName(), r);
        })).groupByKey().map(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)p -> {
            Seq columnRecordsSeq = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)p.getValue()).asScala()).toSeq();
            String fileName = (String)p.getKey();
            long valueCount = Predef$.MODULE$.Long2long(((HoodieMetadataColumnStats)((Object)((Object)columnRecordsSeq.head()))).getValueCount());
            scala.collection.immutable.Map columnRecordsMap = ((TraversableOnce)columnRecordsSeq.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getColumnName(), (Object)r), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq alignedColStatRecordsSeq = (Seq)targetIndexedColumns2.map((Function1 & Serializable & scala.Serializable)key -> columnRecordsMap.get(key), Seq$.MODULE$.canBuildFrom());
            ListBuffer coalescedRowValuesSeq = (ListBuffer)alignedColStatRecordsSeq.foldLeft((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, BoxesRunTime.boxToLong((long)valueCount)})), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    ListBuffer acc = (ListBuffer)tuple2._1();
                    Option opt = (Option)tuple2._2();
                    Option option = opt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        HoodieMetadataColumnStats colStatRecord = (HoodieMetadataColumnStats)((Object)((Object)((Object)some.value())));
                        return acc.$plus$plus$eq((TraversableOnce)new .colon.colon(colStatRecord.getMinValue(), (List)new .colon.colon(colStatRecord.getMaxValue(), (List)new .colon.colon((Object)colStatRecord.getNullCount(), (List)Nil$.MODULE$))));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return acc.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null})));
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)tuple2);
            });
            return Row$.MODULE$.apply(coalescedRowValuesSeq.toSeq());
        }));
        return new Tuple2(transposedRows, (Object)indexSchema2);
    }

    public Tuple2<StructType, Seq<String>> composeIndexSchema(Seq<String> targetColumnNames, Set<String> indexedColumns, StructType tableSchema, Expression expressionIndexQuery) {
        DataType dataType;
        StructField fileNameField = new StructField("fileName", (DataType)StringType$.MODULE$, true, Metadata$.MODULE$.empty());
        StructField valueCountField = new StructField("valueCount", (DataType)LongType$.MODULE$, true, Metadata$.MODULE$.empty());
        Seq targetIndexedColumns = (Seq)targetColumnNames.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)indexedColumns.contains((Object)x$5)));
        Seq targetIndexedFields = (Seq)targetIndexedColumns.map((Function1 & Serializable & scala.Serializable)colName -> (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ExpressionIndexSupport.$anonfun$composeIndexSchema$3(colName, f))).get(), Seq$.MODULE$.canBuildFrom());
        Expression expression = expressionIndexQuery;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            dataType = ((Literal)equalTo.right()).dataType();
        } else if (expression instanceof In) {
            In in = (In)expression;
            dataType = ((Literal)in.list().apply(0)).dataType();
        } else {
            dataType = ((StructField)targetIndexedFields.apply(0)).dataType();
        }
        DataType dataType2 = dataType;
        return new Tuple2((Object)StructType$.MODULE$.apply((Seq)targetIndexedFields.foldLeft((Object)new .colon.colon((Object)fileNameField, (List)new .colon.colon((Object)valueCountField, (List)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                StructField field = (StructField)tuple2._2();
                return (Seq)acc.$plus$plus((GenTraversableOnce)new .colon.colon((Object)ColumnStatsIndexSupport$.MODULE$.composeColumnStatStructType(field.name(), "minValue", dataType2), (List)new .colon.colon((Object)ColumnStatsIndexSupport$.MODULE$.composeColumnStatStructType(field.name(), "maxValue", dataType2), (List)new .colon.colon((Object)ColumnStatsIndexSupport$.MODULE$.composeColumnStatStructType(field.name(), "nullCount", (DataType)LongType$.MODULE$), (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        })), (Object)targetIndexedColumns);
    }

    public HoodieData<HoodieMetadataColumnStats> loadColumnStatsIndexRecords(Seq<String> targetColumns, Option<Set<String>> prunedPartitions, boolean shouldReadInMemory) {
        ValidationUtils.checkState(targetColumns.nonEmpty());
        Seq encodedTargetColumnNames = (Seq)targetColumns.map((Function1 & Serializable & scala.Serializable)colName -> new ColumnIndexID((String)colName).asBase64EncodedString(), Seq$.MODULE$.canBuildFrom());
        Seq keyPrefixes = prunedPartitions.isDefined() ? (Iterable)((TraversableLike)((SetLike)prunedPartitions.get()).map((Function1 & Serializable & scala.Serializable)partitionPath -> new PartitionIndexID(HoodieTableMetadataUtil.getPartitionIdentifier(partitionPath)).asBase64EncodedString(), Set$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)encodedPartition -> (Seq)encodedTargetColumnNames.map((Function1 & Serializable & scala.Serializable)encodedTargetColumn -> encodedTargetColumn.concat((String)encodedPartition), Seq$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()) : encodedTargetColumnNames;
        HoodieData<HoodieRecord<HoodieMetadataPayload>> metadataRecords = this.metadataTable().getRecordsByKeyPrefixes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyPrefixes.toSeq()).asJava(), "column_stats", shouldReadInMemory);
        HoodieData<HoodieMetadataColumnStats> columnStatsRecords = metadataRecords.map(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)record -> (HoodieMetadataColumnStats)((Object)((Object)HoodieConversionUtils$.MODULE$.toScalaOption(((HoodieMetadataPayload)record.getData()).getInsertValue(null, null)).map((Function1 & Serializable & scala.Serializable)metadataRecord -> ((HoodieMetadataRecord)((Object)((Object)metadataRecord))).getColumnStatsMetadata()).orNull(Predef$.MODULE$.$conforms()))))).filter(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)columnStatsRecord -> Predef$.MODULE$.boolean2Boolean(columnStatsRecord != null)));
        return columnStatsRecords;
    }

    public Option<Set<String>> loadColumnStatsIndexRecords$default$2() {
        return None$.MODULE$;
    }

    @Override
    public void invalidateCaches() {
        this.cachedColumnStatsIndexViews().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Dataset df = (Dataset)tuple2._2();
                return df.unpersist();
            }
            throw new MatchError((Object)tuple2);
        });
        this.cachedColumnStatsIndexViews().clear();
    }

    @Override
    public boolean isIndexAvailable() {
        return this.metadataConfig.isEnabled() && this.metaClient.getIndexMetadata().isPresent() && !this.metaClient.getIndexMetadata().get().getIndexDefinitions().isEmpty();
    }

    private List<Tuple2<Expression, List<String>>> filterQueriesWithFunctionalFilterKey(Seq<Expression> queryFilters, Option<String> sourceFieldOpt) {
        ObjectRef expressionIndexQueries = ObjectRef.create((Object)List$.MODULE$.empty());
        queryFilters.foreach((Function1 & Serializable & scala.Serializable)query -> {
            ExpressionIndexSupport.$anonfun$filterQueriesWithFunctionalFilterKey$1(sourceFieldOpt, expressionIndexQueries, query);
            return BoxedUnit.UNIT;
        });
        return (List)expressionIndexQueries.elem;
    }

    private Option<Tuple3<String, Expression, List<String>>> getExpressionIndexPartitionAndLiterals(Seq<Expression> queryFilters) {
        Map indexDefinitions = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.metaClient.getIndexMetadata().get().getIndexDefinitions()).asScala();
        if (indexDefinitions.nonEmpty()) {
            List functionDefinitions = ((TraversableOnce)indexDefinitions.values().filter((Function1 & Serializable & scala.Serializable)definition -> BoxesRunTime.boxToBoolean((boolean)ExpressionIndexSupport.$anonfun$getExpressionIndexPartitionAndLiterals$1(definition)))).toList();
            ObjectRef indexPartitionAndLiteralsOpt = ObjectRef.create((Object)Option$.MODULE$.empty());
            functionDefinitions.foreach((Function1 & Serializable & scala.Serializable)indexDefinition -> {
                ExpressionIndexSupport.$anonfun$getExpressionIndexPartitionAndLiterals$2(this, queryFilters, indexPartitionAndLiteralsOpt, indexDefinition);
                return BoxedUnit.UNIT;
            });
            return (Option)indexPartitionAndLiteralsOpt.elem;
        }
        return Option$.MODULE$.empty();
    }

    private Option<Tuple2<Expression, List<String>>> extractQueryAndLiterals(Seq<Expression> queryFilters, HoodieIndexDefinition indexDefinition) {
        List<Tuple2<Expression, List<String>>> expressionIndexQueries = this.filterQueriesWithFunctionalFilterKey(queryFilters, (Option<String>)Option$.MODULE$.apply((Object)indexDefinition.getSourceFields().get(0)));
        ObjectRef queryAndLiteralsOpt = ObjectRef.create((Object)Option$.MODULE$.empty());
        expressionIndexQueries.foreach((Function1 & Serializable & scala.Serializable)tuple -> {
            ExpressionIndexSupport.$anonfun$extractQueryAndLiterals$1(indexDefinition, queryAndLiteralsOpt, tuple);
            return BoxedUnit.UNIT;
        });
        return (Option)queryAndLiteralsOpt.elem;
    }

    private HoodieData<HoodieMetadataColumnStats> loadExpressionIndexRecords(String indexPartition, Set<String> prunedPartitions, boolean shouldReadInMemory) {
        HoodieIndexDefinition indexDefinition = this.metaClient.getIndexMetadata().get().getIndexDefinitions().get(indexPartition);
        HoodieData<HoodieMetadataColumnStats> colStatsRecords = this.loadExpressionIndexForColumnsInternal((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexDefinition.getSourceFields()).asScala()).toSeq(), prunedPartitions, indexPartition, shouldReadInMemory);
        return colStatsRecords;
    }

    public Dataset<Row> loadExpressionIndexDataFrame(String indexPartition, Set<String> prunedPartitions, boolean shouldReadInMemory) {
        HoodieIndexDefinition indexDefinition = this.metaClient.getIndexMetadata().get().getIndexDefinitions().get(indexPartition);
        HoodieData<HoodieMetadataColumnStats> colStatsRecords = this.loadExpressionIndexForColumnsInternal((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexDefinition.getSourceFields()).asScala()).toSeq(), prunedPartitions, indexPartition, shouldReadInMemory);
        HoodieData catalystRows = colStatsRecords.map(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)r -> {
            Function1<GenericRecord, Option<InternalRow>> converter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(HoodieMetadataColumnStats.SCHEMA$, ExpressionIndexSupport$.MODULE$.org$apache$hudi$ExpressionIndexSupport$$columnStatsRecordStructType());
            return (InternalRow)((Option)converter.apply((Object)r)).orNull(Predef$.MODULE$.$conforms());
        }));
        Dataset<Row> colStatsDF = shouldReadInMemory ? HoodieUnsafeUtils$.MODULE$.createDataFrameFromInternalRows(this.spark, (Seq<InternalRow>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(catalystRows.collectAsList()).asScala()).toSeq(), ExpressionIndexSupport$.MODULE$.org$apache$hudi$ExpressionIndexSupport$$columnStatsRecordStructType()) : HoodieUnsafeUtils$.MODULE$.createDataFrameFromRDD(this.spark, (RDD<InternalRow>)JavaRDD$.MODULE$.toRDD(HoodieJavaRDD.getJavaRDD(catalystRows)), ExpressionIndexSupport$.MODULE$.org$apache$hudi$ExpressionIndexSupport$$columnStatsRecordStructType());
        return colStatsDF.select((Seq)ExpressionIndexSupport$.MODULE$.org$apache$hudi$ExpressionIndexSupport$$targetColumnStatsIndexColumns().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()));
    }

    private HoodieData<HoodieMetadataColumnStats> loadExpressionIndexForColumnsInternal(Seq<String> targetColumns, Set<String> prunedPartitions, String indexPartition, boolean shouldReadInMemory) {
        ValidationUtils.checkState(targetColumns.nonEmpty());
        Seq encodedTargetColumnNames = (Seq)targetColumns.map((Function1 & Serializable & scala.Serializable)colName -> new ColumnIndexID((String)colName).asBase64EncodedString(), Seq$.MODULE$.canBuildFrom());
        Seq keyPrefixes = prunedPartitions.nonEmpty() ? (Iterable)((TraversableLike)prunedPartitions.map((Function1 & Serializable & scala.Serializable)partitionPath -> new PartitionIndexID(HoodieTableMetadataUtil.getPartitionIdentifier(partitionPath)).asBase64EncodedString(), Set$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)encodedPartition -> (Seq)encodedTargetColumnNames.map((Function1 & Serializable & scala.Serializable)encodedTargetColumn -> encodedTargetColumn.concat((String)encodedPartition), Seq$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()) : encodedTargetColumnNames;
        HoodieData<HoodieRecord<HoodieMetadataPayload>> metadataRecords = this.metadataTable().getRecordsByKeyPrefixes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyPrefixes.toSeq()).asJava(), indexPartition, shouldReadInMemory);
        HoodieData<HoodieMetadataColumnStats> columnStatsRecords = metadataRecords.map(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)record -> (HoodieMetadataColumnStats)((Object)((Object)HoodieConversionUtils$.MODULE$.toScalaOption(((HoodieMetadataPayload)record.getData()).getInsertValue(null, null)).map((Function1 & Serializable & scala.Serializable)metadataRecord -> ((HoodieMetadataRecord)((Object)((Object)metadataRecord))).getColumnStatsMetadata()).orNull(Predef$.MODULE$.$conforms()))))).filter(JFunction$.MODULE$.toJavaSerializableFunction((Function1 & Serializable & scala.Serializable)columnStatsRecord -> Predef$.MODULE$.boolean2Boolean(columnStatsRecord != null)));
        return columnStatsRecords;
    }

    public scala.collection.immutable.Map<String, Set<String>> getPrunedPartitionsAndFileNamesMap(Seq<Tuple2<Option<BaseHoodieTableFileIndex.PartitionPath>, Seq<FileSlice>>> prunedPartitionsAndFileSlices, boolean includeLogFiles) {
        return (scala.collection.immutable.Map)prunedPartitionsAndFileSlices.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map partitionToFileMap = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Option partitionPathOpt = (Option)tuple22._1();
                    Seq fileSlices = (Seq)tuple22._2();
                    Option option = partitionPathOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BaseHoodieTableFileIndex.PartitionPath partitionPath = (BaseHoodieTableFileIndex.PartitionPath)some.value();
                        Set fileNames = ((TraversableOnce)fileSlices.flatMap((Function1 & Serializable & scala.Serializable)fileSlice -> {
                            Seq baseFile = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(fileSlice.getBaseFile().orElse(null)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getFileName())).toSeq();
                            Seq logFiles = includeLogFiles ? ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSlice.getLogFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getFileName()).toSeq() : (Seq)Nil$.MODULE$;
                            return (Seq)baseFile.$plus$plus((GenTraversableOnce)logFiles, Seq$.MODULE$.canBuildFrom());
                        }, Seq$.MODULE$.canBuildFrom())).toSet();
                        return partitionToFileMap.updated((Object)partitionPath.path, (Object)((SetLike)partitionToFileMap.getOrElse((Object)partitionPath.path, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$plus$plus((GenTraversableOnce)fileNames));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return partitionToFileMap;
                    }
                    throw new MatchError((Object)option);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public boolean getPrunedPartitionsAndFileNamesMap$default$2() {
        return false;
    }

    private Set<String> getCandidateFilesForKeys(String indexPartition, scala.collection.immutable.Map<String, Set<String>> prunedPartitionAndFileNames, List<String> keys2) {
        Set candidateFiles = ((TraversableOnce)prunedPartitionAndFileNames.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String partition = (String)tuple2._1();
                Set fileNames = (Set)tuple2._2();
                return (Set)fileNames.filter((Function1 & Serializable & scala.Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)ExpressionIndexSupport.$anonfun$getCandidateFilesForKeys$2(this, partition, indexPartition, keys2, fileName)));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        return candidateFiles;
    }

    private final /* synthetic */ Option expressionIndexPartitionOpt$lzycompute$1(LazyRef expressionIndexPartitionOpt$lzy$1, Seq queryFilters$1) {
        Option option;
        LazyRef lazyRef = expressionIndexPartitionOpt$lzy$1;
        synchronized (lazyRef) {
            option = expressionIndexPartitionOpt$lzy$1.initialized() ? (Option)expressionIndexPartitionOpt$lzy$1.value() : (Option)expressionIndexPartitionOpt$lzy$1.initialize(this.getExpressionIndexPartitionAndLiterals((Seq<Expression>)queryFilters$1));
        }
        return option;
    }

    private final Option expressionIndexPartitionOpt$1(LazyRef expressionIndexPartitionOpt$lzy$1, Seq queryFilters$1) {
        if (expressionIndexPartitionOpt$lzy$1.initialized()) {
            return (Option)expressionIndexPartitionOpt$lzy$1.value();
        }
        return this.expressionIndexPartitionOpt$lzycompute$1(expressionIndexPartitionOpt$lzy$1, queryFilters$1);
    }

    public static final /* synthetic */ boolean $anonfun$composeIndexSchema$3(String colName$1, StructField f) {
        String string = f.name();
        String string2 = colName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$filterQueriesWithFunctionalFilterKey$3(ObjectRef expressionIndexQueries$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression exp = (Expression)tuple2._1();
            List literals = (List)tuple2._2();
            if (exp != null) {
                Expression expression = exp;
                if (literals != null) {
                    List list = literals;
                    expressionIndexQueries$1.elem = (List)((List)expressionIndexQueries$1.elem).$colon$plus((Object)new Tuple2((Object)expression, (Object)list), List$.MODULE$.canBuildFrom());
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$filterQueriesWithFunctionalFilterKey$1(Option sourceFieldOpt$1, ObjectRef expressionIndexQueries$1, Expression query) {
        Function1 & Serializable & scala.Serializable attributeFetcher = (Function1 & Serializable & scala.Serializable)expr -> {
            Expression expression = expr;
            if (expression instanceof UnaryExpression) {
                UnaryExpression unaryExpression = (UnaryExpression)expression;
                return (Expression)unaryExpression.child();
            }
            if (expression instanceof FromUnixTime) {
                FromUnixTime fromUnixTime = (FromUnixTime)expression;
                return fromUnixTime.sec();
            }
            return expression;
        };
        RecordLevelIndexSupport$.MODULE$.filterQueryWithRecordKey(query, (Option<String>)sourceFieldOpt$1, (Function1<Expression, Expression>)attributeFetcher).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExpressionIndexSupport.$anonfun$filterQueriesWithFunctionalFilterKey$3(expressionIndexQueries$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getExpressionIndexPartitionAndLiterals$1(HoodieIndexDefinition definition) {
        return MetadataPartitionType.fromPartitionPath(definition.getIndexName()).equals((Object)MetadataPartitionType.EXPRESSION_INDEX);
    }

    public static final /* synthetic */ void $anonfun$getExpressionIndexPartitionAndLiterals$2(ExpressionIndexSupport $this, Seq queryFilters$2, ObjectRef indexPartitionAndLiteralsOpt$1, HoodieIndexDefinition indexDefinition) {
        Option<Tuple2<Expression, List<String>>> queryInfoOpt = $this.extractQueryAndLiterals((Seq<Expression>)queryFilters$2, indexDefinition);
        if (queryInfoOpt.isDefined()) {
            indexPartitionAndLiteralsOpt$1.elem = Option$.MODULE$.apply((Object)new Tuple3((Object)indexDefinition.getIndexName(), ((Tuple2)queryInfoOpt.get())._1(), ((Tuple2)queryInfoOpt.get())._2()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$extractQueryAndLiterals$1(HoodieIndexDefinition indexDefinition$1, ObjectRef queryAndLiteralsOpt$1, Tuple2 tuple) {
        Tuple2 tuple2 = new Tuple2(tuple._1(), tuple._2());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression expr2 = (Expression)tuple2._1();
        List literals = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)expr2, (Object)literals);
        Expression expr3 = (Expression)tuple22._1();
        List literals2 = (List)tuple22._2();
        String string = expr3.toString();
        Option functionNameOption = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(HoodieSparkExpressionIndex.SPARK_FUNCTION_MAP).asScala()).keys().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.contains(x$1)));
        String functionName = (String)functionNameOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> "identity");
        if (indexDefinition$1.getIndexFunction().equals(functionName)) {
            Function1 & Serializable & scala.Serializable attributeFetcher = (Function1 & Serializable & scala.Serializable)expr -> {
                Expression expression = expr;
                if (expression instanceof UnaryExpression) {
                    UnaryExpression unaryExpression = (UnaryExpression)expression;
                    return (Expression)unaryExpression.child();
                }
                if (expression instanceof FromUnixTime) {
                    FromUnixTime fromUnixTime = (FromUnixTime)expression;
                    return fromUnixTime.sec();
                }
                return expression;
            };
            if (functionName.equals("from_unixtime")) {
                String configuredFormat = indexDefinition$1.getIndexOptions().getOrDefault("format", TimestampFormatter$.MODULE$.defaultPattern());
                if (expr3.toString().contains(configuredFormat)) {
                    Expression pruningExpr = (Expression)((Tuple2)((Option)RecordLevelIndexSupport$.MODULE$.fetchQueryWithAttribute(expr3, (Option<String>)Option$.MODULE$.apply((Object)indexDefinition$1.getSourceFields().get(0)), RecordLevelIndexSupport$.MODULE$.getSimpleLiteralGenerator(), (Function1<Expression, Expression>)attributeFetcher)._1()).get())._1();
                    queryAndLiteralsOpt$1.elem = Option$.MODULE$.apply((Object)new Tuple2((Object)pruningExpr, (Object)literals2));
                    return;
                }
                return;
            }
            Expression pruningExpr = (Expression)((Tuple2)((Option)RecordLevelIndexSupport$.MODULE$.fetchQueryWithAttribute(expr3, (Option<String>)Option$.MODULE$.apply((Object)indexDefinition$1.getSourceFields().get(0)), RecordLevelIndexSupport$.MODULE$.getSimpleLiteralGenerator(), (Function1<Expression, Expression>)attributeFetcher)._1()).get())._1();
            queryAndLiteralsOpt$1.elem = Option$.MODULE$.apply((Object)new Tuple2((Object)pruningExpr, (Object)literals2));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getCandidateFilesForKeys$2(ExpressionIndexSupport $this, String partition$1, String indexPartition$1, List keys$1, String fileName) {
        Option<BloomFilter> bloomFilterOpt = HoodieConversionUtils$.MODULE$.toScalaOption($this.metadataTable().getBloomFilter(partition$1, fileName, indexPartition$1));
        Option<BloomFilter> option = bloomFilterOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            BloomFilter bloomFilter = (BloomFilter)some.value();
            return keys$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)bloomFilter.mightContain(x$1)));
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    public ExpressionIndexSupport(SparkSession spark, StructType tableSchema, HoodieMetadataConfig metadataConfig, HoodieTableMetaClient metaClient) {
        this.spark = spark;
        this.tableSchema = tableSchema;
        this.metadataConfig = metadataConfig;
        this.metaClient = metaClient;
        super(spark, metadataConfig, metaClient);
        this.inMemoryProjectionThreshold = metadataConfig.getColumnStatsIndexInMemoryProjectionThreshold();
    }
}

