/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieSchemaUtils$ {
    public static HoodieSchemaUtils$ MODULE$;
    private final Logger log;

    static {
        new HoodieSchemaUtils$();
    }

    private Logger log() {
        return this.log;
    }

    public scala.Option<InternalSchema> getLatestTableInternalSchema(HoodieConfig config, HoodieTableMetaClient tableMetaClient) {
        None$ none$;
        block4: {
            if (!config.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                return None$.MODULE$;
            }
            try {
                TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
                Option<InternalSchema> internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
                if (internalSchemaOpt.isPresent()) {
                    none$ = new Some((Object)internalSchemaOpt.get());
                    break block4;
                }
                none$ = None$.MODULE$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        scala.Option<Schema> option = latestTableSchemaOpt;
        if (None$.MODULE$.equals(option)) {
            return AvroInternalSchemaConverter.fixNullOrdering(sourceSchema);
        }
        if (option instanceof Some) {
            Schema canonicalizedSourceSchema;
            Some some = (Some)option;
            Schema latestTableSchemaWithMetaFields = (Schema)some.value();
            Schema latestTableSchema = AvroInternalSchemaConverter.fixNullOrdering(HoodieAvroUtils.removeMetadataFields(latestTableSchemaWithMetaFields));
            boolean shouldCanonicalizeSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().key(), (Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().defaultValue().toString()))).toBoolean();
            boolean shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().defaultValue().toString()))).toBoolean();
            Schema schema = shouldCanonicalizeSchema ? this.canonicalizeSchema(sourceSchema, latestTableSchema, opts, !shouldReconcileSchema) : (canonicalizedSourceSchema = AvroInternalSchemaConverter.fixNullOrdering(sourceSchema));
            if (shouldReconcileSchema) {
                return this.deduceWriterSchemaWithReconcile(sourceSchema, canonicalizedSourceSchema, latestTableSchema, internalSchemaOpt, opts);
            }
            return this.deduceWriterSchemaWithoutReconcile(sourceSchema, canonicalizedSourceSchema, latestTableSchema, opts);
        }
        throw new MatchError(option);
    }

    private Schema deduceWriterSchemaWithoutReconcile(Schema sourceSchema, Schema canonicalizedSourceSchema, Schema latestTableSchema, Map<String, String> opts) {
        block1: {
            boolean mergeIntoWrites = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().key(), (Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().defaultValue().toString()))).toBoolean();
            boolean shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), (Function0 & Serializable & scala.Serializable)() -> HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
            boolean allowAutoEvolutionColumnDrop = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key(), (Function0 & Serializable & scala.Serializable)() -> HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.defaultValue()))).toBoolean();
            boolean setNullForMissingColumns = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().defaultValue()))).toBoolean();
            if (!(mergeIntoWrites || shouldValidateSchemasCompatibility || allowAutoEvolutionColumnDrop)) {
                Schema reconciledSchema = setNullForMissingColumns ? AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, latestTableSchema, setNullForMissingColumns) : canonicalizedSourceSchema;
                AvroSchemaUtils.checkValidEvolution(reconciledSchema, latestTableSchema);
                return reconciledSchema;
            }
            if (!shouldValidateSchemasCompatibility) break block1;
            AvroSchemaUtils.checkSchemaCompatible(latestTableSchema, canonicalizedSourceSchema, true, allowAutoEvolutionColumnDrop, Collections.emptySet());
        }
        return canonicalizedSourceSchema;
    }

    private Schema deduceWriterSchemaWithReconcile(Schema sourceSchema, Schema canonicalizedSourceSchema, Schema latestTableSchema, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        scala.Option<InternalSchema> option = internalSchemaOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            InternalSchema internalSchema = (InternalSchema)some.value();
            boolean setNullForMissingColumns = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS.key(), (Function0 & Serializable & scala.Serializable)() -> HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS.defaultValue()))).toBoolean();
            InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, internalSchema, setNullForMissingColumns);
            Schema evolvedSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, latestTableSchema.getFullName());
            boolean shouldRemoveMetaDataFromInternalSchema = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceSchema.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSchemaUtils$.$anonfun$deduceWriterSchemaWithReconcile$2(f)))).isEmpty();
            if (shouldRemoveMetaDataFromInternalSchema) {
                return HoodieAvroUtils.removeMetadataFields(evolvedSchema);
            }
            return evolvedSchema;
        }
        if (None$.MODULE$.equals(option)) {
            Tuple2<Schema, Object> tuple2 = this.reconcileSchemasLegacy(latestTableSchema, canonicalizedSourceSchema);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema reconciledSchema = (Schema)tuple2._1();
            boolean isCompatible = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)reconciledSchema, (Object)BoxesRunTime.boxToBoolean((boolean)isCompatible));
            Schema reconciledSchema2 = (Schema)tuple22._1();
            boolean isCompatible2 = tuple22._2$mcZ$sp();
            boolean shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), (Function0 & Serializable & scala.Serializable)() -> HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
            if (!shouldValidateSchemasCompatibility || isCompatible2) {
                return reconciledSchema2;
            }
            this.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("Failed to reconcile incoming batch schema with the table's one.\n               |Incoming schema ").append(sourceSchema.toString(true)).append("\n               |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n               |Table's schema ").append(latestTableSchema.toString(true)).append("\n               |").toString())).stripMargin());
            throw new SchemaCompatibilityException("Failed to reconcile incoming schema with the table's one");
        }
        throw new MatchError(option);
    }

    public Schema deduceWriterSchema(Schema sourceSchema, Option<Schema> latestTableSchemaOpt, Option<InternalSchema> internalSchemaOpt, TypedProperties props) {
        return this.deduceWriterSchema(sourceSchema, HoodieConversionUtils$.MODULE$.toScalaOption(latestTableSchemaOpt), HoodieConversionUtils$.MODULE$.toScalaOption(internalSchemaOpt), HoodieConversionUtils$.MODULE$.fromProperties(props));
    }

    private Schema canonicalizeSchema(Schema sourceSchema, Schema latestTableSchema, Map<String, String> opts, boolean shouldReorderColumns) {
        return AvroSchemaEvolutionUtils.reconcileSchemaRequirements(sourceSchema, latestTableSchema, shouldReorderColumns);
    }

    private Tuple2<Schema, Object> reconcileSchemasLegacy(Schema tableSchema, Schema newSchema) {
        if (AvroSchemaUtils.isCompatibleProjectionOf(tableSchema, newSchema)) {
            return new Tuple2((Object)tableSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(newSchema, tableSchema)));
        }
        return new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(tableSchema, newSchema)));
    }

    public void checkPartitionSchemaOrder(StructType tableSchema, Seq<String> partitionFields) {
        Seq tableSchemaPartitionFields;
        String[] tableSchemaFields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchemaFields)).isEmpty() && partitionFields.nonEmpty()) {
            throw new IllegalArgumentException("It is not allowed to specify partition columns when the table schema is not defined.");
        }
        Seq seq = tableSchemaPartitionFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchemaFields)).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionFields.contains(elem))))).toSeq();
        Seq<String> seq2 = partitionFields;
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            throw new IllegalArgumentException(new StringBuilder(115).append("Partition schema fields order does not match the table schema fields order,").append(" tableSchemaFields: ").append(tableSchemaPartitionFields).append(", partitionFields: ").append(partitionFields).append(".").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$deduceWriterSchemaWithReconcile$2(Schema.Field f) {
        return f.name().equalsIgnoreCase(HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    private HoodieSchemaUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

