/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.functional.HoodieExpressionIndex;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;

public class HoodieSparkExpressionIndex
implements HoodieExpressionIndex<Column, Column>,
Serializable {
    public static final Map<String, SparkFunction> SPARK_FUNCTION_MAP = CollectionUtils.createImmutableMap(Pair.of("date_format", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("DATE_FORMAT requires 1 column");
        }
        return functions.date_format((Column)((Column)columns.get(0)), (String)((String)options.get("format")));
    }), Pair.of("day", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("DAY requires 1 column");
        }
        return functions.dayofmonth((Column)((Column)columns.get(0)));
    }), Pair.of("year", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("YEAR requires 1 column");
        }
        return functions.year((Column)((Column)columns.get(0)));
    }), Pair.of("month", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("MONTH requires 1 column");
        }
        return functions.month((Column)((Column)columns.get(0)));
    }), Pair.of("hour", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("HOUR requires 1 column");
        }
        return functions.hour((Column)((Column)columns.get(0)));
    }), Pair.of("from_unixtime", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("FROM_UNIXTIME requires 1 column");
        }
        return functions.from_unixtime((Column)((Column)columns.get(0)), (String)((String)options.get("format")));
    }), Pair.of("unix_timestamp", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("UNIX_TIMESTAMP requires 1 column");
        }
        return functions.unix_timestamp((Column)((Column)columns.get(0)), (String)((String)options.get("format")));
    }), Pair.of("to_date", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("TO_DATE requires 1 column");
        }
        return functions.to_date((Column)((Column)columns.get(0)));
    }), Pair.of("to_timestamp", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("TO_TIMESTAMP requires 1 column");
        }
        return functions.to_timestamp((Column)((Column)columns.get(0)));
    }), Pair.of("date_add", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("DATE_ADD requires 1 column");
        }
        return functions.date_add((Column)((Column)columns.get(0)), (int)Integer.parseInt((String)options.get("days")));
    }), Pair.of("date_sub", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("DATE_SUB requires 1 column");
        }
        return functions.date_sub((Column)((Column)columns.get(0)), (int)Integer.parseInt((String)options.get("days")));
    }), Pair.of("concat", (columns, options) -> {
        if (columns.size() < 2) {
            throw new IllegalArgumentException("CONCAT requires at least 2 columns");
        }
        return functions.concat((Column[])columns.toArray(new Column[0]));
    }), Pair.of("substring", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("SUBSTRING requires 1 column");
        }
        return functions.substring((Column)((Column)columns.get(0)), (int)Integer.parseInt((String)options.get("pos")), (int)Integer.parseInt((String)options.get("len")));
    }), Pair.of("lower", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("LOWER requires 1 column");
        }
        return functions.lower((Column)((Column)columns.get(0)));
    }), Pair.of("upper", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("UPPER requires 1 column");
        }
        return functions.upper((Column)((Column)columns.get(0)));
    }), Pair.of("trim", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("TRIM requires 1 column");
        }
        return functions.trim((Column)((Column)columns.get(0)));
    }), Pair.of("ltrim", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("LTRIM requires 1 column");
        }
        return functions.ltrim((Column)((Column)columns.get(0)));
    }), Pair.of("rtrim", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("RTRIM requires 1 column");
        }
        return functions.rtrim((Column)((Column)columns.get(0)));
    }), Pair.of("length", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("LENGTH requires 1 column");
        }
        return functions.length((Column)((Column)columns.get(0)));
    }), Pair.of("regexp_replace", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("REGEXP_REPLACE requires 1 column");
        }
        return functions.regexp_replace((Column)((Column)columns.get(0)), (String)((String)options.get("pattern")), (String)((String)options.get("replacement")));
    }), Pair.of("regexp_extract", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("REGEXP_EXTRACT requires 1 column");
        }
        return functions.regexp_extract((Column)((Column)columns.get(0)), (String)((String)options.get("pattern")), (int)Integer.parseInt((String)options.get("idx")));
    }), Pair.of("split", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("SPLIT requires 1 column");
        }
        return functions.split((Column)((Column)columns.get(0)), (String)((String)options.get("pattern")));
    }), Pair.of("identity", (columns, options) -> {
        if (columns.size() != 1) {
            throw new IllegalArgumentException("IDENTITY requires 1 column");
        }
        return (Column)columns.get(0);
    }));
    private String indexName;
    private String indexFunction;
    private List<String> orderedSourceFields;
    private Map<String, String> options;
    private SparkFunction sparkFunction;

    public HoodieSparkExpressionIndex() {
    }

    public HoodieSparkExpressionIndex(String indexName, String indexFunction, List<String> orderedSourceFields, Map<String, String> options) {
        this.indexName = indexName;
        this.indexFunction = indexFunction;
        this.orderedSourceFields = orderedSourceFields;
        this.options = options;
        this.sparkFunction = SPARK_FUNCTION_MAP.get(indexFunction);
        if (this.sparkFunction == null) {
            throw new IllegalArgumentException("Unsupported Spark function: " + indexFunction);
        }
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getIndexFunction() {
        return this.indexFunction;
    }

    @Override
    public List<String> getOrderedSourceFields() {
        return this.orderedSourceFields;
    }

    @Override
    public Column apply(List<Column> orderedSourceValues) {
        if (orderedSourceValues.size() != this.orderedSourceFields.size()) {
            throw new IllegalArgumentException("Mismatch in number of source values and fields in the expression");
        }
        return this.sparkFunction.apply(orderedSourceValues, this.options);
    }

    @FunctionalInterface
    static interface SparkFunction
    extends Serializable {
        public Column apply(List<Column> var1, Map<String, String> var2);
    }
}

