/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.hudi.HoodieCLIUtils;
import org.apache.hudi.HoodieConversionUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieIndexingConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieMetadataIndexException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.action.index.functional.BaseHoodieIndexClient;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class HoodieSparkIndexClient
extends BaseHoodieIndexClient {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkIndexClient.class);
    private static volatile HoodieSparkIndexClient _instance;
    private final SparkSession sparkSession;

    public HoodieSparkIndexClient(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }

    @Override
    public void create(HoodieTableMetaClient metaClient, String userIndexName, String indexType, Map<String, Map<String, String>> columns, Map<String, String> options) throws Exception {
        if (indexType.equals("secondary_index") || indexType.equals("bloom_filters") || indexType.equals("column_stats")) {
            this.createExpressionOrSecondaryIndex(metaClient, userIndexName, indexType, columns, options);
        } else {
            this.createRecordIndex(metaClient, userIndexName, indexType);
        }
    }

    private void createRecordIndex(HoodieTableMetaClient metaClient, String userIndexName, String indexType) {
        block17: {
            if (!userIndexName.equals("record_index")) {
                throw new HoodieIndexException("Record index should be named as record_index");
            }
            String fullIndexName = "record_index";
            if (HoodieSparkIndexClient.indexExists(metaClient, fullIndexName)) {
                throw new HoodieMetadataIndexException("Index already exists: " + userIndexName);
            }
            LOG.info("Creating index {} of using {}", (Object)fullIndexName, (Object)indexType);
            try (SparkRDDWriteClient<HoodieRecordPayload> writeClient = HoodieCLIUtils.createHoodieWriteClient(this.sparkSession, metaClient.getBasePath().toString(), HoodieConversionUtils.mapAsScalaImmutableMap(HoodieSparkIndexClient.buildWriteConfig(metaClient, Option.empty(), Option.of(indexType))), HoodieConversionUtils.toScalaOption(Option.empty()));){
                Option<String> indexInstantTime = HoodieSparkIndexClient.doSchedule(writeClient, metaClient, fullIndexName, MetadataPartitionType.RECORD_INDEX);
                if (indexInstantTime.isPresent()) {
                    writeClient.index(indexInstantTime.get());
                    break block17;
                }
                throw new HoodieMetadataIndexException("Scheduling of index action did not return any instant.");
            }
            catch (Throwable t) {
                this.drop(metaClient, fullIndexName, Option.empty());
                throw t;
            }
        }
    }

    private void createExpressionOrSecondaryIndex(HoodieTableMetaClient metaClient, String userIndexName, String indexType, Map<String, Map<String, String>> columns, Map<String, String> options) throws Exception {
        block18: {
            String fullIndexName;
            String string = fullIndexName = indexType.equals("secondary_index") ? "secondary_index_" + userIndexName : "expr_index_" + userIndexName;
            if (HoodieSparkIndexClient.indexExists(metaClient, fullIndexName)) {
                throw new HoodieMetadataIndexException("Index already exists: " + userIndexName);
            }
            ValidationUtils.checkArgument(columns.size() == 1, "Only one column can be indexed for functional or secondary index.");
            if (!HoodieSparkIndexClient.isEligibleForIndexing(metaClient, indexType, options, columns)) {
                throw new HoodieMetadataIndexException("Not eligible for indexing: " + indexType + ", indexName: " + userIndexName);
            }
            HoodieIndexDefinition indexDefinition = new HoodieIndexDefinition(fullIndexName, indexType, options.getOrDefault("expr", "identity"), new ArrayList<String>(columns.keySet()), options);
            if (!(metaClient.getTableConfig().getRelativeIndexDefinitionPath().isPresent() && metaClient.getIndexMetadata().isPresent() && metaClient.getIndexMetadata().get().getIndexDefinitions().containsKey(fullIndexName))) {
                LOG.info("Index definition is not present. Registering the index first");
                this.register(metaClient, indexDefinition);
            }
            ValidationUtils.checkState(metaClient.getIndexMetadata().isPresent(), "Index definition is not present");
            LOG.info("Creating index {} of using {}", (Object)fullIndexName, (Object)indexType);
            Option<HoodieIndexDefinition> expressionIndexDefinitionOpt = Option.ofNullable(indexDefinition);
            try (SparkRDDWriteClient<HoodieRecordPayload> writeClient = HoodieCLIUtils.createHoodieWriteClient(this.sparkSession, metaClient.getBasePath().toString(), HoodieConversionUtils.mapAsScalaImmutableMap(HoodieSparkIndexClient.buildWriteConfig(metaClient, expressionIndexDefinitionOpt, Option.of(indexType))), HoodieConversionUtils.toScalaOption(Option.empty()));){
                MetadataPartitionType partitionType = indexType.equals("secondary_index") ? MetadataPartitionType.SECONDARY_INDEX : MetadataPartitionType.EXPRESSION_INDEX;
                Option<String> indexInstantTime = HoodieSparkIndexClient.doSchedule(writeClient, metaClient, fullIndexName, partitionType);
                if (indexInstantTime.isPresent()) {
                    writeClient.index(indexInstantTime.get());
                    break block18;
                }
                throw new HoodieMetadataIndexException("Scheduling of index action did not return any instant.");
            }
            catch (Throwable t) {
                this.drop(metaClient, fullIndexName, Option.ofNullable(indexDefinition));
                throw t;
            }
        }
    }

    private void drop(HoodieTableMetaClient metaClient, String indexName, Option<HoodieIndexDefinition> indexDefinitionOpt) {
        LOG.info("Dropping index {}", (Object)indexName);
        try (SparkRDDWriteClient<?> writeClient = HoodieCLIUtils.createHoodieWriteClient(this.sparkSession, metaClient.getBasePath().toString(), HoodieConversionUtils.mapAsScalaImmutableMap(HoodieSparkIndexClient.buildWriteConfig(metaClient, indexDefinitionOpt, Option.empty())), HoodieConversionUtils.toScalaOption(Option.empty()));){
            writeClient.dropIndex(Collections.singletonList(indexName));
        }
    }

    @Override
    public void drop(HoodieTableMetaClient metaClient, String indexName, boolean ignoreIfNotExists) {
        LOG.info("Dropping index {}", (Object)indexName);
        Option<HoodieIndexDefinition> indexDefinitionOpt = metaClient.getIndexMetadata().map(HoodieIndexMetadata::getIndexDefinitions).map(definition -> (HoodieIndexDefinition)definition.get(indexName));
        try (SparkRDDWriteClient<?> writeClient = HoodieCLIUtils.createHoodieWriteClient(this.sparkSession, metaClient.getBasePath().toString(), HoodieConversionUtils.mapAsScalaImmutableMap(HoodieSparkIndexClient.buildWriteConfig(metaClient, indexDefinitionOpt, Option.empty())), HoodieConversionUtils.toScalaOption(Option.empty()));){
            writeClient.dropIndex(Collections.singletonList(indexName));
        }
    }

    private static Option<String> doSchedule(SparkRDDWriteClient<HoodieRecordPayload> client, HoodieTableMetaClient metaClient, String indexName, MetadataPartitionType partitionType) {
        List<MetadataPartitionType> partitionTypes = Collections.singletonList(partitionType);
        if (metaClient.getTableConfig().getMetadataPartitions().isEmpty()) {
            throw new HoodieException("Metadata table is not yet initialized. Initialize FILES partition before any other partition " + Arrays.toString(partitionTypes.toArray()));
        }
        return client.scheduleIndexing(partitionTypes, Collections.singletonList(indexName));
    }

    private static boolean indexExists(HoodieTableMetaClient metaClient, String indexName) {
        return metaClient.getTableConfig().getMetadataPartitions().stream().anyMatch(partition -> partition.equals(indexName));
    }

    private static Map<String, String> buildWriteConfig(HoodieTableMetaClient metaClient, Option<HoodieIndexDefinition> indexDefinitionOpt, Option<String> indexTypeOpt) {
        HashMap<String, String> writeConfig = new HashMap<String, String>();
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            String indexType;
            writeConfig.put(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
            writeConfig.putAll((Map)JavaConverters.mapAsJavaMapConverter(HoodieCLIUtils.getLockOptions(metaClient.getBasePath().toString(), metaClient.getBasePath().toUri().getScheme(), new TypedProperties())).asJava());
            metaClient.getTableConfig().getMetadataPartitions().forEach(partitionPath -> {
                if (partitionPath.equals(MetadataPartitionType.RECORD_INDEX.getPartitionPath())) {
                    writeConfig.put(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true");
                }
                if (partitionPath.equals(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath())) {
                    writeConfig.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key(), "true");
                }
                if (partitionPath.equals(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                    writeConfig.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), "true");
                }
            });
            if (indexTypeOpt.isPresent() && (indexType = indexTypeOpt.get()).equals("record_index")) {
                writeConfig.put(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true");
            }
        }
        indexDefinitionOpt.ifPresent(indexDefinition -> HoodieIndexingConfig.fromIndexDefinition(indexDefinition).getProps().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> writeConfig.put(key.toString(), value.toString()))));
        return writeConfig;
    }

    private static boolean isEligibleForIndexing(HoodieTableMetaClient metaClient, String indexType, Map<String, String> options, Map<String, Map<String, String>> columns) throws Exception {
        if (!HoodieTableMetadataUtil.validateDataTypeForSecondaryIndex(new ArrayList<String>(columns.keySet()), new TableSchemaResolver(metaClient).getTableAvroSchema())) {
            return false;
        }
        if (indexType.equals("secondary_index")) {
            return metaClient.getTableConfig().getMetadataPartitions().stream().anyMatch(partition -> partition.equals(MetadataPartitionType.RECORD_INDEX.getPartitionPath())) || Boolean.parseBoolean(options.getOrDefault(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.defaultValue().toString()));
        }
        return true;
    }
}

