/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkVersionsSupport;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.ExceptionWrappingIterator;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.SQLConfInjectingRDD;
import org.apache.spark.sql.execution.datasources.SparkParsePartitionUtil;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HoodieSparkUtils$
implements SparkAdapterSupport,
SparkVersionsSupport,
Logging {
    public static HoodieSparkUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieSparkUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public boolean isSpark3() {
        return SparkVersionsSupport.isSpark3$(this);
    }

    @Override
    public boolean isSpark3_3() {
        return SparkVersionsSupport.isSpark3_3$(this);
    }

    @Override
    public boolean isSpark3_4() {
        return SparkVersionsSupport.isSpark3_4$(this);
    }

    @Override
    public boolean isSpark3_5() {
        return SparkVersionsSupport.isSpark3_5$(this);
    }

    @Override
    public boolean gteqSpark3_3() {
        return SparkVersionsSupport.gteqSpark3_3$(this);
    }

    @Override
    public boolean gteqSpark3_3_2() {
        return SparkVersionsSupport.gteqSpark3_3_2$(this);
    }

    @Override
    public boolean gteqSpark3_4() {
        return SparkVersionsSupport.gteqSpark3_4$(this);
    }

    @Override
    public boolean gteqSpark3_5() {
        return SparkVersionsSupport.gteqSpark3_5$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSparkUtils$ hoodieSparkUtils$ = this;
        synchronized (hoodieSparkUtils$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    @Override
    public String getSparkVersion() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION();
    }

    public StructType getMetaSchema() {
        return StructType$.MODULE$.apply(((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)col -> new StructField(col, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    @Deprecated
    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, boolean reconcileToLatestSchema, Option<Schema> latestTableSchema) {
        return this.createRdd(df, structName, recordNamespace, HoodieConversionUtils$.MODULE$.toScalaOption(latestTableSchema));
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace) {
        return this.createRdd(df, structName, recordNamespace, (scala.Option<Schema>)None$.MODULE$);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, scala.Option<Schema> readerAvroSchemaOpt) {
        StructType writerSchema = df.schema();
        Schema writerAvroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)writerSchema, structName, recordNamespace);
        Schema readerAvroSchema = (Schema)readerAvroSchemaOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> writerAvroSchema);
        boolean sameSchema = writerAvroSchema.equals((Object)readerAvroSchema);
        Schema schema = AvroSchemaUtils.resolveNullableSchema(writerAvroSchema);
        Schema schema2 = writerAvroSchema;
        boolean nullable = schema == null ? schema2 != null : !schema.equals(schema2);
        String readerAvroSchemaStr = readerAvroSchema.toString();
        String writerAvroSchemaStr = writerAvroSchema.toString();
        return this.injectSQLConf(df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
            if (rows.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            Schema readerAvroSchema = new Schema.Parser().parse(readerAvroSchemaStr);
            Function1 & Serializable & scala.Serializable transform = sameSchema ? (Function1 & Serializable & scala.Serializable)x -> (GenericRecord)Predef$.MODULE$.identity(x) : (Function1 & Serializable & scala.Serializable)x$1 -> HoodieAvroUtils.rewriteRecordDeep(x$1, readerAvroSchema);
            Schema writerAvroSchema = new Schema.Parser().parse(writerAvroSchemaStr);
            Function1<InternalRow, GenericRecord> convert = AvroConversionUtils$.MODULE$.createInternalRowToAvroConverter(writerSchema, writerAvroSchema, nullable);
            return rows.map((Function1 & Serializable & scala.Serializable)ir -> (GenericRecord)transform.apply(convert.apply(ir)));
        }, true, ClassTag$.MODULE$.apply(GenericRecord.class)), SQLConf$.MODULE$.get(), ClassTag$.MODULE$.apply(GenericRecord.class));
    }

    public Option<Schema> createRdd$default$5() {
        return Option.empty();
    }

    public <T> RDD<T> injectSQLConf(RDD<T> rdd, SQLConf conf, ClassTag<T> evidence$1) {
        return new SQLConfInjectingRDD<T>(rdd, conf, evidence$1);
    }

    public Dataset<Row> maybeWrapDataFrameWithException(Dataset<Row> df, String exceptionClass, String msg, boolean shouldWrap) {
        if (shouldWrap) {
            return HoodieUnsafeUtils$.MODULE$.createDataFrameFromRDD(df.sparkSession(), this.injectSQLConf(df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)rows -> new ExceptionWrappingIterator(rows, exceptionClass, msg), df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)), SQLConf$.MODULE$.get(), ClassTag$.MODULE$.apply(InternalRow.class)), df.schema());
        }
        return df;
    }

    public Tuple2<RDD<GenericRecord>, RDD<String>> safeCreateRDD(Dataset<Row> df, String structName, String recordNamespace, boolean reconcileToLatestSchema, Option<Schema> latestTableSchema) {
        Object latestTableSchemaConverted = None$.MODULE$;
        latestTableSchemaConverted = latestTableSchema.isPresent() && reconcileToLatestSchema ? new Some((Object)latestTableSchema.get()) : (latestTableSchema.isPresent() ? new Some((Object)latestTableSchema.get()) : None$.MODULE$);
        return this.safeCreateRDD(df, structName, recordNamespace, (scala.Option<Schema>)latestTableSchemaConverted);
    }

    public Tuple2<RDD<GenericRecord>, RDD<String>> safeCreateRDD(Dataset<Row> df, String structName, String recordNamespace, scala.Option<Schema> readerAvroSchemaOpt) {
        StructType writerSchema = df.schema();
        Schema writerAvroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)writerSchema, structName, recordNamespace);
        Schema readerAvroSchema = (Schema)readerAvroSchemaOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> writerAvroSchema);
        boolean sameSchema = writerAvroSchema.equals((Object)readerAvroSchema);
        Schema schema = AvroSchemaUtils.resolveNullableSchema(writerAvroSchema);
        Schema schema2 = writerAvroSchema;
        boolean nullable = schema == null ? schema2 != null : !schema.equals(schema2);
        String writerAvroSchemaStr = writerAvroSchema.toString();
        String readerAvroSchemaStr = readerAvroSchema.toString();
        if (!sameSchema) {
            RDD rdds = df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
                if (rows.isEmpty()) {
                    return package$.MODULE$.Iterator().empty();
                }
                Schema writerAvroSchema = new Schema.Parser().parse(writerAvroSchemaStr);
                Schema readerAvroSchema = new Schema.Parser().parse(readerAvroSchemaStr);
                Function1<InternalRow, GenericRecord> convert = AvroConversionUtils$.MODULE$.createInternalRowToAvroConverter(writerSchema, writerAvroSchema, nullable);
                Function1 & Serializable & scala.Serializable transform = (Function1 & Serializable & scala.Serializable)internalRow -> {
                    Right right;
                    try {
                        right = package$.MODULE$.Left().apply((Object)HoodieAvroUtils.rewriteRecordDeep((GenericRecord)convert.apply(internalRow), readerAvroSchema, true));
                    }
                    catch (Throwable throwable) {
                        right = package$.MODULE$.Right().apply(internalRow);
                    }
                    return right;
                };
                return rows.map((Function1)transform);
            }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Either.class));
            SparkRowSerDe rowDeserializer = this.getCatalystRowSerDe(writerSchema);
            Dataset errorRDD = df.sparkSession().createDataFrame(rdds.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isRight())).map((Function1 & Serializable & scala.Serializable)x$3 -> (InternalRow)x$3.right().get(), ClassTag$.MODULE$.apply(InternalRow.class)).map((Function1 & Serializable & scala.Serializable)ir -> rowDeserializer.deserializeRow((InternalRow)ir), ClassTag$.MODULE$.apply(Row.class)), writerSchema);
            return new Tuple2((Object)rdds.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isLeft())).map((Function1 & Serializable & scala.Serializable)x$5 -> (GenericRecord)x$5.left().get(), ClassTag$.MODULE$.apply(GenericRecord.class)), (Object)errorRDD.toJSON().rdd());
        }
        RDD rdd = df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
            if (rows.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            Function1<InternalRow, GenericRecord> convert = AvroConversionUtils$.MODULE$.createInternalRowToAvroConverter(writerSchema, writerAvroSchema, nullable);
            return rows.map(convert);
        }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(GenericRecord.class));
        return new Tuple2((Object)rdd, (Object)df.sparkSession().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(String.class)));
    }

    public Option<Schema> safeCreateRDD$default$5() {
        return Option.empty();
    }

    public Tuple2<RDD<GenericRecord>, RDD<String>> safeRewriteRDD(RDD<GenericRecord> df, String serializedTargetSchema) {
        RDD rdds = df.mapPartitions((Function1 & Serializable & scala.Serializable)recs -> {
            if (recs.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            Schema schema = new Schema.Parser().parse(serializedTargetSchema);
            Function1 & Serializable & scala.Serializable transform = (Function1 & Serializable & scala.Serializable)record -> {
                Left left;
                try {
                    left = package$.MODULE$.Left().apply((Object)HoodieAvroUtils.rewriteRecordDeep(record, schema, true));
                }
                catch (Throwable throwable) {
                    left = package$.MODULE$.Right().apply((Object)HoodieAvroUtils.safeAvroToJsonString(record));
                }
                return left;
            };
            return recs.map((Function1)transform);
        }, df.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Either.class));
        return new Tuple2((Object)rdds.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isLeft())).map((Function1 & Serializable & scala.Serializable)x$7 -> (GenericRecord)x$7.left().get(), ClassTag$.MODULE$.apply(GenericRecord.class)), (Object)rdds.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isRight())).map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9.right().get(), ClassTag$.MODULE$.apply(String.class)));
    }

    public SparkRowSerDe getCatalystRowSerDe(StructType structType) {
        return this.sparkAdapter().createSparkRowSerDe(structType);
    }

    public Object[] parsePartitionColumnValues(String[] partitionColumns, String partitionPath, StoragePath tableBasePath, StructType tableSchema, Map<String, String> tableConfig, String timeZoneId, SparkParsePartitionUtil sparkParsePartitionUtil, boolean shouldValidatePartitionColumns) {
        String keyGeneratorClass = KeyGeneratorType.getKeyGeneratorClassName(tableConfig);
        String timestampKeyGeneratorType = tableConfig.get(TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD.key());
        if (keyGeneratorClass != null && timestampKeyGeneratorType != null && keyGeneratorClass.equals(KeyGeneratorType.TIMESTAMP.getClassName()) && !timestampKeyGeneratorType.matches(TimestampBasedAvroKeyGenerator.TimestampType.DATE_STRING.toString())) {
            return (Object[])Array$.MODULE$.fill(partitionColumns.length, (Function0 & Serializable & scala.Serializable)() -> UTF8String.fromString((String)partitionPath), ClassTag$.MODULE$.Object());
        }
        return this.doParsePartitionColumnValues(partitionColumns, partitionPath, tableBasePath, tableSchema, timeZoneId, sparkParsePartitionUtil, shouldValidatePartitionColumns);
    }

    public Object[] doParsePartitionColumnValues(String[] partitionColumns, String partitionPath, StoragePath basePath, StructType schema, String timeZoneId, SparkParsePartitionUtil sparkParsePartitionUtil, boolean shouldValidatePartitionCols) {
        if (partitionColumns.length == 0) {
            return (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Object());
        }
        String[] partitionFragments = partitionPath.split("/");
        if (partitionFragments.length != partitionColumns.length) {
            if (partitionColumns.length == 1) {
                String prefix = new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns)).head()).append("=").toString();
                String partitionValue = partitionPath.startsWith(prefix) ? partitionPath.substring(prefix.length()) : partitionPath;
                return new Object[]{UTF8String.fromString((String)partitionValue)};
            }
            String prefix = new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns)).head()).append("=").toString();
            if (partitionPath.startsWith(prefix)) {
                return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.splitHiveSlashPartitions(partitionFragments, partitionColumns.length))).map((Function1 & Serializable & scala.Serializable)p -> UTF8String.fromString((String)p), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UTF8String.class))))).toArray(ClassTag$.MODULE$.Object());
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Failed to parse partition values: found partition fragments").append(" (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).mkString(",")).append(") are not aligned with expected partition columns").append(" (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns)).mkString(",")).append(")").toString());
            return (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Object());
        }
        String partitionWithName = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String partition = (String)tuple2._1();
                String columnName = (String)tuple2._2();
                if (partition.indexOf("=") == -1) {
                    return new StringBuilder(1).append(columnName).append("=").append(partition).toString();
                }
                return partition;
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/");
        StoragePath pathWithPartitionName = new StoragePath(basePath, partitionWithName);
        StructType partitionSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkUtils$.$anonfun$doParsePartitionColumnValues$4(partitionColumns, f))));
        Seq<Object> partitionValues = this.parsePartitionPath(pathWithPartitionName, partitionSchema, timeZoneId, sparkParsePartitionUtil, basePath, shouldValidatePartitionCols);
        return (Object[])((TraversableOnce)partitionValues.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    private Seq<Object> parsePartitionPath(StoragePath partitionPath, StructType partitionSchema, String timeZoneId, SparkParsePartitionUtil sparkParsePartitionUtil, StoragePath basePath, boolean shouldValidatePartitionCols) {
        scala.collection.immutable.Map partitionDataTypes = ((TraversableOnce)partitionSchema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return sparkParsePartitionUtil.parsePartition(new Path(partitionPath.toUri()), false, (Set<Path>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(basePath.toUri())}))), (scala.collection.immutable.Map<String, DataType>)partitionDataTypes, DateTimeUtils$.MODULE$.getTimeZone(timeZoneId), shouldValidatePartitionCols).toSeq(partitionSchema);
    }

    public String[] splitHiveSlashPartitions(String[] partitionFragments, int nPartitions) {
        String[] partitionVals = new String[nPartitions];
        IntRef index = IntRef.create((int)0);
        BooleanRef first = BooleanRef.create((boolean)true);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).foreach((Function1 & Serializable & scala.Serializable)fragment -> {
            HoodieSparkUtils$.$anonfun$splitHiveSlashPartitions$1(first, index, partitionVals, fragment);
            return BoxedUnit.UNIT;
        });
        return partitionVals;
    }

    public static final /* synthetic */ boolean $anonfun$doParsePartitionColumnValues$4(String[] partitionColumns$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ void $anonfun$splitHiveSlashPartitions$1(BooleanRef first$1, IntRef index$1, String[] partitionVals$1, String fragment) {
        if (fragment.contains("=")) {
            if (first$1.elem) {
                first$1.elem = false;
            } else {
                ++index$1.elem;
            }
            partitionVals$1[index$1.elem] = fragment.substring(fragment.indexOf("=") + 1);
            return;
        }
        int n = index$1.elem;
        partitionVals$1[n] = new StringBuilder(1).append(partitionVals$1[n]).append("/").append(fragment).toString();
    }

    private HoodieSparkUtils$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
        SparkVersionsSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

