/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class RecordLevelIndexSupport$ {
    public static RecordLevelIndexSupport$ MODULE$;
    private final String INDEX_NAME;

    static {
        new RecordLevelIndexSupport$();
    }

    public String INDEX_NAME() {
        return this.INDEX_NAME;
    }

    private Function1<Expression, Expression> getDefaultAttributeFetcher() {
        return (Function1 & Serializable & scala.Serializable)expr -> expr;
    }

    public Function2<AttributeReference, Literal, String> getSimpleLiteralGenerator() {
        return (Function2 & Serializable & scala.Serializable)(x$1, lit) -> lit.value().toString();
    }

    public Function2<AttributeReference, Literal, String> getComplexKeyLiteralGenerator() {
        return (Function2 & Serializable & scala.Serializable)(attr, lit) -> new StringBuilder(1).append(attr.name()).append(":").append(lit.value().toString()).toString();
    }

    public Option<Tuple2<Expression, List<String>>> filterQueryWithRecordKey(Expression queryFilter, Option<String> recordKeyOpt) {
        return this.filterQueryWithRecordKey(queryFilter, recordKeyOpt, this.getDefaultAttributeFetcher());
    }

    public Option<Tuple2<Expression, List<String>>> filterQueryWithRecordKey(Expression queryFilter, Option<String> recordKeyOpt, Function2<AttributeReference, Literal, String> literalGenerator) {
        return (Option)this.filterQueryWithRecordKey(queryFilter, recordKeyOpt, literalGenerator, this.getDefaultAttributeFetcher())._1();
    }

    public Option<Tuple2<Expression, List<String>>> filterQueryWithRecordKey(Expression queryFilter, Option<String> recordKeyOpt, Function1<Expression, Expression> attributeFetcher) {
        return (Option)this.filterQueryWithRecordKey(queryFilter, recordKeyOpt, this.getSimpleLiteralGenerator(), attributeFetcher)._1();
    }

    public Tuple2<Option<Tuple2<Expression, List<String>>>, Object> filterQueryWithRecordKey(Expression queryFilter, Option<String> recordKeyOpt, Function2<AttributeReference, Literal, String> literalGenerator, Function1<Expression, Expression> attributeFetcher) {
        Expression expression = queryFilter;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Tuple2 attributeLiteralTuple = (Tuple2)this.getAttributeLiteralTuple((Expression)attributeFetcher.apply((Object)equalTo.left()), (Expression)attributeFetcher.apply((Object)equalTo.right())).orNull(Predef$.MODULE$.$conforms());
            if (attributeLiteralTuple != null) {
                AttributeReference attribute = (AttributeReference)attributeLiteralTuple._1();
                Literal literal = (Literal)attributeLiteralTuple._2();
                if (attribute != null && attribute.name() != null && this.attributeMatchesRecordKey(attribute.name(), recordKeyOpt)) {
                    String recordKeyLiteral = (String)literalGenerator.apply((Object)attribute, (Object)literal);
                    return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)equalTo, (Object)new .colon.colon((Object)recordKeyLiteral, (List)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (expression instanceof In) {
            AttributeReference attributeReference;
            In in = (In)expression;
            BooleanRef validINQuery = BooleanRef.create((boolean)true);
            Expression expression2 = (Expression)attributeFetcher.apply((Object)in.value());
            if (expression2 instanceof AttributeReference) {
                AttributeReference attributeReference2 = (AttributeReference)expression2;
                if (!this.attributeMatchesRecordKey(attributeReference2.name(), recordKeyOpt)) {
                    validINQuery.elem = false;
                    attributeReference = null;
                } else {
                    attributeReference = attributeReference2;
                }
            } else {
                validINQuery.elem = false;
                attributeReference = null;
            }
            Option attributeOpt = Option$.MODULE$.apply(attributeReference);
            ObjectRef literals = ObjectRef.create((Object)List$.MODULE$.empty());
            in.list().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RecordLevelIndexSupport$.$anonfun$filterQueryWithRecordKey$1(attributeOpt, literalGenerator, literals, validINQuery, x0$1);
                return BoxedUnit.UNIT;
            });
            if (validINQuery.elem) {
                return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)in, (Object)((List)literals.elem))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (expression instanceof And) {
            boolean isSupported;
            And and = (And)expression;
            Tuple2<Option<Tuple2<Expression, List<String>>>, Object> leftResult = this.filterQueryWithRecordKey(and.left(), recordKeyOpt, literalGenerator, attributeFetcher);
            Tuple2<Option<Tuple2<Expression, List<String>>>, Object> rightResult = this.filterQueryWithRecordKey(and.right(), recordKeyOpt, literalGenerator, attributeFetcher);
            boolean bl = isSupported = leftResult._2$mcZ$sp() && rightResult._2$mcZ$sp();
            if (!isSupported) {
                return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Tuple2 tuple2 = new Tuple2(leftResult._1(), rightResult._1());
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple22;
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).value()) != null) {
                    Some some2;
                    Tuple2 tuple23;
                    Expression leftExp = (Expression)tuple22._1();
                    List leftKeys = (List)tuple22._2();
                    if (option2 instanceof Some && (tuple23 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                        Expression rightExp = (Expression)tuple23._1();
                        List rightKeys = (List)tuple23._2();
                        return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)new And(leftExp, rightExp), leftKeys.$plus$plus((GenTraversableOnce)rightKeys, List$.MODULE$.canBuildFrom()))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple24;
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some && (tuple24 = (Tuple2)(some = (Some)option).value()) != null) {
                    Expression leftExp = (Expression)tuple24._1();
                    List leftKeys = (List)tuple24._2();
                    if (None$.MODULE$.equals(option3)) {
                        return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)leftExp, (Object)leftKeys)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple25;
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some && (tuple25 = (Tuple2)(some = (Some)option4).value()) != null) {
                    Expression rightExp = (Expression)tuple25._1();
                    List rightKeys = (List)tuple25._2();
                    return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)rightExp, (Object)rightKeys)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Tuple2<Option<Tuple2<Expression, List<String>>>, Object> fetchQueryWithAttribute(Expression queryFilter, Option<String> recordKeyOpt, Function2<AttributeReference, Literal, String> literalGenerator, Function1<Expression, Expression> attributeFetcher) {
        Expression expression = queryFilter;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Tuple2 attributeLiteralTuple = (Tuple2)this.getAttributeLiteralTuple((Expression)attributeFetcher.apply((Object)equalTo.left()), (Expression)attributeFetcher.apply((Object)equalTo.right())).orNull(Predef$.MODULE$.$conforms());
            if (attributeLiteralTuple != null) {
                AttributeReference attribute = (AttributeReference)attributeLiteralTuple._1();
                Literal literal = (Literal)attributeLiteralTuple._2();
                if (attribute != null && attribute.name() != null && this.attributeMatchesRecordKey(attribute.name(), recordKeyOpt)) {
                    String recordKeyLiteral = (String)literalGenerator.apply((Object)attribute, (Object)literal);
                    return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)new EqualTo((Expression)attribute, (Expression)literal), (Object)new .colon.colon((Object)recordKeyLiteral, (List)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (expression instanceof In) {
            AttributeReference attributeReference;
            In in = (In)expression;
            BooleanRef validINQuery = BooleanRef.create((boolean)true);
            Expression expression2 = (Expression)attributeFetcher.apply((Object)in.value());
            if (expression2 instanceof AttributeReference) {
                AttributeReference attributeReference2 = (AttributeReference)expression2;
                if (!this.attributeMatchesRecordKey(attributeReference2.name(), recordKeyOpt)) {
                    validINQuery.elem = false;
                    attributeReference = null;
                } else {
                    attributeReference = attributeReference2;
                }
            } else {
                validINQuery.elem = false;
                attributeReference = null;
            }
            Option attributeOpt = Option$.MODULE$.apply(attributeReference);
            ObjectRef literals = ObjectRef.create((Object)List$.MODULE$.empty());
            in.list().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RecordLevelIndexSupport$.$anonfun$fetchQueryWithAttribute$1(attributeOpt, literalGenerator, literals, validINQuery, x0$1);
                return BoxedUnit.UNIT;
            });
            if (validINQuery.elem) {
                return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)new In((Expression)attributeOpt.get(), in.list()), (Object)((List)literals.elem))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (expression instanceof And) {
            boolean isSupported;
            And and = (And)expression;
            Tuple2<Option<Tuple2<Expression, List<String>>>, Object> leftResult = this.filterQueryWithRecordKey(and.left(), recordKeyOpt, literalGenerator, attributeFetcher);
            Tuple2<Option<Tuple2<Expression, List<String>>>, Object> rightResult = this.filterQueryWithRecordKey(and.right(), recordKeyOpt, literalGenerator, attributeFetcher);
            boolean bl = isSupported = leftResult._2$mcZ$sp() && rightResult._2$mcZ$sp();
            if (!isSupported) {
                return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Tuple2 tuple2 = new Tuple2(leftResult._1(), rightResult._1());
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple22;
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some && (tuple22 = (Tuple2)(some = (Some)option).value()) != null) {
                    Some some2;
                    Tuple2 tuple23;
                    Expression leftExp = (Expression)tuple22._1();
                    List leftKeys = (List)tuple22._2();
                    if (option2 instanceof Some && (tuple23 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                        Expression rightExp = (Expression)tuple23._1();
                        List rightKeys = (List)tuple23._2();
                        return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)new And(leftExp, rightExp), leftKeys.$plus$plus((GenTraversableOnce)rightKeys, List$.MODULE$.canBuildFrom()))), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple24;
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some && (tuple24 = (Tuple2)(some = (Some)option).value()) != null) {
                    Expression leftExp = (Expression)tuple24._1();
                    List leftKeys = (List)tuple24._2();
                    if (None$.MODULE$.equals(option3)) {
                        return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)leftExp, (Object)leftKeys)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                Tuple2 tuple25;
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some && (tuple25 = (Tuple2)(some = (Some)option4).value()) != null) {
                    Expression rightExp = (Expression)tuple25._1();
                    List rightKeys = (List)tuple25._2();
                    return new Tuple2((Object)Option$.MODULE$.apply((Object)new Tuple2((Object)rightExp, (Object)rightKeys)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return new Tuple2((Object)Option$.MODULE$.empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Seq<StoragePath> getPrunedStoragePaths(Seq<Tuple2<Option<BaseHoodieTableFileIndex.PartitionPath>, Seq<FileSlice>>> prunedPartitionsAndFileSlices, HoodieFileIndex fileIndex) {
        if (prunedPartitionsAndFileSlices.isEmpty()) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIndex.inputFiles())).map((Function1 & Serializable & scala.Serializable)strPath -> new StoragePath((String)strPath), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StoragePath.class))))).toSeq();
        }
        return (Seq)((TraversableLike)prunedPartitionsAndFileSlices.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq fileSlices = (Seq)tuple2._2();
                return fileSlices;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)fileSlice -> {
            Option baseFileOption = Option$.MODULE$.apply(fileSlice.getBaseFile().orElse(null));
            Iterator logFiles = fileIndex.includeLogFiles() ? (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSlice.getLogFiles().iterator()).asScala() : package$.MODULE$.Iterator().empty();
            Seq baseFilePaths = Option$.MODULE$.option2Iterable(baseFileOption.map((Function1 & Serializable & scala.Serializable)baseFile -> baseFile.getStoragePath())).toSeq();
            Seq logFilePaths = logFiles.map((Function1 & Serializable & scala.Serializable)logFile -> logFile.getPath()).toSeq();
            return (Seq)baseFilePaths.$plus$plus((GenTraversableOnce)logFilePaths, Seq$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Tuple2<AttributeReference, Literal>> getAttributeLiteralTuple(Expression expression1, Expression expression2) {
        Expression expression = expression1;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            Expression expression3 = expression2;
            if (expression3 instanceof Literal) {
                Literal literal = (Literal)expression3;
                return Option$.MODULE$.apply((Object)new Tuple2((Object)attributeReference, (Object)literal));
            }
            return Option$.MODULE$.empty();
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Expression expression4 = expression2;
            if (expression4 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)expression4;
                return Option$.MODULE$.apply((Object)new Tuple2((Object)attributeReference, (Object)literal));
            }
            return Option$.MODULE$.empty();
        }
        return Option$.MODULE$.empty();
    }

    private boolean attributeMatchesRecordKey(String attributeName, Option<String> recordKeyOpt) {
        if (recordKeyOpt.isDefined()) {
            Object object = recordKeyOpt.get();
            String string = attributeName;
            if (!(object != null ? !object.equals(string) : string != null)) {
                return true;
            }
        }
        String string = HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName();
        String string2 = attributeName;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$filterQueryWithRecordKey$1(Option attributeOpt$1, Function2 literalGenerator$1, ObjectRef literals$1, BooleanRef validINQuery$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            if (attributeOpt$1.isDefined()) {
                String recordKeyLiteral = (String)literalGenerator$1.apply(attributeOpt$1.get(), (Object)literal);
                literals$1.elem = (List)((List)literals$1.elem).$colon$plus((Object)recordKeyLiteral, List$.MODULE$.canBuildFrom());
                return;
            }
        }
        validINQuery$1.elem = false;
    }

    public static final /* synthetic */ void $anonfun$fetchQueryWithAttribute$1(Option attributeOpt$2, Function2 literalGenerator$2, ObjectRef literals$2, BooleanRef validINQuery$2, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            if (attributeOpt$2.isDefined()) {
                String recordKeyLiteral = (String)literalGenerator$2.apply(attributeOpt$2.get(), (Object)literal);
                literals$2.elem = (List)((List)literals$2.elem).$colon$plus((Object)recordKeyLiteral, List$.MODULE$.canBuildFrom());
                return;
            }
        }
        validINQuery$2.elem = false;
    }

    private RecordLevelIndexSupport$() {
        MODULE$ = this;
        this.INDEX_NAME = "RECORD_LEVEL";
    }
}

