/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.List;
import org.apache.hudi.client.BaseCompactor;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSparkCompactor<T>
extends BaseCompactor<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkCompactor.class);
    private transient HoodieEngineContext context;

    public HoodieSparkCompactor(BaseHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> compactionClient, HoodieEngineContext context) {
        super(compactionClient);
        this.context = context;
    }

    @Override
    public void compact(String instantTime) {
        LOG.info("Compactor executing compaction " + instantTime);
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)this.compactionClient;
        HoodieWriteMetadata compactionMetadata = writeClient.compact(instantTime);
        List<HoodieWriteStat> writeStats = compactionMetadata.getCommitMetadata().get().getWriteStats();
        long numWriteErrors = writeStats.stream().mapToLong(HoodieWriteStat::getTotalWriteErrors).sum();
        if (numWriteErrors != 0L) {
            LOG.error("Compaction for instant (" + instantTime + ") failed with write errors. Errors :" + numWriteErrors);
            throw new HoodieException("Compaction for instant (" + instantTime + ") failed with write errors. Errors :" + numWriteErrors);
        }
        writeClient.commitCompaction(instantTime, compactionMetadata.getCommitMetadata().get(), Option.empty());
    }
}

