/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.storage.HoodieStorage;

public class DirectMarkerTransactionManager
extends TransactionManager {
    private final String filePath;

    public DirectMarkerTransactionManager(HoodieWriteConfig config, HoodieStorage storage, String partitionPath, String fileId) {
        super(new LockManager(config, storage, DirectMarkerTransactionManager.createUpdatedLockProps(config, partitionPath, fileId)), config.isLockRequired());
        this.filePath = partitionPath + "/" + fileId;
    }

    public void beginTransaction(String newTxnOwnerInstantTime, InstantGenerator instantGenerator) {
        if (this.isLockRequired) {
            LOG.info("Transaction starting for " + newTxnOwnerInstantTime + " and " + this.filePath);
            this.lockManager.lock();
            this.reset(this.currentTxnOwnerInstant, Option.of(this.getInstant(newTxnOwnerInstantTime, instantGenerator)), Option.empty());
            LOG.info("Transaction started for " + newTxnOwnerInstantTime + " and " + this.filePath);
        }
    }

    public void endTransaction(String currentTxnOwnerInstantTime, InstantGenerator instantGenerator) {
        if (this.isLockRequired) {
            LOG.info("Transaction ending with transaction owner " + currentTxnOwnerInstantTime + " for " + this.filePath);
            if (this.reset(Option.of(this.getInstant(currentTxnOwnerInstantTime, instantGenerator)), Option.empty(), Option.empty())) {
                this.lockManager.unlock();
                LOG.info("Transaction ended with transaction owner " + currentTxnOwnerInstantTime + " for " + this.filePath);
            }
        }
    }

    private static TypedProperties createUpdatedLockProps(HoodieWriteConfig writeConfig, String partitionPath, String fileId) {
        if (!ZookeeperBasedLockProvider.class.getName().equals(writeConfig.getLockProviderClass())) {
            throw new HoodieNotSupportedException("Only Support ZK-based lock for DirectMarkerTransactionManager now.");
        }
        TypedProperties props = new TypedProperties(writeConfig.getProps());
        props.setProperty("hoodie.write.lock.zookeeper.lock_key", null != partitionPath && !partitionPath.isEmpty() ? partitionPath + "/" + fileId : fileId);
        return props;
    }

    private HoodieInstant getInstant(String instantTime, InstantGenerator instantGenerator) {
        return instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "", instantTime);
    }
}

