/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.com.codahale.metrics.Counter;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.com.codahale.metrics.SlidingWindowReservoir;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;

public class HoodieLockMetrics {
    public static final String LOCK_ACQUIRE_ATTEMPTS_COUNTER_NAME = "lock.acquire.attempts";
    public static final String LOCK_ACQUIRE_SUCCESS_COUNTER_NAME = "lock.acquire.success";
    public static final String LOCK_ACQUIRE_FAILURES_COUNTER_NAME = "lock.acquire.failure";
    public static final String LOCK_ACQUIRE_DURATION_TIMER_NAME = "lock.acquire.duration";
    public static final String LOCK_REQUEST_LATENCY_TIMER_NAME = "lock.request.latency";
    private final HoodieWriteConfig writeConfig;
    private final boolean isMetricsEnabled;
    private final int keepLastNtimes = 100;
    private final transient HoodieTimer lockDurationTimer = HoodieTimer.create();
    private final transient HoodieTimer lockApiRequestDurationTimer = HoodieTimer.create();
    private transient Counter lockAttempts;
    private transient Counter successfulLockAttempts;
    private transient Counter failedLockAttempts;
    private transient Timer lockDuration;
    private transient Timer lockApiRequestDuration;
    private static final Object REGISTRY_LOCK = new Object();
    private Metrics metrics;

    public HoodieLockMetrics(HoodieWriteConfig writeConfig, HoodieStorage storage) {
        this.isMetricsEnabled = writeConfig.isLockingMetricsEnabled();
        this.writeConfig = writeConfig;
        if (this.isMetricsEnabled) {
            this.metrics = Metrics.getInstance(writeConfig.getMetricsConfig(), storage);
            MetricRegistry registry = this.metrics.getRegistry();
            this.lockAttempts = registry.counter(this.getMetricsName(LOCK_ACQUIRE_ATTEMPTS_COUNTER_NAME));
            this.successfulLockAttempts = registry.counter(this.getMetricsName(LOCK_ACQUIRE_SUCCESS_COUNTER_NAME));
            this.failedLockAttempts = registry.counter(this.getMetricsName(LOCK_ACQUIRE_FAILURES_COUNTER_NAME));
            this.lockDuration = this.createTimerForMetrics(registry, LOCK_ACQUIRE_DURATION_TIMER_NAME);
            this.lockApiRequestDuration = this.createTimerForMetrics(registry, LOCK_REQUEST_LATENCY_TIMER_NAME);
        }
    }

    private String getMetricsName(String metric) {
        return this.writeConfig == null ? null : String.format("%s.%s", this.writeConfig.getMetricReporterMetricsNamePrefix(), metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer createTimerForMetrics(MetricRegistry registry, String metric) {
        String metricName = this.getMetricsName(metric);
        if (registry.getMetrics().get(metricName) == null) {
            Object object = REGISTRY_LOCK;
            synchronized (object) {
                if (registry.getMetrics().get(metricName) == null) {
                    this.lockDuration = new Timer(new SlidingWindowReservoir(100));
                    registry.register(metricName, this.lockDuration);
                    return this.lockDuration;
                }
            }
        }
        return (Timer)registry.getMetrics().get(metricName);
    }

    public void startLockApiTimerContext() {
        if (this.isMetricsEnabled) {
            this.lockApiRequestDurationTimer.startTimer();
        }
    }

    public void updateLockAcquiredMetric() {
        if (this.isMetricsEnabled) {
            long durationMs = this.lockApiRequestDurationTimer.endTimer();
            this.lockApiRequestDuration.update(durationMs, TimeUnit.MILLISECONDS);
            this.lockAttempts.inc();
            this.successfulLockAttempts.inc();
            this.lockDurationTimer.startTimer();
        }
    }

    public void updateLockNotAcquiredMetric() {
        if (this.isMetricsEnabled) {
            long durationMs = this.lockApiRequestDurationTimer.endTimer();
            this.lockApiRequestDuration.update(durationMs, TimeUnit.MILLISECONDS);
            this.failedLockAttempts.inc();
        }
    }

    public void updateLockHeldTimerMetrics() {
        if (this.isMetricsEnabled && this.lockDurationTimer != null) {
            long lockDurationInMs = this.lockDurationTimer.endTimer();
            this.lockDuration.update(lockDurationInMs, TimeUnit.MILLISECONDS);
        }
    }
}

