/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.uber.m3.tally.m3.thrift;

import java.net.SocketAddress;
import java.net.SocketException;
import org.apache.hudi.com.uber.m3.tally.m3.thrift.TUdpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TMultiUdpClient
extends TTransport
implements AutoCloseable {
    private TTransport[] transports;

    public TMultiUdpClient(SocketAddress[] socketAddresses) throws SocketException {
        if (socketAddresses == null || socketAddresses.length == 0) {
            throw new IllegalArgumentException("Must provide at least one SocketAddress");
        }
        this.transports = new TTransport[socketAddresses.length];
        for (int i = 0; i < socketAddresses.length; ++i) {
            this.transports[i] = new TUdpClient(socketAddresses[i]);
        }
    }

    public boolean isOpen() {
        for (TTransport transport : this.transports) {
            if (transport.isOpen()) continue;
            return false;
        }
        return true;
    }

    public void open() throws TTransportException {
        for (TTransport transport : this.transports) {
            transport.open();
        }
    }

    @Override
    public void close() {
        for (TTransport transport : this.transports) {
            transport.close();
        }
    }

    public int read(byte[] bytes, int offset, int length) throws TTransportException {
        throw new UnsupportedOperationException("Reading from multiple transports is not supported");
    }

    public void write(byte[] bytes, int offset, int length) throws TTransportException {
        for (TTransport transport : this.transports) {
            transport.write(bytes, offset, length);
        }
    }

    public void flush() throws TTransportException {
        for (TTransport transport : this.transports) {
            transport.flush();
        }
    }
}

