/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.PropertiesConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSPropertiesConfiguration
extends PropertiesConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DFSPropertiesConfiguration.class);
    public static final String DEFAULT_PROPERTIES_FILE = "hudi-defaults.conf";
    public static final String CONF_FILE_DIR_ENV_NAME = "HUDI_CONF_DIR";
    public static final String DEFAULT_CONF_FILE_DIR = "file:/etc/hudi/conf";
    public static final StoragePath DEFAULT_PATH = new StoragePath("file:/etc/hudi/conf", "hudi-defaults.conf");
    private static TypedProperties GLOBAL_PROPS = DFSPropertiesConfiguration.loadGlobalProps();
    @Nullable
    private final Configuration hadoopConfig;
    private StoragePath mainFilePath;
    private final HoodieConfig hoodieConfig;
    private final Set<String> visitedFilePaths;

    public DFSPropertiesConfiguration(@Nonnull Configuration hadoopConf, @Nonnull StoragePath filePath) {
        this.hadoopConfig = hadoopConf;
        this.mainFilePath = filePath;
        this.hoodieConfig = new HoodieConfig();
        this.visitedFilePaths = new HashSet<String>();
        this.addPropsFromFile(filePath);
    }

    public DFSPropertiesConfiguration() {
        this.hadoopConfig = null;
        this.mainFilePath = null;
        this.hoodieConfig = new HoodieConfig();
        this.visitedFilePaths = new HashSet<String>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypedProperties loadGlobalProps() {
        DFSPropertiesConfiguration conf = new DFSPropertiesConfiguration();
        URL configFile = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_PROPERTIES_FILE);
        if (configFile != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(configFile.openStream(), StandardCharsets.UTF_8));){
                conf.addPropsFromStream(br, new StoragePath(configFile.toURI()));
                TypedProperties typedProperties = conf.getProps();
                return typedProperties;
            }
            catch (URISyntaxException e) {
                throw new HoodieException(String.format("Provided props file url is invalid %s", configFile), e);
            }
            catch (IOException ioe) {
                throw new HoodieIOException(String.format("Failed to read %s from class loader", DEFAULT_PROPERTIES_FILE), ioe);
            }
        }
        try {
            conf.addPropsFromFile(DEFAULT_PATH);
        }
        catch (Exception e) {
            LOG.warn("Cannot load default config file: " + DEFAULT_PATH, (Throwable)e);
        }
        Option<StoragePath> defaultConfPath = DFSPropertiesConfiguration.getConfPathFromEnv();
        if (!defaultConfPath.isPresent()) return conf.getProps();
        if (defaultConfPath.get().equals(DEFAULT_PATH)) return conf.getProps();
        conf.addPropsFromFile(defaultConfPath.get());
        return conf.getProps();
    }

    public static void refreshGlobalProps() {
        GLOBAL_PROPS = DFSPropertiesConfiguration.loadGlobalProps();
    }

    public static void clearGlobalProps() {
        GLOBAL_PROPS = new TypedProperties();
    }

    public void addPropsFromFile(StoragePath filePath) {
        if (this.visitedFilePaths.contains(filePath.toString())) {
            throw new IllegalStateException("Loop detected; file " + filePath + " already referenced");
        }
        HoodieHadoopStorage storage = new HoodieHadoopStorage(filePath, HadoopFSUtils.getStorageConf(Option.ofNullable(this.hadoopConfig).orElseGet(Configuration::new)));
        try {
            if (filePath.equals(DEFAULT_PATH) && !((HoodieStorage)storage).exists(filePath)) {
                LOG.warn("Properties file " + filePath + " not found. Ignoring to load props file");
                return;
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Cannot check if the properties file exist: " + filePath, ioe);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((HoodieStorage)storage).open(filePath), StandardCharsets.UTF_8));){
            this.visitedFilePaths.add(filePath.toString());
            this.addPropsFromStream(reader, filePath);
        }
        catch (IOException ioe) {
            LOG.error("Error reading in properties from dfs from file " + filePath);
            throw new HoodieIOException("Cannot read properties from dfs from file " + filePath, ioe);
        }
    }

    public void addPropsFromStream(BufferedReader reader, StoragePath cfgFilePath) throws IOException {
        try {
            reader.lines().forEach(line -> {
                if (!this.isValidLine((String)line)) {
                    return;
                }
                String[] split = this.splitProperty((String)line);
                if (line.startsWith("include=") || line.startsWith("include =")) {
                    StoragePath providedPath = new StoragePath(split[1]);
                    HoodieStorage providedStorage = HoodieStorageUtils.getStorage(split[1], HadoopFSUtils.getStorageConf(this.hadoopConfig));
                    if ((!providedPath.isAbsolute() || StringUtils.isNullOrEmpty(providedStorage.getScheme())) && cfgFilePath != null) {
                        providedPath = new StoragePath(cfgFilePath.getParent(), split[1]);
                    }
                    this.addPropsFromFile(providedPath);
                } else {
                    this.hoodieConfig.setValue(split[0], split[1]);
                }
            });
        }
        finally {
            reader.close();
        }
    }

    @Override
    public TypedProperties getGlobalProperties() {
        return DFSPropertiesConfiguration.getGlobalProps();
    }

    public static TypedProperties getGlobalProps() {
        TypedProperties globalProps = new TypedProperties();
        globalProps.putAll((Map<?, ?>)GLOBAL_PROPS);
        return globalProps;
    }

    public static TypedProperties addToGlobalProps(String key, String value) {
        GLOBAL_PROPS.put(key, value);
        return GLOBAL_PROPS;
    }

    public TypedProperties getProps() {
        return new TypedProperties(this.hoodieConfig.getProps());
    }

    public TypedProperties getProps(boolean includeGlobalProps) {
        return new TypedProperties(this.hoodieConfig.getProps(includeGlobalProps));
    }

    private static Option<StoragePath> getConfPathFromEnv() {
        String confDir = System.getenv(CONF_FILE_DIR_ENV_NAME);
        if (confDir == null) {
            LOG.warn("Cannot find HUDI_CONF_DIR, please set it as the dir of hudi-defaults.conf");
            return Option.empty();
        }
        if (StringUtils.isNullOrEmpty(URI.create(confDir).getScheme())) {
            confDir = "file://" + confDir;
        }
        return Option.of(new StoragePath(confDir + File.separator + DEFAULT_PROPERTIES_FILE));
    }

    private String[] splitProperty(String line) {
        String delimiter = (line = line.replaceAll("\\s+", " ")).contains("=") ? "=" : " ";
        int ind = line.indexOf(delimiter);
        String k = line.substring(0, ind).trim();
        String v = line.substring(ind + 1).trim();
        return new String[]{k, v};
    }

    private boolean isValidLine(String line) {
        ValidationUtils.checkArgument(line != null, "passed line is null");
        if (line.startsWith("#") || line.equals("")) {
            return false;
        }
        return line.contains("=") || line.matches(".*\\s.*");
    }
}

