/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Properties;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class FirstValueAvroPayload
extends DefaultHoodieRecordPayload {
    public FirstValueAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public FirstValueAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.recordBytes.length == 0) {
            return this;
        }
        if (oldValue.orderingVal.compareTo(this.orderingVal) >= 0) {
            return oldValue;
        }
        return this;
    }

    @Override
    protected boolean needUpdatingPersistedRecord(IndexedRecord currentValue, IndexedRecord incomingRecord, Properties properties) {
        String orderField = ConfigUtils.getOrderingField(properties);
        if (orderField == null) {
            return true;
        }
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        Object persistedOrderingVal = HoodieAvroUtils.getNestedFieldVal((GenericRecord)currentValue, orderField, true, consistentLogicalTimestampEnabled);
        Comparable incomingOrderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)incomingRecord, orderField, true, consistentLogicalTimestampEnabled);
        return persistedOrderingVal == null || ((Comparable)persistedOrderingVal).compareTo(incomingOrderingVal) < 0;
    }
}

