/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.Set;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StoragePath;

public interface HoodieActiveTimeline
extends HoodieTimeline {
    public Set<String> getValidExtensionsInActiveTimeline();

    public void createCompleteInstant(HoodieInstant var1);

    public void createNewInstant(HoodieInstant var1);

    public void createRequestedCommitWithReplaceMetadata(String var1, String var2);

    public void saveAsComplete(HoodieInstant var1, Option<byte[]> var2);

    public void saveAsComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant revertToInflight(HoodieInstant var1);

    public void deleteInflight(HoodieInstant var1);

    public void deletePending(HoodieInstant var1);

    public void deleteCompletedRollback(HoodieInstant var1);

    public void deleteEmptyInstantIfExists(HoodieInstant var1);

    public void deleteCompactionRequested(HoodieInstant var1);

    public void deleteInstantFileIfExists(HoodieInstant var1);

    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidSchema();

    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidData();

    public Option<byte[]> readCleanerInfoAsBytes(HoodieInstant var1);

    public Option<byte[]> readRollbackInfoAsBytes(HoodieInstant var1);

    public Option<byte[]> readRestoreInfoAsBytes(HoodieInstant var1);

    public Option<byte[]> readCompactionPlanAsBytes(HoodieInstant var1);

    public Option<byte[]> readIndexPlanAsBytes(HoodieInstant var1);

    public HoodieInstant revertInstantFromInflightToRequested(HoodieInstant var1);

    public HoodieInstant revertLogCompactionInflightToRequested(HoodieInstant var1);

    public HoodieInstant transitionCompactionRequestedToInflight(HoodieInstant var1);

    public HoodieInstant transitionLogCompactionRequestedToInflight(HoodieInstant var1);

    public HoodieInstant transitionCompactionInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant transitionLogCompactionInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant transitionCleanInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant transitionCleanRequestedToInflight(HoodieInstant var1, Option<byte[]> var2);

    public HoodieInstant transitionRollbackInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant transitionRollbackRequestedToInflight(HoodieInstant var1);

    public HoodieInstant transitionRestoreRequestedToInflight(HoodieInstant var1);

    public HoodieInstant transitionReplaceRequestedToInflight(HoodieInstant var1, Option<byte[]> var2);

    public HoodieInstant transitionClusterRequestedToInflight(HoodieInstant var1, Option<byte[]> var2);

    public HoodieInstant transitionReplaceInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant transitionClusterInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public void transitionRequestedToInflight(String var1, String var2);

    public void transitionRequestedToInflight(HoodieInstant var1, Option<byte[]> var2);

    public void transitionRequestedToInflight(HoodieInstant var1, Option<byte[]> var2, boolean var3);

    public void saveToCompactionRequested(HoodieInstant var1, Option<byte[]> var2);

    public void saveToCompactionRequested(HoodieInstant var1, Option<byte[]> var2, boolean var3);

    public void saveToLogCompactionRequested(HoodieInstant var1, Option<byte[]> var2);

    public void saveToLogCompactionRequested(HoodieInstant var1, Option<byte[]> var2, boolean var3);

    public void saveToPendingReplaceCommit(HoodieInstant var1, Option<byte[]> var2);

    public void saveToPendingClusterCommit(HoodieInstant var1, Option<byte[]> var2);

    public void saveToCleanRequested(HoodieInstant var1, Option<byte[]> var2);

    public void saveToRollbackRequested(HoodieInstant var1, Option<byte[]> var2);

    public void saveToRestoreRequested(HoodieInstant var1, Option<byte[]> var2);

    public HoodieInstant transitionIndexRequestedToInflight(HoodieInstant var1, Option<byte[]> var2);

    public HoodieInstant transitionIndexInflightToComplete(boolean var1, HoodieInstant var2, Option<byte[]> var3);

    public HoodieInstant revertIndexInflightToRequested(HoodieInstant var1);

    public void saveToPendingIndexAction(HoodieInstant var1, Option<byte[]> var2);

    public HoodieActiveTimeline reload();

    public void copyInstant(HoodieInstant var1, StoragePath var2);

    public Set<String> getValidExtensions();
}

