/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StoragePathInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstantStateDTO {
    @JsonProperty(value="instant")
    String instant;
    @JsonProperty(value="state")
    String state;

    public static InstantStateDTO fromStoragePathInfo(StoragePathInfo pathInfo) {
        InstantStateDTO ret = new InstantStateDTO();
        String fileName = pathInfo.getPath().getName();
        String[] nameAndExt = fileName.split("\\.");
        ValidationUtils.checkState(nameAndExt.length == 2);
        ret.instant = nameAndExt[0];
        ret.state = nameAndExt[1];
        return ret;
    }

    public String getInstant() {
        return this.instant;
    }

    public String getState() {
        return this.state;
    }
}

