/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;

public class CompletionTimeQueryViewV1
implements CompletionTimeQueryView,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long MILLI_SECONDS_IN_THREE_DAYS = 259200000L;
    private static final long MILLI_SECONDS_IN_ONE_DAY = 86400000L;
    private final HoodieTableMetaClient metaClient;
    private final ConcurrentMap<String, String> beginToCompletionInstantTimeMap;
    private volatile String cursorInstant;
    private final String firstNonSavepointCommit;

    public CompletionTimeQueryViewV1(HoodieTableMetaClient metaClient) {
        this(metaClient, HoodieInstantTimeGenerator.formatDate(new Date(Instant.now().minusMillis(259200000L).toEpochMilli())));
    }

    public CompletionTimeQueryViewV1(HoodieTableMetaClient metaClient, String eagerLoadInstant) {
        this.metaClient = metaClient;
        this.beginToCompletionInstantTimeMap = new ConcurrentHashMap<String, String>();
        this.cursorInstant = InstantComparison.minInstant(eagerLoadInstant, metaClient.getActiveTimeline().firstInstant().map(HoodieInstant::requestedTime).orElse(""));
        this.firstNonSavepointCommit = metaClient.getActiveTimeline().getWriteTimeline().getFirstNonSavepointCommit().map(HoodieInstant::requestedTime).orElse("");
        this.load();
    }

    @Override
    public boolean isCompleted(String beginInstantTime) {
        return this.beginToCompletionInstantTimeMap.containsKey(beginInstantTime) || this.isArchived(beginInstantTime);
    }

    @Override
    public boolean isArchived(String instantTime) {
        return InstantComparison.compareTimestamps(instantTime, InstantComparison.LESSER_THAN, this.firstNonSavepointCommit);
    }

    @Override
    public boolean isCompletedBefore(String baseInstant, String instantTime) {
        Option<String> completionTimeOpt = this.getCompletionTime(baseInstant, instantTime);
        if (completionTimeOpt.isPresent()) {
            return InstantComparison.compareTimestamps(completionTimeOpt.get(), InstantComparison.LESSER_THAN, baseInstant);
        }
        return false;
    }

    @Override
    public boolean isSlicedAfterOrOn(String baseInstant, String instantTime) {
        Option<String> completionTimeOpt = this.getCompletionTime(baseInstant, instantTime);
        if (completionTimeOpt.isPresent()) {
            return InstantComparison.compareTimestamps(completionTimeOpt.get(), InstantComparison.GREATER_THAN_OR_EQUALS, baseInstant);
        }
        return true;
    }

    @Override
    public Option<String> getCompletionTime(String baseInstant, String instantTime) {
        String completionTime;
        Option<String> completionTimeOpt = this.getCompletionTime(instantTime);
        if (completionTimeOpt.isPresent() && (completionTime = completionTimeOpt.get()).length() != baseInstant.length()) {
            return Option.of(instantTime);
        }
        return completionTimeOpt;
    }

    @Override
    public Option<String> getCompletionTime(String beginTime) {
        if (beginTime.length() < 10) {
            return Option.of(beginTime);
        }
        String completionTime = (String)this.beginToCompletionInstantTimeMap.get(beginTime);
        if (completionTime != null) {
            return Option.of(completionTime);
        }
        if (this.isArchived(beginTime)) {
            return Option.of(beginTime);
        }
        return Option.empty();
    }

    @Override
    public List<String> getInstantTimes(HoodieTimeline timeline, Option<String> rangeStart, Option<String> rangeEnd, InstantRange.RangeType rangeType) {
        return this.getInstantTimes(timeline, rangeStart, rangeEnd, rangeType, s -> HoodieInstantTimeGenerator.instantTimeMinusMillis(s, 86400000L));
    }

    @Override
    @VisibleForTesting
    public List<String> getInstantTimes(String rangeStart, String rangeEnd, Function<String, String> earliestInstantTimeFunc) {
        return this.getInstantTimes(this.metaClient.getCommitsTimeline().filterCompletedInstants(), Option.ofNullable(rangeStart), Option.ofNullable(rangeEnd), InstantRange.RangeType.CLOSED_CLOSED, earliestInstantTimeFunc);
    }

    private List<String> getInstantTimes(HoodieTimeline timeline, Option<String> rangeStart, Option<String> rangeEnd, InstantRange.RangeType rangeType, Function<String, String> earliestInstantTimeFunc) {
        throw new RuntimeException("Incremental query view for timeline version 1 not yet implemented");
    }

    private void load() {
        this.metaClient.getActiveTimeline().filterCompletedInstants().getInstantsAsStream().forEach(instant -> this.setCompletionTime(instant.requestedTime(), instant.getCompletionTime()));
    }

    private void setCompletionTime(String beginInstantTime, String completionTime) {
        if (completionTime == null) {
            completionTime = beginInstantTime;
        }
        this.beginToCompletionInstantTimeMap.putIfAbsent(beginInstantTime, completionTime);
    }

    @Override
    public String getCursorInstant() {
        return this.cursorInstant;
    }

    @Override
    public boolean isEmptyTable() {
        return this.beginToCompletionInstantTimeMap.isEmpty();
    }

    @Override
    public void close() {
        this.beginToCompletionInstantTimeMap.clear();
    }
}

