/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.StringUtils;

public class InstantFileNameGeneratorV1
implements InstantFileNameGenerator {
    @Override
    public TimelineLayoutVersion getLayoutVersion() {
        return TimelineLayoutVersion.LAYOUT_VERSION_1;
    }

    @Override
    public String makeCommitFileName(String instantTime) {
        return StringUtils.join(instantTime, ".commit");
    }

    @Override
    public String makeInflightCommitFileName(String instantTime) {
        return StringUtils.join(instantTime, ".inflight");
    }

    @Override
    public String makeRequestedCommitFileName(String instantTime) {
        return StringUtils.join(instantTime, ".commit.requested");
    }

    @Override
    public String makeCleanerFileName(String instant) {
        return StringUtils.join(instant, ".clean");
    }

    @Override
    public String makeRequestedCleanerFileName(String instant) {
        return StringUtils.join(instant, ".clean.requested");
    }

    @Override
    public String makeInflightCleanerFileName(String instant) {
        return StringUtils.join(instant, ".clean.inflight");
    }

    @Override
    public String makeRollbackFileName(String instant) {
        return StringUtils.join(instant, ".rollback");
    }

    @Override
    public String makeRequestedRollbackFileName(String instant) {
        return StringUtils.join(instant, ".rollback.requested");
    }

    @Override
    public String makeRequestedRestoreFileName(String instant) {
        return StringUtils.join(instant, ".restore.requested");
    }

    @Override
    public String makeInflightRollbackFileName(String instant) {
        return StringUtils.join(instant, ".rollback.inflight");
    }

    @Override
    public String makeInflightSavePointFileName(String instantTime) {
        return StringUtils.join(instantTime, ".savepoint.inflight");
    }

    @Override
    public String makeSavePointFileName(String instantTime) {
        return StringUtils.join(instantTime, ".savepoint");
    }

    @Override
    public String makeInflightDeltaFileName(String instantTime) {
        return StringUtils.join(instantTime, ".deltacommit.inflight");
    }

    @Override
    public String makeRequestedDeltaFileName(String instantTime) {
        return StringUtils.join(instantTime, ".deltacommit.requested");
    }

    @Override
    public String makeInflightCompactionFileName(String instantTime) {
        return StringUtils.join(instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION);
    }

    @Override
    public String makeRequestedCompactionFileName(String instantTime) {
        return StringUtils.join(instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION);
    }

    @Override
    public String makeInflightLogCompactionFileName(String instantTime) {
        return StringUtils.join(instantTime, HoodieTimeline.INFLIGHT_LOG_COMPACTION_EXTENSION);
    }

    @Override
    public String makeRequestedLogCompactionFileName(String instantTime) {
        return StringUtils.join(instantTime, HoodieTimeline.REQUESTED_LOG_COMPACTION_EXTENSION);
    }

    @Override
    public String makeRestoreFileName(String instant) {
        return StringUtils.join(instant, ".restore");
    }

    @Override
    public String makeInflightRestoreFileName(String instant) {
        return StringUtils.join(instant, ".restore.inflight");
    }

    @Override
    public String makeReplaceFileName(String instant) {
        return StringUtils.join(instant, ".replacecommit");
    }

    @Override
    public String makeInflightReplaceFileName(String instant) {
        return StringUtils.join(instant, ".replacecommit.inflight");
    }

    @Override
    public String makeRequestedReplaceFileName(String instant) {
        return StringUtils.join(instant, ".replacecommit.requested");
    }

    @Override
    public String makeDeltaFileName(String instantTime) {
        return instantTime + ".deltacommit";
    }

    @Override
    public String getCommitFromCommitFile(String commitFileName) {
        return commitFileName.split("\\.")[0];
    }

    @Override
    public String makeFileNameAsComplete(String fileName) {
        return fileName.replace(".inflight", "");
    }

    @Override
    public String makeFileNameAsInflight(String fileName) {
        return StringUtils.join(fileName, ".inflight");
    }

    @Override
    public String makeIndexCommitFileName(String instant) {
        return StringUtils.join(instant, ".indexing");
    }

    @Override
    public String makeInflightIndexFileName(String instant) {
        return StringUtils.join(instant, ".indexing.inflight");
    }

    @Override
    public String makeRequestedIndexFileName(String instant) {
        return StringUtils.join(instant, ".indexing.requested");
    }

    @Override
    public String makeSchemaFileName(String instantTime) {
        return StringUtils.join(instantTime, ".schemacommit");
    }

    @Override
    public String makeInflightSchemaFileName(String instantTime) {
        return StringUtils.join(instantTime, ".schemacommit.inflight");
    }

    @Override
    public String makeRequestSchemaFileName(String instantTime) {
        return StringUtils.join(instantTime, ".schemacommit.requested");
    }

    @Override
    public String makeRequestedClusteringFileName(String instant) {
        return this.makeRequestedReplaceFileName(instant);
    }

    @Override
    public String makeInflightClusteringFileName(String instant) {
        return this.makeInflightReplaceFileName(instant);
    }

    @Override
    public String getFileName(HoodieInstant instant) {
        String action = instant.getAction();
        String timestamp = instant.requestedTime();
        if ("commit".equals(action)) {
            return instant.isInflight() ? this.makeInflightCommitFileName(timestamp) : (instant.isRequested() ? this.makeRequestedCommitFileName(timestamp) : this.makeCommitFileName(timestamp));
        }
        if ("clean".equals(action)) {
            return instant.isInflight() ? this.makeInflightCleanerFileName(timestamp) : (instant.isRequested() ? this.makeRequestedCleanerFileName(timestamp) : this.makeCleanerFileName(timestamp));
        }
        if ("rollback".equals(action)) {
            return instant.isInflight() ? this.makeInflightRollbackFileName(timestamp) : (instant.isRequested() ? this.makeRequestedRollbackFileName(timestamp) : this.makeRollbackFileName(timestamp));
        }
        if ("savepoint".equals(action)) {
            return instant.isInflight() ? this.makeInflightSavePointFileName(timestamp) : this.makeSavePointFileName(timestamp);
        }
        if ("deltacommit".equals(action)) {
            return instant.isInflight() ? this.makeInflightDeltaFileName(timestamp) : (instant.isRequested() ? this.makeRequestedDeltaFileName(timestamp) : this.makeDeltaFileName(timestamp));
        }
        if ("compaction".equals(action)) {
            if (instant.isInflight()) {
                return this.makeInflightCompactionFileName(timestamp);
            }
            if (instant.isRequested()) {
                return this.makeRequestedCompactionFileName(timestamp);
            }
            return this.makeCommitFileName(timestamp);
        }
        if ("logcompaction".equals(action)) {
            if (instant.isInflight()) {
                return this.makeInflightLogCompactionFileName(timestamp);
            }
            if (instant.isRequested()) {
                return this.makeRequestedLogCompactionFileName(timestamp);
            }
            return this.makeDeltaFileName(timestamp);
        }
        if ("restore".equals(action)) {
            return instant.isInflight() ? this.makeInflightRestoreFileName(timestamp) : (instant.isRequested() ? this.makeRequestedRestoreFileName(timestamp) : this.makeRestoreFileName(timestamp));
        }
        if ("replacecommit".equals(action)) {
            return instant.isInflight() ? this.makeInflightReplaceFileName(timestamp) : (instant.isRequested() ? this.makeRequestedReplaceFileName(timestamp) : this.makeReplaceFileName(timestamp));
        }
        if ("indexing".equals(action)) {
            return instant.isInflight() ? this.makeInflightIndexFileName(timestamp) : (instant.isRequested() ? this.makeRequestedIndexFileName(timestamp) : this.makeIndexCommitFileName(timestamp));
        }
        if ("schemacommit".equals(action)) {
            return instant.isInflight() ? this.makeInflightSchemaFileName(timestamp) : (instant.isRequested() ? this.makeRequestSchemaFileName(timestamp) : this.makeSchemaFileName(timestamp));
        }
        throw new IllegalArgumentException("Cannot get file name for unknown action " + action);
    }

    @Override
    public String getFileName(String completionTime, HoodieInstant instant) {
        return this.getFileName(instant);
    }
}

