/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ArchivedTimelineLoader;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.ArchivedTimelineLoaderV2;
import org.apache.hudi.common.table.timeline.versioning.v2.ArchivedTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.BaseTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.CompletionTimeQueryViewV2;
import org.apache.hudi.common.util.Option;

public class TimelineV2Factory
extends TimelineFactory {
    private final TimelineLayout layout;

    public TimelineV2Factory(TimelineLayout layout) {
        this.layout = layout;
    }

    @Override
    public HoodieTimeline createDefaultTimeline(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details) {
        return new BaseTimelineV2(instants, details);
    }

    @Override
    public HoodieActiveTimeline createActiveTimeline() {
        return new ActiveTimelineV2();
    }

    @Override
    public HoodieArchivedTimeline createArchivedTimeline(HoodieTableMetaClient metaClient) {
        return new ArchivedTimelineV2(metaClient);
    }

    @Override
    public HoodieArchivedTimeline createArchivedTimeline(HoodieTableMetaClient metaClient, String startTs) {
        return new ArchivedTimelineV2(metaClient, startTs);
    }

    @Override
    public ArchivedTimelineLoader createArchivedTimelineLoader() {
        return new ArchivedTimelineLoaderV2();
    }

    @Override
    public HoodieActiveTimeline createActiveTimeline(HoodieTableMetaClient metaClient) {
        return new ActiveTimelineV2(metaClient);
    }

    @Override
    public HoodieActiveTimeline createActiveTimeline(HoodieTableMetaClient metaClient, boolean applyLayoutFilter) {
        return new ActiveTimelineV2(metaClient, applyLayoutFilter);
    }

    @Override
    public CompletionTimeQueryView createCompletionTimeQueryView(HoodieTableMetaClient metaClient) {
        return new CompletionTimeQueryViewV2(metaClient);
    }

    @Override
    public CompletionTimeQueryView createCompletionTimeQueryView(HoodieTableMetaClient metaClient, String eagerInstant) {
        return new CompletionTimeQueryViewV2(metaClient, eagerInstant);
    }
}

