/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantGeneratorV2;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringUtils.class);
    public static final String TOTAL_IO_READ_MB = "TOTAL_IO_READ_MB";
    public static final String TOTAL_LOG_FILE_SIZE = "TOTAL_LOG_FILES_SIZE";
    public static final String TOTAL_LOG_FILES = "TOTAL_LOG_FILES";

    public static Stream<Pair<HoodieInstant, HoodieClusteringPlan>> getAllPendingClusteringPlans(HoodieTableMetaClient metaClient) {
        List<HoodieInstant> pendingClusterInstants = metaClient.getActiveTimeline().filterPendingReplaceOrClusteringTimeline().getInstants();
        return pendingClusterInstants.stream().map(instant -> ClusteringUtils.getClusteringPlan(metaClient, instant)).filter(Option::isPresent).map(Option::get);
    }

    public static Option<HoodieInstant> getInflightClusteringInstant(String timestamp, HoodieActiveTimeline activeTimeline, InstantGenerator factory) {
        HoodieInstant inflightInstant;
        HoodieTimeline pendingReplaceOrClusterTimeline = activeTimeline.filterPendingReplaceOrClusteringTimeline();
        if (pendingReplaceOrClusterTimeline.containsInstant(inflightInstant = factory.getClusteringCommitInflightInstant(timestamp))) {
            return Option.of(inflightInstant);
        }
        inflightInstant = factory.getReplaceCommitInflightInstant(timestamp);
        return Option.ofNullable(pendingReplaceOrClusterTimeline.containsInstant(inflightInstant) ? inflightInstant : null);
    }

    public static Option<HoodieInstant> getRequestedClusteringInstant(String timestamp, HoodieActiveTimeline activeTimeline, InstantGenerator factory) {
        HoodieInstant requestedInstant;
        HoodieTimeline pendingReplaceOrClusterTimeline = activeTimeline.filterPendingReplaceOrClusteringTimeline();
        if (pendingReplaceOrClusterTimeline.containsInstant(requestedInstant = factory.getClusteringCommitRequestedInstant(timestamp))) {
            return Option.of(requestedInstant);
        }
        requestedInstant = factory.getReplaceCommitRequestedInstant(timestamp);
        return Option.ofNullable(pendingReplaceOrClusterTimeline.containsInstant(requestedInstant) ? requestedInstant : null);
    }

    public static void transitionClusteringOrReplaceInflightToComplete(boolean shouldLock, HoodieInstant clusteringInstant, Option<byte[]> commitMetadata, HoodieActiveTimeline activeTimeline) {
        if (clusteringInstant.getAction().equals("clustering")) {
            activeTimeline.transitionClusterInflightToComplete(shouldLock, clusteringInstant, commitMetadata);
        } else {
            activeTimeline.transitionReplaceInflightToComplete(shouldLock, clusteringInstant, commitMetadata);
        }
    }

    public static void transitionClusteringOrReplaceRequestedToInflight(HoodieInstant requestedClusteringInstant, Option<byte[]> data, HoodieActiveTimeline activeTimeline) {
        if (requestedClusteringInstant.getAction().equals("clustering")) {
            activeTimeline.transitionClusterRequestedToInflight(requestedClusteringInstant, data);
        } else {
            activeTimeline.transitionReplaceRequestedToInflight(requestedClusteringInstant, data);
        }
    }

    public static boolean isClusteringOrReplaceCommitAction(String actionType) {
        return actionType.equals("clustering") || actionType.equals("replacecommit");
    }

    public static boolean isClusteringInstant(HoodieTimeline timeline, HoodieInstant replaceInstant, InstantGenerator factory) {
        return replaceInstant.getAction().equals("clustering") || replaceInstant.getAction().equals("replacecommit") && ClusteringUtils.getClusteringPlan(timeline, replaceInstant, factory).isPresent();
    }

    private static Option<HoodieRequestedReplaceMetadata> getRequestedReplaceMetadata(HoodieTimeline timeline, HoodieInstant pendingReplaceOrClusterInstant, InstantGenerator factory) throws IOException {
        Option<Object> content;
        block7: {
            HoodieInstant requestedInstant;
            if (pendingReplaceOrClusterInstant.isInflight()) {
                requestedInstant = factory.createNewInstant(HoodieInstant.State.REQUESTED, pendingReplaceOrClusterInstant.getAction(), pendingReplaceOrClusterInstant.requestedTime());
            } else if (pendingReplaceOrClusterInstant.isRequested()) {
                requestedInstant = pendingReplaceOrClusterInstant;
            } else {
                String action = factory instanceof InstantGeneratorV2 ? "clustering" : "replacecommit";
                requestedInstant = factory.createNewInstant(HoodieInstant.State.REQUESTED, action, pendingReplaceOrClusterInstant.requestedTime());
            }
            content = Option.empty();
            try {
                content = timeline.getInstantDetails(requestedInstant);
            }
            catch (HoodieIOException e) {
                if (!(e.getCause() instanceof FileNotFoundException) || !pendingReplaceOrClusterInstant.isCompleted()) break block7;
                requestedInstant = factory.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", pendingReplaceOrClusterInstant.requestedTime());
                content = timeline.getInstantDetails(requestedInstant);
            }
        }
        if (!content.isPresent() || ((byte[])content.get()).length == 0) {
            return Option.empty();
        }
        return Option.of(TimelineMetadataUtils.deserializeRequestedReplaceMetadata((byte[])content.get()));
    }

    public static Option<Pair<HoodieInstant, HoodieClusteringPlan>> getClusteringPlan(HoodieTableMetaClient metaClient, HoodieInstant pendingReplaceInstant) {
        return ClusteringUtils.getClusteringPlan(metaClient.getActiveTimeline(), pendingReplaceInstant, metaClient.getInstantGenerator());
    }

    public static Option<Pair<HoodieInstant, HoodieClusteringPlan>> getClusteringPlan(HoodieTimeline timeline, HoodieInstant pendingReplaceInstant, InstantGenerator factory) {
        try {
            Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata = ClusteringUtils.getRequestedReplaceMetadata(timeline, pendingReplaceInstant, factory);
            if (requestedReplaceMetadata.isPresent() && WriteOperationType.CLUSTER.name().equals(requestedReplaceMetadata.get().getOperationType())) {
                return Option.of(Pair.of(pendingReplaceInstant, requestedReplaceMetadata.get().getClusteringPlan()));
            }
            return Option.empty();
        }
        catch (IOException e) {
            throw new HoodieIOException("Error reading clustering plan " + pendingReplaceInstant.requestedTime(), e);
        }
    }

    public static Map<HoodieFileGroupId, HoodieInstant> getAllFileGroupsInPendingClusteringPlans(HoodieTableMetaClient metaClient) {
        Map<HoodieFileGroupId, HoodieInstant> resultMap;
        Stream<Pair<HoodieInstant, HoodieClusteringPlan>> pendingClusteringPlans = ClusteringUtils.getAllPendingClusteringPlans(metaClient);
        Stream<Map<HoodieFileGroupId, HoodieInstant>> resultStream = pendingClusteringPlans.flatMap(clusteringPlan -> ClusteringUtils.getFileGroupEntriesInClusteringPlan((HoodieInstant)clusteringPlan.getLeft(), (HoodieClusteringPlan)((Object)((Object)clusteringPlan.getRight()))));
        try {
            resultMap = resultStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && e.getMessage().contains("Duplicate key")) {
                throw new HoodieException("Found duplicate file groups pending clustering. If you're running deltastreamer in continuous mode, consider adding delay using --min-sync-interval-seconds. Or consider setting write concurrency mode to OPTIMISTIC_CONCURRENCY_CONTROL.", e);
            }
            throw new HoodieException("Error getting all file groups in pending clustering", e);
        }
        LOG.info("Found " + resultMap.size() + " files in pending clustering operations");
        return resultMap;
    }

    public static Stream<Pair<HoodieFileGroupId, HoodieInstant>> getFileGroupsInPendingClusteringInstant(HoodieInstant instant, HoodieClusteringPlan clusteringPlan) {
        Stream<Pair> partitionToFileIdLists = clusteringPlan.getInputGroups().stream().flatMap(ClusteringUtils::getFileGroupsFromClusteringGroup);
        return partitionToFileIdLists.map(e -> Pair.of(e, instant));
    }

    private static Stream<Map.Entry<HoodieFileGroupId, HoodieInstant>> getFileGroupEntriesInClusteringPlan(HoodieInstant instant, HoodieClusteringPlan clusteringPlan) {
        return ClusteringUtils.getFileGroupsInPendingClusteringInstant(instant, clusteringPlan).map(entry -> new AbstractMap.SimpleEntry(entry.getLeft(), entry.getRight()));
    }

    public static Stream<HoodieFileGroupId> getFileGroupsFromClusteringPlan(HoodieClusteringPlan clusteringPlan) {
        return clusteringPlan.getInputGroups().stream().flatMap(ClusteringUtils::getFileGroupsFromClusteringGroup);
    }

    public static Stream<HoodieFileGroupId> getFileGroupsFromClusteringGroup(HoodieClusteringGroup group) {
        return group.getSlices().stream().map(slice -> new HoodieFileGroupId(slice.getPartitionPath(), slice.getFileId()));
    }

    public static HoodieClusteringPlan createClusteringPlan(String strategyClassName, Map<String, String> strategyParams, List<FileSlice>[] fileSliceGroups, Map<String, String> extraMetadata) {
        List<HoodieClusteringGroup> clusteringGroups = Arrays.stream(fileSliceGroups).map(fileSliceGroup -> {
            Map<String, Double> groupMetrics = ClusteringUtils.buildMetrics(fileSliceGroup);
            List<HoodieSliceInfo> sliceInfos = ClusteringUtils.getFileSliceInfo(fileSliceGroup);
            return HoodieClusteringGroup.newBuilder().setSlices(sliceInfos).setMetrics(groupMetrics).build();
        }).collect(Collectors.toList());
        HoodieClusteringStrategy strategy = HoodieClusteringStrategy.newBuilder().setStrategyClassName(strategyClassName).setStrategyParams(strategyParams).build();
        return HoodieClusteringPlan.newBuilder().setInputGroups(clusteringGroups).setExtraMetadata(extraMetadata).setStrategy(strategy).setPreserveHoodieMetadata(true).build();
    }

    private static List<HoodieSliceInfo> getFileSliceInfo(List<FileSlice> slices) {
        return slices.stream().map(slice -> HoodieSliceInfo.newBuilder().setPartitionPath(slice.getPartitionPath()).setFileId(slice.getFileId()).setDataFilePath(slice.getBaseFile().map(BaseFile::getPath).orElse(null)).setDeltaFilePaths(slice.getLogFiles().map(f -> f.getPath().getName()).collect(Collectors.toList())).setBootstrapFilePath(slice.getBaseFile().map(bf -> bf.getBootstrapBaseFile().map(BaseFile::getPath).orElse(null)).orElse(null)).build()).collect(Collectors.toList());
    }

    private static Map<String, Double> buildMetrics(List<FileSlice> fileSlices) {
        int numLogFiles = 0;
        long totalLogFileSize = 0L;
        long totalIORead = 0L;
        for (FileSlice slice : fileSlices) {
            numLogFiles = (int)((long)numLogFiles + slice.getLogFiles().count());
            totalIORead = FSUtils.getSizeInMB((slice.getBaseFile().isPresent() ? slice.getBaseFile().get().getFileSize() : 0L) + (totalLogFileSize += slice.getLogFiles().map(HoodieLogFile::getFileSize).filter(size -> size >= 0L).reduce(Long::sum).orElse(0L).longValue()));
        }
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put(TOTAL_IO_READ_MB, Double.valueOf(totalIORead));
        metrics.put(TOTAL_LOG_FILE_SIZE, Double.valueOf(totalLogFileSize));
        metrics.put(TOTAL_LOG_FILES, Double.valueOf(numLogFiles));
        return metrics;
    }

    public static List<HoodieInstant> getPendingClusteringInstantTimes(HoodieTableMetaClient metaClient) {
        InstantGenerator factory = metaClient.getInstantGenerator();
        return metaClient.getActiveTimeline().filterPendingReplaceOrClusteringTimeline().getInstantsAsStream().filter(instant -> ClusteringUtils.isClusteringInstant(metaClient.getActiveTimeline(), instant, factory)).collect(Collectors.toList());
    }

    public static Option<HoodieInstant> getEarliestInstantToRetainForClustering(HoodieActiveTimeline activeTimeline, HoodieTableMetaClient metaClient, HoodieCleaningPolicy cleanerPolicy) throws IOException {
        InstantGenerator factory = metaClient.getInstantGenerator();
        Option<HoodieInstant> oldestInstantToRetain = Option.empty();
        HoodieTimeline replaceOrClusterTimeline = activeTimeline.getTimelineOfActions(CollectionUtils.createSet("replacecommit", "clustering"));
        if (!replaceOrClusterTimeline.empty()) {
            Option<HoodieInstant> cleanInstantOpt = activeTimeline.getCleanerTimeline().filterCompletedInstants().lastInstant();
            if (cleanInstantOpt.isPresent()) {
                HoodieInstant cleanInstant = cleanInstantOpt.get();
                HoodieCleanerPlan cleanerPlan = CleanerUtils.getCleanerPlan(metaClient, cleanInstant.isRequested() ? cleanInstant : factory.getCleanRequestedInstant(cleanInstant.requestedTime()));
                Option<String> earliestInstantToRetain = Option.ofNullable(cleanerPlan.getEarliestInstantToRetain()).map(HoodieActionInstant::getTimestamp);
                Option<String> earliestReplacedSavepointInClean = ClusteringUtils.getEarliestReplacedSavepointInClean(activeTimeline, cleanerPolicy, cleanerPlan);
                String retainLowerBound = earliestReplacedSavepointInClean.isPresent() ? earliestReplacedSavepointInClean.get() : (earliestInstantToRetain.isPresent() && !StringUtils.isNullOrEmpty(earliestInstantToRetain.get()) ? earliestInstantToRetain.get() : cleanInstant.requestedTime());
                oldestInstantToRetain = replaceOrClusterTimeline.findInstantsAfterOrEquals(retainLowerBound).firstInstant();
            } else {
                oldestInstantToRetain = replaceOrClusterTimeline.firstInstant();
            }
        }
        return oldestInstantToRetain;
    }

    public static Option<String> getEarliestReplacedSavepointInClean(HoodieActiveTimeline activeTimeline, HoodieCleaningPolicy cleanerPolicy, HoodieCleanerPlan cleanerPlan) {
        HoodieTimeline replaceTimeline;
        String earliestInstantToRetain = Option.ofNullable(cleanerPlan.getEarliestInstantToRetain()).map(HoodieActionInstant::getTimestamp).orElse(null);
        Option<String[]> savepoints = Option.ofNullable(cleanerPlan.getExtraMetadata()).map(metadata -> metadata.getOrDefault("savepointed_timestamps", "").split(","));
        String earliestSavepoint = savepoints.flatMap(arr -> Option.fromJavaOptional(Arrays.stream(arr).sorted().findFirst())).orElse(null);
        if (cleanerPolicy != HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS && !StringUtils.isNullOrEmpty(earliestInstantToRetain) && !StringUtils.isNullOrEmpty(earliestSavepoint) && InstantComparison.compareTimestamps(earliestInstantToRetain, InstantComparison.GREATER_THAN, earliestSavepoint) && !(replaceTimeline = activeTimeline.getCompletedReplaceTimeline().findInstantsInClosedRange(earliestSavepoint, earliestInstantToRetain)).empty()) {
            return Option.of(earliestSavepoint);
        }
        return Option.empty();
    }

    public static boolean isCompletedClusteringInstant(HoodieInstant instant, HoodieTimeline timeline) {
        if (!instant.getAction().equals("replacecommit")) {
            return false;
        }
        try {
            return TimelineUtils.getCommitMetadata(instant, timeline).getOperationType().equals((Object)WriteOperationType.CLUSTER);
        }
        catch (IOException e) {
            throw new HoodieException("Resolve replace commit metadata error for instant: " + instant, e);
        }
    }

    public static boolean isInsertOverwriteInstant(HoodieInstant instant, HoodieTimeline timeline) {
        if (!instant.getAction().equals("replacecommit")) {
            return false;
        }
        try {
            WriteOperationType opType = TimelineUtils.getCommitMetadata(instant, timeline).getOperationType();
            return opType.equals((Object)WriteOperationType.INSERT_OVERWRITE) || opType.equals((Object)WriteOperationType.INSERT_OVERWRITE_TABLE);
        }
        catch (IOException e) {
            throw new HoodieException("Resolve replace commit metadata error for instant: " + instant, e);
        }
    }
}

