/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.GlobalSortPartitioner;
import org.apache.hudi.execution.bulkinsert.NonSortPartitioner;
import org.apache.hudi.execution.bulkinsert.PartitionPathRepartitionAndSortPartitioner;
import org.apache.hudi.execution.bulkinsert.PartitionPathRepartitionPartitioner;
import org.apache.hudi.execution.bulkinsert.RDDConsistentBucketBulkInsertPartitioner;
import org.apache.hudi.execution.bulkinsert.RDDPartitionSortPartitioner;
import org.apache.hudi.execution.bulkinsert.RDDSimpleBucketBulkInsertPartitioner;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;

public abstract class BulkInsertInternalPartitionerFactory {
    public static BulkInsertPartitioner get(HoodieTable table, HoodieWriteConfig config) {
        return BulkInsertInternalPartitionerFactory.get(table, config, false);
    }

    public static BulkInsertPartitioner get(HoodieTable table, HoodieWriteConfig config, boolean enforceNumOutputPartitions) {
        if (config.getIndexType().equals((Object)HoodieIndex.IndexType.BUCKET)) {
            if (config.getBucketIndexEngineType().equals((Object)HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING)) {
                return new RDDConsistentBucketBulkInsertPartitioner(table);
            }
            if (config.getBucketIndexEngineType().equals((Object)HoodieIndex.BucketIndexEngineType.SIMPLE)) {
                return new RDDSimpleBucketBulkInsertPartitioner(table);
            }
        }
        return BulkInsertInternalPartitionerFactory.get(config, table.isPartitioned(), enforceNumOutputPartitions);
    }

    public static BulkInsertPartitioner get(HoodieWriteConfig config, boolean isTablePartitioned, boolean enforceNumOutputPartitions) {
        BulkInsertSortMode sortMode = config.getBulkInsertSortMode();
        switch (sortMode) {
            case NONE: {
                return new NonSortPartitioner(enforceNumOutputPartitions);
            }
            case GLOBAL_SORT: {
                return new GlobalSortPartitioner(config);
            }
            case PARTITION_SORT: {
                return new RDDPartitionSortPartitioner(config);
            }
            case PARTITION_PATH_REPARTITION: {
                return new PartitionPathRepartitionPartitioner(isTablePartitioned, config);
            }
            case PARTITION_PATH_REPARTITION_AND_SORT: {
                return new PartitionPathRepartitionAndSortPartitioner(isTablePartitioned, config);
            }
        }
        throw new HoodieException("The bulk insert sort mode \"" + sortMode.name() + "\" is not supported.");
    }
}

