/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.GlobalSortPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.PartitionPathRepartitionAndSortPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.PartitionPathRepartitionPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.PartitionSortPartitionerWithRows;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class BulkInsertInternalPartitionerWithRowsFactory {
    public static BulkInsertPartitioner<Dataset<Row>> get(HoodieWriteConfig config, boolean isTablePartitioned) {
        return BulkInsertInternalPartitionerWithRowsFactory.get(config, isTablePartitioned, false);
    }

    public static BulkInsertPartitioner<Dataset<Row>> get(HoodieWriteConfig config, boolean isTablePartitioned, boolean enforceNumOutputPartitions) {
        BulkInsertSortMode sortMode = config.getBulkInsertSortMode();
        switch (sortMode) {
            case NONE: {
                return new NonSortPartitionerWithRows(enforceNumOutputPartitions);
            }
            case GLOBAL_SORT: {
                return new GlobalSortPartitionerWithRows(config);
            }
            case PARTITION_SORT: {
                return new PartitionSortPartitionerWithRows(config);
            }
            case PARTITION_PATH_REPARTITION: {
                return new PartitionPathRepartitionPartitionerWithRows(isTablePartitioned, config);
            }
            case PARTITION_PATH_REPARTITION_AND_SORT: {
                return new PartitionPathRepartitionAndSortPartitionerWithRows(isTablePartitioned, config);
            }
        }
        throw new UnsupportedOperationException("The bulk insert sort mode \"" + sortMode.name() + "\" is not supported.");
    }
}

