/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.expression.BoundReference;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Types;

public class BindVisitor
implements ExpressionVisitor<Expression> {
    protected final Types.RecordType recordType;
    protected final boolean caseSensitive;

    public BindVisitor(Types.RecordType recordType, boolean caseSensitive) {
        this.recordType = recordType;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public Expression alwaysTrue() {
        return Predicates.TrueExpression.get();
    }

    @Override
    public Expression alwaysFalse() {
        return Predicates.FalseExpression.get();
    }

    @Override
    public Expression visitAnd(Predicates.And and) {
        if (and.getLeft() instanceof Predicates.FalseExpression || and.getRight() instanceof Predicates.FalseExpression) {
            return this.alwaysFalse();
        }
        Expression left = and.getLeft().accept(this);
        Expression right = and.getRight().accept(this);
        if (left instanceof Predicates.FalseExpression || right instanceof Predicates.FalseExpression) {
            return this.alwaysFalse();
        }
        if (left instanceof Predicates.TrueExpression && right instanceof Predicates.TrueExpression) {
            return this.alwaysTrue();
        }
        if (left instanceof Predicates.TrueExpression) {
            return right;
        }
        if (right instanceof Predicates.TrueExpression) {
            return left;
        }
        return Predicates.and(left, right);
    }

    @Override
    public Expression visitOr(Predicates.Or or) {
        if (or.getLeft() instanceof Predicates.TrueExpression || or.getRight() instanceof Predicates.TrueExpression) {
            return this.alwaysTrue();
        }
        Expression left = or.getLeft().accept(this);
        Expression right = or.getRight().accept(this);
        if (left instanceof Predicates.TrueExpression || right instanceof Predicates.TrueExpression) {
            return this.alwaysTrue();
        }
        if (left instanceof Predicates.FalseExpression && right instanceof Predicates.FalseExpression) {
            return this.alwaysFalse();
        }
        if (left instanceof Predicates.FalseExpression) {
            return right;
        }
        if (right instanceof Predicates.FalseExpression) {
            return left;
        }
        return Predicates.or(left, right);
    }

    @Override
    public Expression visitLiteral(Literal literal) {
        return literal;
    }

    @Override
    public Expression visitNameReference(NameReference attribute) {
        Types.Field field;
        Types.Field field2 = field = this.caseSensitive ? this.recordType.fieldByName(attribute.getName()) : this.recordType.fieldByNameCaseInsensitive(attribute.getName());
        if (field == null) {
            throw new IllegalArgumentException("The attribute " + attribute + " cannot be bound from schema " + this.recordType);
        }
        return new BoundReference(field.fieldId(), field.type());
    }

    @Override
    public Expression visitBoundReference(BoundReference boundReference) {
        return boundReference;
    }

    @Override
    public Expression visitPredicate(Predicate predicate) {
        if (predicate instanceof Predicates.Not) {
            Expression expr = ((Predicates.Not)predicate).child.accept(this);
            if (expr instanceof Predicates.TrueExpression) {
                return this.alwaysFalse();
            }
            if (expr instanceof Predicates.FalseExpression) {
                return this.alwaysTrue();
            }
            return Predicates.not(expr);
        }
        if (predicate instanceof Predicates.BinaryComparison) {
            Predicates.BinaryComparison binaryExp = (Predicates.BinaryComparison)predicate;
            Expression left = binaryExp.getLeft().accept(this);
            Expression right = binaryExp.getRight().accept(this);
            return new Predicates.BinaryComparison(left, binaryExp.getOperator(), right);
        }
        if (predicate instanceof Predicates.In) {
            Predicates.In in = (Predicates.In)predicate;
            Expression valueExpression = in.value.accept(this);
            List<Expression> validValues = in.validValues.stream().map(validValue -> validValue.accept(this)).collect(Collectors.toList());
            return Predicates.in(valueExpression, validValues);
        }
        if (predicate instanceof Predicates.IsNull) {
            Predicates.IsNull isNull = (Predicates.IsNull)predicate;
            return Predicates.isNull(isNull.child.accept(this));
        }
        if (predicate instanceof Predicates.IsNotNull) {
            Predicates.IsNotNull isNotNull = (Predicates.IsNotNull)predicate;
            return Predicates.isNotNull(isNotNull.child.accept(this));
        }
        if (predicate instanceof Predicates.StringStartsWith) {
            Predicates.StringStartsWith contains = (Predicates.StringStartsWith)predicate;
            Expression left = contains.getLeft().accept(this);
            Expression right = contains.getRight().accept(this);
            return Predicates.startsWith(left, right);
        }
        if (predicate instanceof Predicates.StringContains) {
            Predicates.StringContains contains = (Predicates.StringContains)predicate;
            Expression left = contains.getLeft().accept(this);
            Expression right = contains.getRight().accept(this);
            return Predicates.contains(left, right);
        }
        throw new IllegalArgumentException("The expression " + this + "cannot be visited as predicate");
    }
}

