/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import com.uber.hoodie.hadoop.HoodieInputFormat;
import com.uber.hoodie.hadoop.realtime.HoodieRealtimeInputFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.FileStatusWithBootstrapBaseFile;
import org.apache.hudi.hadoop.HoodieHFileInputFormat;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.LocatedFileStatusWithBootstrapBaseFile;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.realtime.HoodieHFileRealtimeInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimePath;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieInputFormatUtils {
    public static final int HOODIE_COMMIT_TIME_COL_POS = 0;
    public static final int HOODIE_RECORD_KEY_COL_POS = 2;
    public static final int HOODIE_PARTITION_PATH_COL_POS = 3;
    public static final String HOODIE_READ_COLUMNS_PROP = "hoodie.read.columns.set";
    private static final Logger LOG = LoggerFactory.getLogger(HoodieInputFormatUtils.class);

    public static FileInputFormat getInputFormat(HoodieFileFormat baseFileFormat, boolean realtime, Configuration conf) {
        switch (baseFileFormat) {
            case PARQUET: {
                if (realtime) {
                    HoodieParquetRealtimeInputFormat inputFormat = new HoodieParquetRealtimeInputFormat();
                    inputFormat.setConf(conf);
                    return inputFormat;
                }
                HoodieParquetInputFormat inputFormat = new HoodieParquetInputFormat();
                inputFormat.setConf(conf);
                return inputFormat;
            }
            case HFILE: {
                if (realtime) {
                    HoodieHFileRealtimeInputFormat inputFormat = new HoodieHFileRealtimeInputFormat();
                    inputFormat.setConf(conf);
                    return inputFormat;
                }
                HoodieHFileInputFormat inputFormat = new HoodieHFileInputFormat();
                inputFormat.setConf(conf);
                return inputFormat;
            }
        }
        throw new HoodieIOException("Hoodie InputFormat not implemented for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getInputFormatClassName(HoodieFileFormat baseFileFormat, boolean realtime, boolean usePreApacheFormat) {
        if (baseFileFormat.equals((Object)HoodieFileFormat.PARQUET) && usePreApacheFormat) {
            return realtime ? HoodieRealtimeInputFormat.class.getName() : HoodieInputFormat.class.getName();
        }
        return HoodieInputFormatUtils.getInputFormatClassName(baseFileFormat, realtime);
    }

    public static String getInputFormatClassName(HoodieFileFormat baseFileFormat, boolean realtime) {
        switch (baseFileFormat) {
            case PARQUET: {
                if (realtime) {
                    return HoodieParquetRealtimeInputFormat.class.getName();
                }
                return HoodieParquetInputFormat.class.getName();
            }
            case HFILE: {
                if (realtime) {
                    return HoodieHFileRealtimeInputFormat.class.getName();
                }
                return HoodieHFileInputFormat.class.getName();
            }
            case ORC: {
                return OrcInputFormat.class.getName();
            }
        }
        throw new HoodieIOException("Hoodie InputFormat not implemented for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getOutputFormatClassName(HoodieFileFormat baseFileFormat) {
        switch (baseFileFormat) {
            case PARQUET: 
            case HFILE: {
                return MapredParquetOutputFormat.class.getName();
            }
            case ORC: {
                return OrcOutputFormat.class.getName();
            }
        }
        throw new HoodieIOException("No OutputFormat for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getSerDeClassName(HoodieFileFormat baseFileFormat) {
        switch (baseFileFormat) {
            case PARQUET: 
            case HFILE: {
                return ParquetHiveSerDe.class.getName();
            }
            case ORC: {
                return OrcSerde.class.getName();
            }
        }
        throw new HoodieIOException("No SerDe for base file format " + (Object)((Object)baseFileFormat));
    }

    public static FileInputFormat getInputFormat(String path, boolean realtime, Configuration conf) {
        String extension = FSUtils.getFileExtension(path);
        if (extension.equals(HoodieFileFormat.PARQUET.getFileExtension())) {
            return HoodieInputFormatUtils.getInputFormat(HoodieFileFormat.PARQUET, realtime, conf);
        }
        if (extension.equals(HoodieFileFormat.HFILE.getFileExtension())) {
            return HoodieInputFormatUtils.getInputFormat(HoodieFileFormat.HFILE, realtime, conf);
        }
        if (HadoopFSUtils.isLogFile(new Path(path)) && realtime) {
            return HoodieInputFormatUtils.getInputFormat(HoodieFileFormat.PARQUET, realtime, conf);
        }
        throw new HoodieIOException("Hoodie InputFormat not implemented for base file of type " + extension);
    }

    public static HoodieTimeline filterInstantsTimeline(HoodieTimeline timeline) {
        HoodieTimeline commitsAndCompactionTimeline = timeline.getWriteTimeline();
        Option<HoodieInstant> pendingCompactionInstant = commitsAndCompactionTimeline.filterPendingCompactionTimeline().firstInstant();
        if (pendingCompactionInstant.isPresent()) {
            HoodieTimeline instantsTimeline = commitsAndCompactionTimeline.findInstantsBefore(pendingCompactionInstant.get().requestedTime());
            int numCommitsFilteredByCompaction = commitsAndCompactionTimeline.getCommitsTimeline().countInstants() - instantsTimeline.getCommitsTimeline().countInstants();
            LOG.info("Earliest pending compaction instant is: " + pendingCompactionInstant.get().requestedTime() + " skipping " + numCommitsFilteredByCompaction + " commits");
            return instantsTimeline;
        }
        return timeline;
    }

    public static Option<String> getAffectedPartitions(List<HoodieInstant> commitsToCheck, HoodieTableMetaClient tableMetaClient, HoodieTimeline timeline, List<Path> inputPaths) throws IOException {
        HashSet<String> partitionsToList = new HashSet<String>();
        for (HoodieInstant commit : commitsToCheck) {
            HoodieCommitMetadata commitMetadata = tableMetaClient.getCommitMetadataSerDe().deserialize(commit, timeline.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
            partitionsToList.addAll(commitMetadata.getPartitionToWriteStats().keySet());
        }
        if (partitionsToList.isEmpty()) {
            return Option.empty();
        }
        String incrementalInputPaths = partitionsToList.stream().map(s -> StringUtils.isNullOrEmpty(s) ? tableMetaClient.getBasePath().toString() : tableMetaClient.getBasePath() + "/" + s).filter(s -> {
            for (Path path : inputPaths) {
                if (!path.toString().endsWith((String)s)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.joining(","));
        return StringUtils.isNullOrEmpty(incrementalInputPaths) ? Option.empty() : Option.of(incrementalInputPaths);
    }

    public static Option<HoodieTimeline> getFilteredCommitsTimeline(JobContext job, HoodieTableMetaClient tableMetaClient) {
        String tableName = tableMetaClient.getTableConfig().getTableName();
        HoodieTimeline baseTimeline = HoodieHiveUtils.stopAtCompaction(job, tableName) ? HoodieInputFormatUtils.filterInstantsTimeline(tableMetaClient.getActiveTimeline()) : tableMetaClient.getActiveTimeline();
        TimelineUtils.HollowCommitHandling handlingMode = TimelineUtils.HollowCommitHandling.valueOf(job.getConfiguration().get(HoodieCommonConfig.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT.key(), HoodieCommonConfig.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT.defaultValue()));
        HoodieTimeline filteredTimeline = TimelineUtils.handleHollowCommitIfNeeded(baseTimeline.getCommitsTimeline().filterCompletedInstants(), tableMetaClient, handlingMode);
        return Option.of(filteredTimeline);
    }

    public static Option<List<HoodieInstant>> getCommitsForIncrementalQuery(Job job, String tableName, HoodieTimeline timeline) {
        return Option.of(HoodieInputFormatUtils.getHoodieTimelineForIncrementalQuery((JobContext)job, tableName, timeline).getInstants());
    }

    public static HoodieTimeline getHoodieTimelineForIncrementalQuery(JobContext job, String tableName, HoodieTimeline timeline) {
        String lastIncrementalTs = HoodieHiveUtils.readStartCommitTime(job, tableName);
        Integer maxCommits = HoodieHiveUtils.readMaxCommits(job, tableName);
        LOG.info("Last Incremental timestamp was set as " + lastIncrementalTs);
        return timeline.findInstantsAfter(lastIncrementalTs, maxCommits);
    }

    public static Map<Path, HoodieTableMetaClient> getTableMetaClientByPartitionPath(Configuration conf, Set<Path> partitions) {
        HashMap metaClientMap = new HashMap();
        return partitions.stream().collect(Collectors.toMap(Function.identity(), p -> {
            try {
                HoodieTableMetaClient metaClient = HoodieInputFormatUtils.getTableMetaClientForBasePathUnchecked(conf, p);
                metaClientMap.put(p, metaClient);
                return metaClient;
            }
            catch (IOException e) {
                throw new HoodieIOException("Error creating hoodie meta client against : " + p, e);
            }
        }));
    }

    public static HoodieTableMetaClient getTableMetaClientForBasePathUnchecked(Configuration conf, Path partitionPath) throws IOException {
        StoragePath partitionStoragePath;
        Path baseDir = partitionPath;
        HoodieStorage storage = HoodieStorageUtils.getStorage(partitionPath.toString(), HadoopFSUtils.getStorageConf(conf));
        if (HoodiePartitionMetadata.hasPartitionMetadata(storage, partitionStoragePath = HadoopFSUtils.convertToStoragePath(partitionPath))) {
            HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(storage, partitionStoragePath);
            metadata.readFromFS();
            int levels = metadata.getPartitionDepth();
            baseDir = HoodieHiveUtils.getNthParent(partitionPath, levels);
        } else {
            for (int i = 0; i < partitionPath.depth() && !storage.exists(new StoragePath(HadoopFSUtils.convertToStoragePath(baseDir), ".hoodie")); ++i) {
                if (i == partitionPath.depth() - 1) {
                    throw new TableNotFoundException(partitionPath.toString());
                }
                baseDir = baseDir.getParent();
            }
        }
        LOG.info("Reading hoodie metadata from path " + baseDir.toString());
        return HoodieTableMetaClient.builder().setConf(storage.getConf().newInstance()).setBasePath(baseDir.toString()).build();
    }

    public static FileStatus getFileStatus(HoodieBaseFile baseFile) throws IOException {
        FileStatus fileStatus = HadoopFSUtils.convertToHadoopFileStatus(baseFile.getPathInfo());
        if (baseFile.getBootstrapBaseFile().isPresent()) {
            if (fileStatus instanceof LocatedFileStatus) {
                return new LocatedFileStatusWithBootstrapBaseFile((LocatedFileStatus)fileStatus, HadoopFSUtils.convertToHadoopFileStatus(baseFile.getBootstrapBaseFile().get().getPathInfo()));
            }
            return new FileStatusWithBootstrapBaseFile(fileStatus, HadoopFSUtils.convertToHadoopFileStatus(baseFile.getBootstrapBaseFile().get().getPathInfo()));
        }
        return fileStatus;
    }

    public static List<FileStatus> filterIncrementalFileStatus(Job job, HoodieTableMetaClient tableMetaClient, HoodieTimeline timeline, FileStatus[] fileStatuses, List<HoodieInstant> commitsToCheck) throws IOException {
        HoodieTableFileSystemView roView = new HoodieTableFileSystemView(tableMetaClient, timeline, Arrays.stream(fileStatuses).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList()));
        List<String> commitsList = commitsToCheck.stream().map(HoodieInstant::requestedTime).collect(Collectors.toList());
        List filteredFiles = roView.getLatestBaseFilesInRange(commitsList).collect(Collectors.toList());
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        for (HoodieBaseFile filteredFile : filteredFiles) {
            LOG.debug("Processing incremental hoodie file - " + filteredFile.getPath());
            filteredFile = HoodieInputFormatUtils.refreshFileStatus(job.getConfiguration(), filteredFile);
            returns.add(HoodieInputFormatUtils.getFileStatus(filteredFile));
        }
        LOG.info("Total paths to process after hoodie incremental filter " + filteredFiles.size());
        return returns;
    }

    public static Map<HoodieTableMetaClient, List<FileStatus>> groupFileStatusForSnapshotPaths(FileStatus[] fileStatuses, String fileExtension, Collection<HoodieTableMetaClient> metaClientList) {
        HashMap<HoodieTableMetaClient, List<FileStatus>> grouped = new HashMap<HoodieTableMetaClient, List<FileStatus>>();
        HoodieTableMetaClient metadata = null;
        for (FileStatus status : fileStatuses) {
            Path inputPath = status.getPath();
            if (!inputPath.getName().endsWith(fileExtension)) continue;
            if (metadata == null || !inputPath.toString().contains(metadata.getBasePath().toString())) {
                for (HoodieTableMetaClient metaClient : metaClientList) {
                    if (!inputPath.toString().contains(metaClient.getBasePath().toString())) continue;
                    metadata = metaClient;
                    if (grouped.containsKey(metadata)) break;
                    grouped.put(metadata, new ArrayList());
                    break;
                }
            }
            ((List)grouped.get(metadata)).add(status);
        }
        return grouped;
    }

    public static Map<HoodieTableMetaClient, List<Path>> groupSnapshotPathsByMetaClient(Collection<HoodieTableMetaClient> metaClientList, List<Path> snapshotPaths) {
        HashMap<HoodieTableMetaClient, List<Path>> grouped = new HashMap<HoodieTableMetaClient, List<Path>>();
        metaClientList.forEach(metaClient -> {
            List cfr_ignored_0 = grouped.put((HoodieTableMetaClient)metaClient, new ArrayList());
        });
        for (Path path : snapshotPaths) {
            metaClientList.stream().filter(metaClient -> path.toString().contains(metaClient.getBasePath().toString())).forEach(metaClient -> ((List)grouped.get(metaClient)).add(path));
        }
        return grouped;
    }

    public static HoodieMetadataConfig buildMetadataConfig(Configuration conf) {
        return HoodieMetadataConfig.newBuilder().enable(conf.getBoolean(HoodieMetadataConfig.ENABLE.key(), true)).build();
    }

    private static HoodieBaseFile refreshFileStatus(Configuration conf, HoodieBaseFile dataFile) {
        StoragePath dataPath = dataFile.getPathInfo().getPath();
        try {
            if (dataFile.getFileSize() == 0L) {
                HoodieStorage storage = HoodieStorageUtils.getStorage(dataPath, HadoopFSUtils.getStorageConf(conf));
                LOG.info("Refreshing file status " + dataFile.getPath());
                return new HoodieBaseFile(storage.getPathInfo(dataPath), (BaseFile)dataFile.getBootstrapBaseFile().orElse(null));
            }
            return dataFile;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not get FileStatus on path " + dataPath);
        }
    }

    public static List<StoragePathInfo> listAffectedFilesForCommits(Configuration hadoopConf, StoragePath basePath, List<HoodieCommitMetadata> metadataList) {
        HashMap<String, StoragePathInfo> fullPathToInfoMap = new HashMap<String, StoragePathInfo>();
        HoodieHadoopStorage storage = new HoodieHadoopStorage(basePath, HadoopFSUtils.getStorageConf(hadoopConf));
        for (HoodieCommitMetadata metadata : metadataList) {
            fullPathToInfoMap.putAll(metadata.getFullPathToInfo(storage, basePath.toString()));
        }
        return new ArrayList<StoragePathInfo>(fullPathToInfoMap.values());
    }

    public static HoodieRealtimeFileSplit createRealtimeFileSplit(HoodieRealtimePath path, long start2, long length, String[] hosts) {
        try {
            return new HoodieRealtimeFileSplit(new FileSplit((Path)path, start2, length, hosts), path);
        }
        catch (IOException e) {
            throw new HoodieIOException(String.format("Failed to create instance of %s", HoodieRealtimeFileSplit.class.getName()), e);
        }
    }

    public static List<String> getPartitionFieldNames(JobConf jobConf) {
        String partitionFields = jobConf.get("partition_columns", "");
        return partitionFields.isEmpty() ? new ArrayList<String>() : Arrays.stream(partitionFields.split("/")).collect(Collectors.toList());
    }

    public static String getTableBasePath(InputSplit split, JobConf jobConf) throws IOException {
        if (split instanceof RealtimeSplit) {
            RealtimeSplit realtimeSplit = (RealtimeSplit)split;
            return realtimeSplit.getBasePath();
        }
        Path inputPath = ((FileSplit)split).getPath();
        FileSystem fs = inputPath.getFileSystem((Configuration)jobConf);
        HoodieHadoopStorage storage = new HoodieHadoopStorage(fs);
        Option<StoragePath> tablePath = TablePathUtils.getTablePath(storage, HadoopFSUtils.convertToStoragePath(inputPath));
        return tablePath.get().toString();
    }

    public static boolean shouldUseFilegroupReader(JobConf jobConf, InputSplit split) {
        return jobConf.getBoolean(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), HoodieReaderConfig.FILE_GROUP_READER_ENABLED.defaultValue().booleanValue()) && !jobConf.getBoolean(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key(), HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.defaultValue().booleanValue()) && !(split instanceof BootstrapBaseFileSplit);
    }
}

