/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import org.apache.hudi.expression.BoundReference;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Types;

public class FilterGenVisitor
implements ExpressionVisitor<String> {
    private String makeBinaryOperatorString(String left, Expression.Operator operator, String right) {
        return String.format("%s %s %s", left, operator.sqlOperator, right);
    }

    protected String quoteStringLiteral(String value) {
        if (!value.contains("\"")) {
            return "\"" + value + "\"";
        }
        if (!value.contains("'")) {
            return "'" + value + "'";
        }
        throw new UnsupportedOperationException("Cannot pushdown filters if \" and ' both exist");
    }

    @Override
    public String visitAnd(Predicates.And and) {
        String leftResult = and.getLeft().accept(this);
        String rightResult = and.getRight().accept(this);
        if (leftResult.isEmpty()) {
            if (rightResult.isEmpty()) {
                return "";
            }
            return rightResult;
        }
        if (rightResult.isEmpty()) {
            return leftResult;
        }
        return "(" + this.makeBinaryOperatorString(leftResult, Expression.Operator.AND, rightResult) + ")";
    }

    @Override
    public String visitOr(Predicates.Or or) {
        String leftResult = or.getLeft().accept(this);
        String rightResult = or.getRight().accept(this);
        if (!leftResult.isEmpty() && !rightResult.isEmpty()) {
            return "(" + this.makeBinaryOperatorString(leftResult, Expression.Operator.OR, rightResult) + ")";
        }
        return "";
    }

    private String visitBinaryComparator(Expression left, Expression.Operator operator, Expression right) {
        String leftResult = left.accept(this);
        String rightResult = right.accept(this);
        if (!leftResult.isEmpty() && !rightResult.isEmpty()) {
            return this.makeBinaryOperatorString(leftResult, operator, rightResult);
        }
        return "";
    }

    @Override
    public String visitPredicate(Predicate predicate) {
        if (predicate instanceof Predicates.BinaryComparison) {
            Predicates.BinaryComparison expr = (Predicates.BinaryComparison)predicate;
            return this.visitBinaryComparator(expr.getLeft(), expr.getOperator(), expr.getRight());
        }
        return "";
    }

    @Override
    public String alwaysTrue() {
        return "";
    }

    @Override
    public String alwaysFalse() {
        return "";
    }

    @Override
    public String visitLiteral(Literal literalExpr) {
        if (literalExpr.getDataType() instanceof Types.StringType) {
            return this.quoteStringLiteral((String)literalExpr.getValue());
        }
        if (literalExpr.getDataType() instanceof Types.IntType || literalExpr.getDataType() instanceof Types.LongType || literalExpr.getDataType() instanceof Types.DateType) {
            return literalExpr.getValue().toString();
        }
        return "";
    }

    @Override
    public String visitNameReference(NameReference attribute) {
        return attribute.getName();
    }

    @Override
    public String visitBoundReference(BoundReference boundReference) {
        throw new UnsupportedOperationException("BoundReference cannot be used to build filter string");
    }
}

