/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.Arrays;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.action.TableChangesHelper;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class InternalSchemaChangeApplier {
    private InternalSchema latestSchema;

    public InternalSchemaChangeApplier(InternalSchema latestSchema) {
        this.latestSchema = latestSchema;
    }

    public InternalSchema applyAddChange(String colName, Type colType, String doc, String position, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        TableChanges.ColumnAddChange add;
        block8: {
            block7: {
                add = TableChanges.ColumnAddChange.get(this.latestSchema);
                String parentName = TableChangesHelper.getParentName(colName);
                String leafName = TableChangesHelper.getLeafName(colName);
                add.addColumns(parentName, leafName, colType, doc);
                if (positionType == null) break block7;
                switch (positionType) {
                    case NO_OPERATION: {
                        break block8;
                    }
                    case FIRST: {
                        add.addPositionChange(colName, "", positionType);
                        break block8;
                    }
                    case AFTER: 
                    case BEFORE: {
                        if (position == null || position.isEmpty()) {
                            throw new IllegalArgumentException("position should not be null/empty_string when specify positionChangeType as after/before");
                        }
                        String referParentName = TableChangesHelper.getParentName(position);
                        if (!parentName.equals(referParentName)) {
                            throw new IllegalArgumentException("cannot reorder two columns which has different parent");
                        }
                        add.addPositionChange(colName, position, positionType);
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("only support first/before/after but found: %s", new Object[]{positionType}));
                    }
                }
            }
            throw new IllegalArgumentException(String.format("positionType should be specified", new Object[0]));
        }
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, add);
    }

    public InternalSchema applyDeleteChange(String ... colNames) {
        TableChanges.ColumnDeleteChange delete = TableChanges.ColumnDeleteChange.get(this.latestSchema);
        Arrays.stream(colNames).forEach(colName -> delete.deleteColumn((String)colName));
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, delete);
    }

    public InternalSchema applyRenameChange(String colName, String newName) {
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(this.latestSchema);
        updateChange.renameColumn(colName, newName);
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, updateChange);
    }

    public InternalSchema applyColumnNullabilityChange(String colName, boolean nullable) {
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(this.latestSchema);
        updateChange.updateColumnNullability(colName, nullable);
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, updateChange);
    }

    public InternalSchema applyColumnTypeChange(String colName, Type newType) {
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(this.latestSchema);
        updateChange.updateColumnType(colName, newType);
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, updateChange);
    }

    public InternalSchema applyColumnCommentChange(String colName, String doc) {
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(this.latestSchema);
        updateChange.updateColumnComment(colName, doc);
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, updateChange);
    }

    public InternalSchema applyReOrderColPositionChange(String colName, String referColName, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(this.latestSchema);
        String parentName = TableChangesHelper.getParentName(colName);
        String referParentName = TableChangesHelper.getParentName(referColName);
        if (positionType.equals((Object)TableChange.ColumnPositionChange.ColumnPositionType.FIRST)) {
            updateChange.addPositionChange(colName, "", positionType);
        } else if (parentName.equals(referParentName)) {
            updateChange.addPositionChange(colName, referColName, positionType);
        } else {
            throw new IllegalArgumentException("cannot reorder two columns which has different parent");
        }
        return SchemaChangeUtils.applyTableChanges2Schema(this.latestSchema, updateChange);
    }
}

