/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.HFileUtils;
import org.apache.hudi.common.util.OrcUtils;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.hadoop.HoodieAvroFileReaderFactory;
import org.apache.hudi.io.hadoop.HoodieAvroFileWriterFactory;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;

public class HoodieHadoopIOFactory
extends HoodieIOFactory {
    public HoodieHadoopIOFactory(HoodieStorage storage) {
        super(storage);
    }

    @Override
    public HoodieFileReaderFactory getReaderFactory(HoodieRecord.HoodieRecordType recordType) {
        switch (recordType) {
            case AVRO: {
                return new HoodieAvroFileReaderFactory(this.storage);
            }
            case SPARK: {
                try {
                    return (HoodieFileReaderFactory)ReflectionUtils.loadClass("org.apache.hudi.io.storage.HoodieSparkFileReaderFactory", new Class[]{HoodieStorage.class}, new Object[]{this.storage});
                }
                catch (Exception e) {
                    throw new HoodieException("Unable to create HoodieSparkFileReaderFactory", e);
                }
            }
        }
        throw new UnsupportedOperationException((Object)((Object)recordType) + " record type not supported");
    }

    @Override
    public HoodieFileWriterFactory getWriterFactory(HoodieRecord.HoodieRecordType recordType) {
        switch (recordType) {
            case AVRO: {
                return new HoodieAvroFileWriterFactory(this.storage);
            }
            case SPARK: {
                try {
                    return (HoodieFileWriterFactory)ReflectionUtils.loadClass("org.apache.hudi.io.storage.HoodieSparkFileWriterFactory", new Class[]{HoodieStorage.class}, new Object[]{this.storage});
                }
                catch (Exception e) {
                    throw new HoodieException("Unable to create HoodieSparkFileWriterFactory", e);
                }
            }
        }
        throw new UnsupportedOperationException((Object)((Object)recordType) + " record type not supported");
    }

    @Override
    public FileFormatUtils getFileFormatUtils(HoodieFileFormat fileFormat) {
        switch (fileFormat) {
            case PARQUET: {
                return new ParquetUtils();
            }
            case ORC: {
                return new OrcUtils();
            }
            case HFILE: {
                return new HFileUtils();
            }
        }
        throw new UnsupportedOperationException(fileFormat.name() + " format not supported yet.");
    }

    @Override
    public HoodieStorage getStorage(StoragePath storagePath) {
        return this.storage.newInstance(storagePath, this.storage.getConf());
    }

    @Override
    public HoodieStorage getStorage(StoragePath path, boolean enableRetry, long maxRetryIntervalMs, int maxRetryNumbers, long initialRetryIntervalMs, String retryExceptions, ConsistencyGuard consistencyGuard) {
        return new HoodieHadoopStorage(path, this.storage.getConf(), enableRetry, maxRetryIntervalMs, maxRetryNumbers, maxRetryIntervalMs, retryExceptions, consistencyGuard);
    }
}

