/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockPriority;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.FirstLevelBlockCache;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class TinyLfuBlockCache
implements FirstLevelBlockCache {
    private static final Logger LOG = LoggerFactory.getLogger(TinyLfuBlockCache.class);
    private static final String MAX_BLOCK_SIZE = "hbase.tinylfu.max.block.size";
    private static final long DEFAULT_MAX_BLOCK_SIZE = 0x1000000L;
    private static final int STAT_THREAD_PERIOD_SECONDS = 300;
    private final transient Policy.Eviction<BlockCacheKey, Cacheable> policy;
    private final transient ScheduledExecutorService statsThreadPool;
    private final long maxBlockSize;
    private final CacheStats stats;
    private transient BlockCache victimCache;
    final transient Cache<BlockCacheKey, Cacheable> cache;

    public TinyLfuBlockCache(long maximumSizeInBytes, long avgBlockSize, Executor executor, Configuration conf) {
        this(maximumSizeInBytes, avgBlockSize, conf.getLong(MAX_BLOCK_SIZE, 0x1000000L), executor);
    }

    public TinyLfuBlockCache(long maximumSizeInBytes, long avgBlockSize, long maxBlockSize, Executor executor) {
        this.cache = Caffeine.newBuilder().executor(executor).maximumWeight(maximumSizeInBytes).removalListener(new EvictionListener()).weigher((key, value) -> (int)Math.min(value.heapSize(), Integer.MAX_VALUE)).initialCapacity((int)Math.ceil(1.2 * (double)maximumSizeInBytes / (double)avgBlockSize)).build();
        this.maxBlockSize = maxBlockSize;
        this.policy = this.cache.policy().eviction().get();
        this.stats = new CacheStats(this.getClass().getSimpleName());
        this.statsThreadPool = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TinyLfuBlockCacheStatsExecutor").setDaemon(true).build());
        this.statsThreadPool.scheduleAtFixedRate(this::logStats, 300L, 300L, TimeUnit.SECONDS);
    }

    @Override
    public void setVictimCache(BlockCache victimCache) {
        if (this.victimCache != null) {
            throw new IllegalArgumentException("The victim cache has already been set");
        }
        this.victimCache = Objects.requireNonNull(victimCache);
    }

    @Override
    public long size() {
        return this.policy.getMaximum();
    }

    @Override
    public long getFreeSize() {
        return this.size() - this.getCurrentSize();
    }

    @Override
    public long getCurrentSize() {
        return this.policy.weightedSize().getAsLong();
    }

    @Override
    public long getBlockCount() {
        return this.cache.estimatedSize();
    }

    @Override
    public long heapSize() {
        return this.getCurrentSize();
    }

    @Override
    public void setMaxSize(long size) {
        this.policy.setMaximum(size);
    }

    @Override
    public boolean containsBlock(BlockCacheKey cacheKey) {
        return this.cache.asMap().containsKey(cacheKey);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        Cacheable value = this.cache.asMap().computeIfPresent(cacheKey, (blockCacheKey, cacheable) -> {
            cacheable.retain();
            return cacheable;
        });
        if (value == null) {
            if (repeat) {
                return null;
            }
            if (updateCacheMetrics) {
                this.stats.miss(caching, cacheKey.isPrimary(), cacheKey.getBlockType());
            }
            if (this.victimCache != null && (value = this.victimCache.getBlock(cacheKey, caching, repeat, updateCacheMetrics)) != null && caching) {
                this.cacheBlock(cacheKey, value);
            }
        } else if (updateCacheMetrics) {
            this.stats.hit(caching, cacheKey.isPrimary(), cacheKey.getBlockType());
        }
        return value;
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable value, boolean inMemory) {
        this.cacheBlock(cacheKey, value);
    }

    @Override
    public void cacheBlock(BlockCacheKey key, Cacheable value) {
        if (value.heapSize() > this.maxBlockSize) {
            if (this.stats.failInsert() % 50L == 0L) {
                LOG.warn(String.format("Trying to cache too large a block %s @ %,d is %,d which is larger than %,d", key.getHfileName(), key.getOffset(), value.heapSize(), 0x1000000L));
            }
        } else {
            value = this.asReferencedHeapBlock(value);
            this.cache.put(key, value);
        }
    }

    private Cacheable asReferencedHeapBlock(Cacheable buf) {
        HFileBlock blk;
        if (buf instanceof HFileBlock && (blk = (HFileBlock)buf).isSharedMem()) {
            return HFileBlock.deepCloneOnHeap(blk);
        }
        return buf.retain();
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        Cacheable value = (Cacheable)this.cache.asMap().remove(cacheKey);
        if (value != null) {
            value.release();
        }
        return value != null;
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        int evicted = 0;
        for (BlockCacheKey key : this.cache.asMap().keySet()) {
            if (!key.getHfileName().equals(hfileName) || !this.evictBlock(key)) continue;
            ++evicted;
        }
        if (this.victimCache != null) {
            evicted += this.victimCache.evictBlocksByHfileName(hfileName);
        }
        return evicted;
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public void shutdown() {
        if (this.victimCache != null) {
            this.victimCache.shutdown();
        }
        this.statsThreadPool.shutdown();
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return null;
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        long now = System.nanoTime();
        return this.cache.asMap().entrySet().stream().map(entry -> new CachedBlockView((BlockCacheKey)entry.getKey(), (Cacheable)entry.getValue(), now)).iterator();
    }

    private void logStats() {
        LOG.info("totalSize=" + StringUtils.byteDesc((long)this.heapSize()) + ", freeSize=" + StringUtils.byteDesc((long)this.getFreeSize()) + ", max=" + StringUtils.byteDesc((long)this.size()) + ", blockCount=" + this.getBlockCount() + ", accesses=" + this.stats.getRequestCount() + ", hits=" + this.stats.getHitCount() + ", hitRatio=" + (this.stats.getHitCount() == 0L ? "0," : StringUtils.formatPercent((double)this.stats.getHitRatio(), (int)2) + ", ") + "cachingAccesses=" + this.stats.getRequestCachingCount() + ", cachingHits=" + this.stats.getHitCachingCount() + ", cachingHitsRatio=" + (this.stats.getHitCachingCount() == 0L ? "0," : StringUtils.formatPercent((double)this.stats.getHitCachingRatio(), (int)2) + ", ") + "evictions=" + this.stats.getEvictionCount() + ", evicted=" + this.stats.getEvictedCount());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("blockCount", this.getBlockCount()).add("currentSize", this.getCurrentSize()).add("freeSize", this.getFreeSize()).add("maxSize", this.size()).add("heapSize", this.heapSize()).add("victimCache", this.victimCache != null).toString();
    }

    private void recordEviction() {
        this.stats.evicted(Long.MAX_VALUE, true);
        this.stats.evict();
    }

    @Override
    public long getMaxSize() {
        return this.size();
    }

    @Override
    public long getCurrentDataSize() {
        return this.getCurrentSize();
    }

    @Override
    public long getDataBlockCount() {
        return this.getBlockCount();
    }

    private static final class CachedBlockView
    implements CachedBlock {
        private static final Comparator<CachedBlock> COMPARATOR = Comparator.comparing(CachedBlock::getFilename).thenComparing(CachedBlock::getOffset).thenComparing(CachedBlock::getCachedTime);
        private final BlockCacheKey key;
        private final Cacheable value;
        private final long now;

        public CachedBlockView(BlockCacheKey key, Cacheable value, long now) {
            this.now = now;
            this.key = key;
            this.value = value;
        }

        @Override
        public BlockPriority getBlockPriority() {
            return BlockPriority.MEMORY;
        }

        @Override
        public BlockType getBlockType() {
            return this.value.getBlockType();
        }

        @Override
        public long getOffset() {
            return this.key.getOffset();
        }

        @Override
        public long getSize() {
            return this.value.heapSize();
        }

        @Override
        public long getCachedTime() {
            return 0L;
        }

        @Override
        public String getFilename() {
            return this.key.getHfileName();
        }

        @Override
        public int compareTo(CachedBlock other) {
            return COMPARATOR.compare(this, other);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CachedBlock)) {
                return false;
            }
            CachedBlock other = (CachedBlock)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return BlockCacheUtil.toString(this, this.now);
        }
    }

    private final class EvictionListener
    implements RemovalListener<BlockCacheKey, Cacheable> {
        private EvictionListener() {
        }

        @Override
        public void onRemoval(BlockCacheKey key, Cacheable value, RemovalCause cause) {
            if (!cause.wasEvicted()) {
                return;
            }
            TinyLfuBlockCache.this.recordEviction();
            if (TinyLfuBlockCache.this.victimCache == null) {
                return;
            }
            if (TinyLfuBlockCache.this.victimCache instanceof BucketCache) {
                BucketCache victimBucketCache = (BucketCache)TinyLfuBlockCache.this.victimCache;
                victimBucketCache.cacheBlockWithWait(key, value, true, true);
            } else {
                TinyLfuBlockCache.this.victimCache.cacheBlock(key, value);
            }
        }
    }
}

