/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.ChoreService;
import org.apache.hudi.org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionsRecoveryChore;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionsRecoveryConfigManager
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RegionsRecoveryConfigManager.class);
    private final HMaster hMaster;
    private RegionsRecoveryChore chore;
    private int prevMaxStoreFileRefCount;
    private int prevRegionsRecoveryInterval;

    RegionsRecoveryConfigManager(HMaster hMaster) {
        this.hMaster = hMaster;
        Configuration conf = hMaster.getConfiguration();
        this.prevMaxStoreFileRefCount = this.getMaxStoreFileRefCount(conf);
        this.prevRegionsRecoveryInterval = this.getRegionsRecoveryChoreInterval(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigurationChange(Configuration conf) {
        int newMaxStoreFileRefCount = this.getMaxStoreFileRefCount(conf);
        int newRegionsRecoveryInterval = this.getRegionsRecoveryChoreInterval(conf);
        if (this.prevMaxStoreFileRefCount == newMaxStoreFileRefCount && this.prevRegionsRecoveryInterval == newRegionsRecoveryInterval) {
            return;
        }
        LOG.info("Config Reload for RegionsRecovery Chore. prevMaxStoreFileRefCount: {}, newMaxStoreFileRefCount: {}, prevRegionsRecoveryInterval: {}, newRegionsRecoveryInterval: {}", new Object[]{this.prevMaxStoreFileRefCount, newMaxStoreFileRefCount, this.prevRegionsRecoveryInterval, newRegionsRecoveryInterval});
        RegionsRecoveryChore regionsRecoveryChore = new RegionsRecoveryChore(this.hMaster, conf, this.hMaster);
        ChoreService choreService = this.hMaster.getChoreService();
        RegionsRecoveryConfigManager regionsRecoveryConfigManager = this;
        synchronized (regionsRecoveryConfigManager) {
            if (this.chore != null) {
                this.chore.shutdown();
                this.chore = null;
            }
            if (newMaxStoreFileRefCount > 0) {
                choreService.scheduleChore(regionsRecoveryChore);
                this.chore = regionsRecoveryChore;
            }
            this.prevMaxStoreFileRefCount = newMaxStoreFileRefCount;
            this.prevRegionsRecoveryInterval = newRegionsRecoveryInterval;
        }
    }

    private int getMaxStoreFileRefCount(Configuration configuration) {
        return configuration.getInt("hbase.regions.recovery.store.file.ref.count", -1);
    }

    private int getRegionsRecoveryChoreInterval(Configuration configuration) {
        return configuration.getInt("hbase.master.regions.recovery.check.interval", 1200000);
    }

    @RestrictedApi(explanation="Only visible for testing", link="", allowedOnPath=".*/src/test/.*")
    RegionsRecoveryChore getChore() {
        return this.chore;
    }
}

