/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufMessageConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.JRubyFormat;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureDescriber {
    private ProcedureDescriber() {
    }

    private static Object parametersToObject(Procedure<?> proc) {
        try {
            ProcedureProtos.Procedure protoProc = ProcedureUtil.convertToProtoProcedure(proc);
            List parameters = protoProc.getStateMessageList().stream().map(any -> {
                try {
                    return ProtobufMessageConverter.toJavaObject(any);
                }
                catch (InvalidProtocolBufferException e) {
                    return e.toString();
                }
            }).collect(Collectors.toList());
            return parameters;
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public static String describe(Procedure<?> proc) {
        LinkedHashMap<String, Object> description = new LinkedHashMap<String, Object>();
        description.put("ID", proc.getProcId());
        description.put("PARENT_ID", proc.getParentProcId());
        description.put("STATE", proc.getState());
        description.put("OWNER", proc.getOwner());
        description.put("TYPE", proc.getProcName());
        description.put("START_TIME", new Date(proc.getSubmittedTime()));
        description.put("LAST_UPDATE", new Date(proc.getLastUpdate()));
        if (proc.isFailed()) {
            description.put("ERRORS", MasterProcedureUtil.unwrapRemoteIOException(proc).getMessage());
        }
        description.put("PARAMETERS", ProcedureDescriber.parametersToObject(proc));
        return JRubyFormat.print(description);
    }

    public static String describeParameters(Procedure<?> proc) {
        Object object = ProcedureDescriber.parametersToObject(proc);
        return JRubyFormat.print(object);
    }
}

