/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.metrics;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.impl.GlobalMetricRegistriesAdapter;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.impl.HBaseMetrics2HadoopMetricsAdapter;
import org.apache.hudi.org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BaseSourceImpl
implements BaseSource,
MetricsSource {
    @Deprecated
    protected final DynamicMetricsRegistry metricsRegistry;
    protected final String metricsName;
    protected final String metricsDescription;
    protected final String metricsContext;
    protected final String metricsJmxContext;
    protected final MetricRegistry registry;
    protected final HBaseMetrics2HadoopMetricsAdapter metricsAdapter;

    public BaseSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        this.metricsName = metricsName;
        this.metricsDescription = metricsDescription;
        this.metricsContext = metricsContext;
        this.metricsJmxContext = metricsJmxContext;
        this.metricsRegistry = new DynamicMetricsRegistry(metricsName).setContext(metricsContext);
        DefaultMetricsSystemInitializer.INSTANCE.init(metricsName);
        DefaultMetricsSystem.instance().register(metricsJmxContext, metricsDescription, (Object)this);
        this.registry = MetricRegistries.global().create(this.getMetricRegistryInfo());
        this.metricsAdapter = new HBaseMetrics2HadoopMetricsAdapter();
        this.init();
    }

    @Override
    public void init() {
        this.metricsRegistry.clearMetrics();
    }

    @Override
    public void setGauge(String gaugeName, long value) {
        MutableGaugeLong gaugeInt = this.metricsRegistry.getGauge(gaugeName, value);
        gaugeInt.set(value);
    }

    @Override
    public void incGauge(String gaugeName, long delta) {
        MutableGaugeLong gaugeInt = this.metricsRegistry.getGauge(gaugeName, 0L);
        gaugeInt.incr(delta);
    }

    @Override
    public void decGauge(String gaugeName, long delta) {
        MutableGaugeLong gaugeInt = this.metricsRegistry.getGauge(gaugeName, 0L);
        gaugeInt.decr(delta);
    }

    @Override
    public void incCounters(String key, long delta) {
        MutableFastCounter counter = this.metricsRegistry.getCounter(key, 0L);
        counter.incr(delta);
    }

    @Override
    public void updateHistogram(String name, long value) {
        MutableHistogram histo = this.metricsRegistry.getHistogram(name);
        histo.add(value);
    }

    @Override
    public void removeMetric(String key) {
        this.metricsRegistry.removeMetric(key);
        JmxCacheBuster.clearJmxCache();
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        this.metricsRegistry.snapshot(metricsCollector.addRecord(this.metricsRegistry.info()), all);
    }

    public DynamicMetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @Override
    public String getMetricsContext() {
        return this.metricsContext;
    }

    @Override
    public String getMetricsDescription() {
        return this.metricsDescription;
    }

    @Override
    public String getMetricsJmxContext() {
        return this.metricsJmxContext;
    }

    @Override
    public String getMetricsName() {
        return this.metricsName;
    }

    private static enum DefaultMetricsSystemInitializer {
        INSTANCE;

        private boolean inited = false;

        synchronized void init(String name) {
            if (this.inited) {
                return;
            }
            this.inited = true;
            DefaultMetricsSystem.initialize((String)"HBase");
            JvmMetrics.initSingleton((String)name, (String)"");
            GlobalMetricRegistriesAdapter.init();
        }
    }
}

