/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.throttle;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.throttle.PressureAwareThroughputController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class PressureAwareFlushThroughputController
extends PressureAwareThroughputController {
    private static final Logger LOG = LoggerFactory.getLogger(PressureAwareFlushThroughputController.class);
    public static final String HBASE_HSTORE_FLUSH_MAX_THROUGHPUT_UPPER_BOUND = "hbase.hstore.flush.throughput.upper.bound";
    private static final long DEFAULT_HBASE_HSTORE_FLUSH_MAX_THROUGHPUT_UPPER_BOUND = 0xC800000L;
    public static final String HBASE_HSTORE_FLUSH_MAX_THROUGHPUT_LOWER_BOUND = "hbase.hstore.flush.throughput.lower.bound";
    private static final long DEFAULT_HBASE_HSTORE_FLUSH_MAX_THROUGHPUT_LOWER_BOUND = 0x6400000L;
    public static final String HBASE_HSTORE_FLUSH_THROUGHPUT_TUNE_PERIOD = "hbase.hstore.flush.throughput.tune.period";
    private static final int DEFAULT_HSTORE_FLUSH_THROUGHPUT_TUNE_PERIOD = 20000;
    public static final String HBASE_HSTORE_FLUSH_THROUGHPUT_CONTROL_CHECK_INTERVAL = "hbase.hstore.flush.throughput.control.check.interval";
    private static final long DEFAULT_HBASE_HSTORE_FLUSH_THROUGHPUT_CONTROL_CHECK_INTERVAL = 0xA00000L;

    @Override
    public void setup(final RegionServerServices server) {
        server.getChoreService().scheduleChore(new ScheduledChore("FlushThroughputTuner", this, this.tuningPeriod, this.tuningPeriod){

            @Override
            protected void chore() {
                PressureAwareFlushThroughputController.this.tune(server.getFlushPressure());
            }
        });
    }

    private void tune(double flushPressure) {
        double maxThroughputToSet = flushPressure >= 1.0 ? Double.MAX_VALUE : (double)this.maxThroughputLowerBound + (double)(this.maxThroughputUpperBound - this.maxThroughputLowerBound) * flushPressure;
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushPressure is " + flushPressure + ", tune flush throughput to " + this.throughputDesc(maxThroughputToSet));
        }
        this.setMaxThroughput(maxThroughputToSet);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.maxThroughputUpperBound = conf.getLong(HBASE_HSTORE_FLUSH_MAX_THROUGHPUT_UPPER_BOUND, 0xC800000L);
        this.maxThroughputLowerBound = conf.getLong(HBASE_HSTORE_FLUSH_MAX_THROUGHPUT_LOWER_BOUND, 0x6400000L);
        this.offPeakHours = OffPeakHours.getInstance(conf);
        this.controlPerSize = conf.getLong(HBASE_HSTORE_FLUSH_THROUGHPUT_CONTROL_CHECK_INTERVAL, 0xA00000L);
        this.setMaxThroughput(this.maxThroughputLowerBound);
        this.tuningPeriod = this.getConf().getInt(HBASE_HSTORE_FLUSH_THROUGHPUT_TUNE_PERIOD, 20000);
        LOG.info("Flush throughput configurations, upper bound: " + this.throughputDesc(this.maxThroughputUpperBound) + ", lower bound " + this.throughputDesc(this.maxThroughputLowerBound) + ", tuning period: " + this.tuningPeriod + " ms");
    }

    public String toString() {
        return "DefaultFlushController [maxThroughput=" + this.throughputDesc(this.getMaxThroughput()) + ", activeFlushNumber=" + this.activeOperations.size() + "]";
    }
}

