/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication;

import java.util.UUID;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class VerifyWALEntriesReplicationEndpoint
extends BaseReplicationEndpoint {
    @Override
    public boolean canReplicateToSameCluster() {
        return true;
    }

    @Override
    public UUID getPeerUUID() {
        return this.ctx.getClusterId();
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        return null;
    }

    private void checkCell(Cell cell) {
        CellUtil.cloneRow(cell);
        CellUtil.cloneFamily(cell);
        CellUtil.cloneQualifier(cell);
        CellUtil.cloneValue(cell);
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        replicateContext.entries.stream().map(WAL.Entry::getEdit).flatMap(e -> e.getCells().stream()).forEach(this::checkCell);
        return true;
    }

    @Override
    public void start() {
        this.startAsync();
    }

    @Override
    public void stop() {
        this.stopAsync();
    }

    @Override
    protected void doStart() {
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
    }
}

