/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hudi.org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class VisibilityReplicationEndpoint
implements ReplicationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityReplicationEndpoint.class);
    private final ReplicationEndpoint delegator;
    private final VisibilityLabelService visibilityLabelsService;

    public VisibilityReplicationEndpoint(ReplicationEndpoint endpoint, VisibilityLabelService visibilityLabelsService) {
        this.delegator = endpoint;
        this.visibilityLabelsService = visibilityLabelsService;
    }

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        this.delegator.init(context);
    }

    public void peerConfigUpdated(ReplicationPeerConfig rpc) {
        this.delegator.peerConfigUpdated(rpc);
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        if (!this.delegator.canReplicateToSameCluster()) {
            List<WAL.Entry> entries = replicateContext.getEntries();
            ArrayList<Tag> visTags = new ArrayList<Tag>();
            ArrayList<Tag> nonVisTags = new ArrayList<Tag>();
            ArrayList<WAL.Entry> newEntries = new ArrayList<WAL.Entry>(entries.size());
            for (WAL.Entry entry : entries) {
                WALEdit newEdit = new WALEdit();
                ArrayList<Cell> cells = entry.getEdit().getCells();
                for (Cell cell : cells) {
                    if (cell.getTagsLength() > 0) {
                        visTags.clear();
                        nonVisTags.clear();
                        Byte serializationFormat = VisibilityUtils.extractAndPartitionTags(cell, visTags, nonVisTags);
                        if (!visTags.isEmpty()) {
                            block7: {
                                try {
                                    byte[] modifiedVisExpression = this.visibilityLabelsService.encodeVisibilityForReplication(visTags, serializationFormat);
                                    if (modifiedVisExpression == null) break block7;
                                    nonVisTags.add(new ArrayBackedTag(7, modifiedVisExpression));
                                }
                                catch (Exception ioe) {
                                    LOG.error("Exception while reading the visibility labels from the cell. The replication would happen as per the existing format and not as string type for the cell " + cell + ".", (Throwable)ioe);
                                    newEdit.add(cell);
                                    continue;
                                }
                            }
                            Cell newCell = PrivateCellUtil.createCell(cell, nonVisTags);
                            newEdit.add(newCell);
                            continue;
                        }
                        newEdit.add(cell);
                        continue;
                    }
                    newEdit.add(cell);
                }
                newEntries.add(new WAL.Entry(entry.getKey(), newEdit));
            }
            replicateContext.setEntries(newEntries);
            return this.delegator.replicate(replicateContext);
        }
        return this.delegator.replicate(replicateContext);
    }

    @Override
    public synchronized UUID getPeerUUID() {
        return this.delegator.getPeerUUID();
    }

    @Override
    public boolean canReplicateToSameCluster() {
        return this.delegator.canReplicateToSameCluster();
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        return this.delegator.getWALEntryfilter();
    }

    @Override
    public boolean isRunning() {
        return this.delegator.isRunning();
    }

    @Override
    public boolean isStarting() {
        return this.delegator.isStarting();
    }

    @Override
    public void start() {
        this.delegator.start();
    }

    @Override
    public void awaitRunning() {
        this.delegator.awaitRunning();
    }

    @Override
    public void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        this.delegator.awaitRunning(timeout, unit);
    }

    @Override
    public void stop() {
        this.delegator.stop();
    }

    @Override
    public void awaitTerminated() {
        this.delegator.awaitTerminated();
    }

    @Override
    public void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        this.delegator.awaitTerminated(timeout, unit);
    }

    @Override
    public Throwable failureCause() {
        return this.delegator.failureCause();
    }
}

