/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.info;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.hudi.org.openjdk.jol.datamodel.DataModel;
import org.apache.hudi.org.openjdk.jol.info.ClassData;
import org.apache.hudi.org.openjdk.jol.info.FieldLayout;
import org.apache.hudi.org.openjdk.jol.layouters.CurrentLayouter;
import org.apache.hudi.org.openjdk.jol.layouters.Layouter;
import org.apache.hudi.org.openjdk.jol.util.ClassUtils;
import org.apache.hudi.org.openjdk.jol.util.ObjectUtils;
import org.apache.hudi.org.openjdk.jol.vm.VM;
import org.apache.hudi.org.openjdk.jol.vm.VirtualMachine;

public class ClassLayout {
    private final ClassData classData;
    private final SortedSet<FieldLayout> fields;
    private final DataModel model;
    private final long size;
    private final int lossesInternal;
    private final int lossesExternal;
    private final int lossesTotal;
    static final String[] ZERO_RUNS = new String[16];

    public static ClassLayout parseClass(Class<?> klass) {
        return ClassLayout.parseClass(klass, new CurrentLayouter());
    }

    public static ClassLayout parseClass(Class<?> klass, Layouter layouter) {
        return layouter.layout(ClassData.parseClass(klass));
    }

    public static ClassLayout parseInstance(Object instance) {
        return ClassLayout.parseInstance(instance, new CurrentLayouter());
    }

    public static ClassLayout parseInstance(Object instance, Layouter layouter) {
        return layouter.layout(ClassData.parseInstance(instance));
    }

    private ClassLayout(ClassData classData, SortedSet<FieldLayout> fields, DataModel model, long instanceSize, int lossesInternal, int lossesExternal, int lossesTotal) {
        this.classData = classData;
        this.fields = fields;
        this.model = model;
        this.size = instanceSize;
        this.lossesInternal = lossesInternal;
        this.lossesExternal = lossesExternal;
        this.lossesTotal = lossesTotal;
    }

    public static ClassLayout create(ClassData classData, SortedSet<FieldLayout> fields, DataModel model, long instanceSize, boolean check2) {
        if (check2) {
            ClassLayout.checkInvariants(fields, instanceSize);
        }
        long next = model.headerSize();
        long internal = 0L;
        for (FieldLayout fl : fields) {
            if (fl.offset() > next) {
                internal += fl.offset() - next;
            }
            next = fl.offset() + fl.size();
        }
        long external = instanceSize != next ? instanceSize - next : 0L;
        long total = internal + external;
        return new ClassLayout(classData, fields, model, instanceSize, (int)internal, (int)external, (int)total);
    }

    private static void checkInvariants(SortedSet<FieldLayout> fields, long instanceSize) {
        FieldLayout lastField = null;
        for (FieldLayout f : fields) {
            if (f.offset() % f.size() != 0L) {
                throw new IllegalStateException("Field " + f + " is not aligned");
            }
            if (f.offset() + f.size() > instanceSize) {
                throw new IllegalStateException("Field " + f + " is overflowing the object of size " + instanceSize);
            }
            if (lastField != null && f.offset() < lastField.offset() + lastField.size()) {
                throw new IllegalStateException("Field " + f + " overlaps with the previous field " + lastField);
            }
            lastField = f;
        }
    }

    public SortedSet<FieldLayout> fields() {
        return this.fields;
    }

    public long instanceSize() {
        return this.size;
    }

    public int headerSize() {
        return this.model.headerSize();
    }

    public long getLossesInternal() {
        return this.lossesInternal;
    }

    public long getLossesExternal() {
        return this.lossesExternal;
    }

    public long getLossesTotal() {
        return this.lossesTotal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FieldLayout f : this.fields()) {
            sb.append(f).append("\n");
        }
        sb.append("size = ").append(this.size).append("\n");
        return sb.toString();
    }

    public String toPrintable() {
        return this.toPrintable(this.classData.instance());
    }

    public String toPrintable(Object instance) {
        long sizeOf;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int maxTypeLen = "TYPE".length();
        for (FieldLayout f : this.fields()) {
            maxTypeLen = Math.max(f.typeClass().length(), maxTypeLen);
        }
        maxTypeLen += 2;
        String MSG_OBJ_HEADER = "(object header)";
        String MSG_MARK_WORD = "(object header: mark)";
        String MSG_CLASS_WORD = "(object header: class)";
        String MSG_ARR_LEN = "(array length)";
        String MSG_FIELD_GAP = "(alignment/padding gap)";
        String MSG_OBJ_GAP = "(object alignment gap)";
        int maxDescrLen = "DESCRIPTION".length();
        maxDescrLen = Math.max(maxDescrLen, MSG_OBJ_HEADER.length());
        maxDescrLen = Math.max(maxDescrLen, MSG_MARK_WORD.length());
        maxDescrLen = Math.max(maxDescrLen, MSG_CLASS_WORD.length());
        maxDescrLen = Math.max(maxDescrLen, MSG_FIELD_GAP.length());
        maxDescrLen = Math.max(maxDescrLen, MSG_OBJ_GAP.length());
        for (FieldLayout f : this.fields()) {
            maxDescrLen = Math.max(f.shortFieldName().length(), maxDescrLen);
        }
        String format = "%3d %3d %" + maxTypeLen + "s %-" + (maxDescrLen += 2) + "s %s%n";
        String formatS = "%3s %3s %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n";
        if (instance != null) {
            try {
                Class<?> klass = ClassUtils.loadClass(this.classData.name());
                if (!klass.isAssignableFrom(instance.getClass())) {
                    throw new IllegalArgumentException("Passed instance type " + instance.getClass() + " is not assignable from " + klass + ".");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class is not found: " + this.classData.name() + ".");
            }
        }
        pw.println(this.classData.name() + " object internals:");
        pw.printf(formatS, "OFF", "SZ", "TYPE", "DESCRIPTION", "VALUE");
        String markStr = "N/A";
        String classStr = "N/A";
        String arrLenStr = "N/A";
        int markSize = this.model.markHeaderSize();
        int classSize = this.model.classHeaderSize();
        int arrSize = this.model.arrayLengthHeaderSize();
        int markOffset = 0;
        int classOffset = markOffset + markSize;
        int arrOffset = classOffset + classSize;
        if (instance != null) {
            VirtualMachine vm = VM.current();
            if (markSize == 8) {
                long mark = vm.getLong(instance, markOffset);
                markStr = ClassLayout.toHex(mark) + " " + ClassLayout.parseMarkWord(mark);
            } else if (markSize == 4) {
                int mark = vm.getInt(instance, markOffset);
                markStr = ClassLayout.toHex(mark) + " " + ClassLayout.parseMarkWord(mark);
            }
            if (classSize == 8) {
                classStr = ClassLayout.toHex(vm.getLong(instance, classOffset));
            } else if (classSize == 4) {
                classStr = ClassLayout.toHex(vm.getInt(instance, classOffset));
            }
            if (this.classData.isArray()) {
                arrLenStr = Integer.toString(vm.getInt(instance, arrOffset));
            }
        }
        pw.printf(format, markOffset, markSize, "", MSG_MARK_WORD, markStr);
        pw.printf(format, classOffset, classSize, "", MSG_CLASS_WORD, classStr);
        if (this.classData.isArray()) {
            pw.printf(format, arrOffset, arrSize, "", MSG_ARR_LEN, arrLenStr);
        }
        long nextFree = this.headerSize();
        for (FieldLayout f : this.fields()) {
            if (f.offset() > nextFree) {
                pw.printf(format, nextFree, f.offset() - nextFree, "", MSG_FIELD_GAP, "");
            }
            Field fi = f.data().refField();
            pw.printf(format, f.offset(), f.size(), f.typeClass(), f.shortFieldName(), instance != null && fi != null ? ObjectUtils.safeToString(ObjectUtils.value(instance, fi)) : "N/A");
            nextFree = f.offset() + f.size();
        }
        long l = sizeOf = instance != null ? VM.current().sizeOf(instance) : this.instanceSize();
        if (sizeOf != nextFree) {
            pw.printf(format, nextFree, this.lossesExternal, "", MSG_OBJ_GAP, "");
        }
        pw.printf("Instance size: %d bytes%n", sizeOf);
        pw.printf("Space losses: %d bytes internal + %d bytes external = %d bytes total%n", this.lossesInternal, this.lossesExternal, this.lossesTotal);
        pw.close();
        return sw.toString();
    }

    private static String toHex(int x) {
        String s = Integer.toHexString(x);
        int deficit = 8 - s.length();
        return "0x" + ZERO_RUNS[deficit] + s;
    }

    private static String toHex(long x) {
        String s = Long.toHexString(x);
        int deficit = 16 - s.length();
        return "0x" + ZERO_RUNS[deficit] + s;
    }

    private static String parseMarkWord(int mark) {
        int bits = mark & 3;
        switch (bits) {
            case 3: {
                return "(marked: " + ClassLayout.toHex(mark) + ")";
            }
            case 0: {
                return "(thin lock: " + ClassLayout.toHex(mark) + ")";
            }
            case 2: {
                return "(fat lock: " + ClassLayout.toHex(mark) + ")";
            }
            case 1: {
                String s = "; age: " + (mark >> 3 & 0xF);
                int tribits = mark & 7;
                switch (tribits) {
                    case 1: {
                        int hash = mark >>> 7;
                        if (hash != 0) {
                            return "(hash: " + ClassLayout.toHex(hash) + s + ")";
                        }
                        return "(non-biasable" + s + ")";
                    }
                    case 5: {
                        int thread2 = mark >>> 9;
                        if (thread2 == 0) {
                            return "(biasable" + s + ")";
                        }
                        return "(biased: " + ClassLayout.toHex(thread2) + "; epoch: " + (mark >> 7 & 2) + s + ")";
                    }
                }
            }
        }
        return "(parse error)";
    }

    private static String parseMarkWord(long mark) {
        long bits = mark & 3L;
        switch ((int)bits) {
            case 3: {
                return "(marked: " + ClassLayout.toHex(mark) + ")";
            }
            case 0: {
                return "(thin lock: " + ClassLayout.toHex(mark) + ")";
            }
            case 2: {
                return "(fat lock: " + ClassLayout.toHex(mark) + ")";
            }
            case 1: {
                String s = "; age: " + (mark >> 3 & 0xFL);
                int tribits = (int)(mark & 7L);
                switch (tribits) {
                    case 1: {
                        int hash = (int)(mark >>> 8);
                        if (hash != 0) {
                            return "(hash: " + ClassLayout.toHex(hash) + s + ")";
                        }
                        return "(non-biasable" + s + ")";
                    }
                    case 5: {
                        long thread2 = mark >>> 10;
                        if (thread2 == 0L) {
                            return "(biasable" + s + ")";
                        }
                        return "(biased: " + ClassLayout.toHex(thread2) + "; epoch: " + (mark >> 8 & 2L) + s + ")";
                    }
                }
            }
        }
        return "(parse error)";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLayout that = (ClassLayout)o;
        return this.fields.equals(that.fields) && this.model.equals(that.model);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.model);
    }

    static {
        String s = "";
        for (int c = 0; c < ZERO_RUNS.length; ++c) {
            ClassLayout.ZERO_RUNS[c] = s;
            s = s + "0";
        }
    }
}

