/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.roaringbitmap.longlong;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.hudi.org.roaringbitmap.ArrayContainer;
import org.apache.hudi.org.roaringbitmap.Container;
import org.apache.hudi.org.roaringbitmap.PeekableCharIterator;
import org.apache.hudi.org.roaringbitmap.RelativeRangeConsumer;
import org.apache.hudi.org.roaringbitmap.RunContainer;
import org.apache.hudi.org.roaringbitmap.Util;
import org.apache.hudi.org.roaringbitmap.art.ContainerIterator;
import org.apache.hudi.org.roaringbitmap.art.KeyIterator;
import org.apache.hudi.org.roaringbitmap.art.LeafNode;
import org.apache.hudi.org.roaringbitmap.art.LeafNodeIterator;
import org.apache.hudi.org.roaringbitmap.longlong.ContainerWithIndex;
import org.apache.hudi.org.roaringbitmap.longlong.HighLowContainer;
import org.apache.hudi.org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.apache.hudi.org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.apache.hudi.org.roaringbitmap.longlong.LongConsumer;
import org.apache.hudi.org.roaringbitmap.longlong.LongConsumerRelativeRangeAdapter;
import org.apache.hudi.org.roaringbitmap.longlong.LongUtils;
import org.apache.hudi.org.roaringbitmap.longlong.PeekableLongIterator;

public class Roaring64Bitmap
implements Externalizable,
LongBitmapDataProvider {
    private HighLowContainer highLowContainer = new HighLowContainer();

    public void addInt(int x) {
        this.addLong(Util.toUnsignedLong(x));
    }

    @Override
    public void addLong(long x) {
        byte[] high = LongUtils.highPart(x);
        char low = LongUtils.lowPart(x);
        ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
        if (containerWithIndex != null) {
            Container container = containerWithIndex.getContainer();
            Container freshOne = container.add(low);
            this.highLowContainer.replaceContainer(containerWithIndex.getContainerIdx(), freshOne);
        } else {
            ArrayContainer arrayContainer = new ArrayContainer();
            arrayContainer.add(low);
            this.highLowContainer.put(high, arrayContainer);
        }
    }

    @Override
    public long getLongCardinality() {
        if (this.highLowContainer.isEmpty()) {
            return 0L;
        }
        ContainerIterator containerIterator = this.highLowContainer.containerIterator();
        long cardinality = 0L;
        while (containerIterator.hasNext()) {
            Container container = (Container)containerIterator.next();
            cardinality += (long)container.getCardinality();
        }
        return cardinality;
    }

    public int getIntCardinality() throws UnsupportedOperationException {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Can not call .getIntCardinality as the cardinality is bigger than Integer.MAX_VALUE");
        }
        return (int)cardinality;
    }

    @Override
    public long select(long j) throws IllegalArgumentException {
        long left = j;
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIterator(false);
        while (leafNodeIterator.hasNext()) {
            LeafNode leafNode = leafNodeIterator.next();
            long containerIdx = leafNode.getContainerIdx();
            Container container = this.highLowContainer.getContainer(containerIdx);
            int card = container.getCardinality();
            if (left >= (long)card) {
                left -= (long)card;
                continue;
            }
            byte[] high = leafNode.getKeyBytes();
            int leftAsUnsignedInt = (int)left;
            char low = container.select(leftAsUnsignedInt);
            return LongUtils.toLong(high, low);
        }
        return this.throwSelectInvalidIndex(j);
    }

    private long throwSelectInvalidIndex(long j) {
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getLongCardinality());
    }

    @Override
    public long first() {
        return this.highLowContainer.first();
    }

    @Override
    public long last() {
        return this.highLowContainer.last();
    }

    public Iterator<Long> iterator() {
        final PeekableLongIterator it = this.getLongIterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Long next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void forEach(LongConsumer lc) {
        KeyIterator keyIterator = this.highLowContainer.highKeyIterator();
        while (keyIterator.hasNext()) {
            byte[] high = keyIterator.next();
            long containerIdx = keyIterator.currentContainerIdx();
            Container container = this.highLowContainer.getContainer(containerIdx);
            PeekableCharIterator charIterator = container.getCharIterator();
            while (charIterator.hasNext()) {
                char low = charIterator.next();
                long v = LongUtils.toLong(high, low);
                lc.accept(v);
            }
        }
    }

    public void forAllInRange(long start2, int length, RelativeRangeConsumer rrc) {
        LeafNodeIterator leafIterator = this.highLowContainer.highKeyLeafNodeIteratorFrom(start2, false);
        if (!leafIterator.hasNext()) {
            rrc.acceptAllAbsent(0, length);
            return;
        }
        long end = start2 + (long)length;
        byte[] endHigh = LongUtils.highPart(end);
        long filledUntil = start2;
        LeafNode node = leafIterator.next();
        byte[] high = node.getKeyBytes();
        while (LongUtils.compareHigh(high, endHigh) <= 0) {
            char containerRangeStart;
            boolean endInContainer;
            long containerStart = LongUtils.toLong(high, '\u0000');
            if (filledUntil < containerStart) {
                rrc.acceptAllAbsent((int)(filledUntil - start2), (int)(containerStart - start2));
                filledUntil = containerStart;
            }
            long containerIdx = node.getContainerIdx();
            Container container = this.highLowContainer.getContainer(containerIdx);
            long containerEnd = LongUtils.toLong(high, '\uffff') + 1L;
            int containerRangeStartOffset = (int)(filledUntil - start2);
            boolean startInContainer = containerStart < start2;
            boolean bl = endInContainer = end < containerEnd;
            if (startInContainer && endInContainer) {
                containerRangeStart = LongUtils.lowPart(start2);
                char containerRangeEnd = LongUtils.lowPart(end);
                container.forAllInRange(LongUtils.lowPart(start2), LongUtils.lowPart(end), rrc);
                filledUntil += (long)(containerRangeEnd - containerRangeStart);
            } else if (startInContainer) {
                containerRangeStart = LongUtils.lowPart(start2);
                container.forAllFrom(containerRangeStart, rrc);
                filledUntil += (long)(65536 - containerRangeStart);
            } else if (endInContainer) {
                char containerRangeEnd = LongUtils.lowPart(end);
                container.forAllUntil(containerRangeStartOffset, containerRangeEnd, rrc);
                filledUntil += (long)containerRangeEnd;
            } else {
                container.forAll(containerRangeStartOffset, rrc);
                filledUntil += 65536L;
            }
            if (!leafIterator.hasNext()) break;
            node = leafIterator.next();
            high = node.getKeyBytes();
        }
        if (filledUntil < end) {
            rrc.acceptAllAbsent((int)(filledUntil - start2), length);
        }
    }

    public void forEachInRange(long start2, int length, LongConsumer lc) {
        this.forAllInRange(start2, length, new LongConsumerRelativeRangeAdapter(start2, lc));
    }

    @Override
    public long rankLong(long id) {
        long result = 0L;
        byte[] high = LongUtils.highPart(id);
        char low = LongUtils.lowPart(id);
        ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
        KeyIterator keyIterator = this.highLowContainer.highKeyIterator();
        if (containerWithIndex == null) {
            byte[] highKey;
            int res;
            while (keyIterator.hasNext() && (res = LongUtils.compareHigh(highKey = keyIterator.next(), high)) <= 0) {
                long containerIdx = keyIterator.currentContainerIdx();
                Container container = this.highLowContainer.getContainer(containerIdx);
                result += (long)container.getCardinality();
            }
        } else {
            while (keyIterator.hasNext()) {
                byte[] key = keyIterator.next();
                long containerIdx = keyIterator.currentContainerIdx();
                Container container = this.highLowContainer.getContainer(containerIdx);
                if (LongUtils.compareHigh(key, high) == 0) {
                    result += (long)container.rank(low);
                    break;
                }
                result += (long)container.getCardinality();
            }
        }
        return result;
    }

    public void or(Roaring64Bitmap x2) {
        if (this == x2) {
            return;
        }
        KeyIterator highIte2 = x2.highLowContainer.highKeyIterator();
        while (highIte2.hasNext()) {
            byte[] high = highIte2.next();
            long containerIdx = highIte2.currentContainerIdx();
            Container container2 = x2.highLowContainer.getContainer(containerIdx);
            ContainerWithIndex containerWithIdx = this.highLowContainer.searchContainer(high);
            if (containerWithIdx == null) {
                Container container2clone = container2.clone();
                this.highLowContainer.put(high, container2clone);
                continue;
            }
            Container freshContainer = containerWithIdx.getContainer().ior(container2);
            this.highLowContainer.replaceContainer(containerWithIdx.getContainerIdx(), freshContainer);
        }
    }

    public void xor(Roaring64Bitmap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        KeyIterator keyIterator = x2.highLowContainer.highKeyIterator();
        while (keyIterator.hasNext()) {
            byte[] high = keyIterator.next();
            long containerIdx = keyIterator.currentContainerIdx();
            Container container = x2.highLowContainer.getContainer(containerIdx);
            ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
            if (containerWithIndex == null) {
                Container containerClone2 = container.clone();
                this.highLowContainer.put(high, containerClone2);
                continue;
            }
            Container freshOne = containerWithIndex.getContainer().ixor(container);
            this.highLowContainer.replaceContainer(containerWithIndex.getContainerIdx(), freshOne);
        }
    }

    public void and(Roaring64Bitmap x2) {
        if (x2 == this) {
            return;
        }
        KeyIterator thisIterator = this.highLowContainer.highKeyIterator();
        while (thisIterator.hasNext()) {
            byte[] highKey = thisIterator.next();
            long containerIdx = thisIterator.currentContainerIdx();
            ContainerWithIndex containerWithIdx = x2.highLowContainer.searchContainer(highKey);
            if (containerWithIdx == null) {
                thisIterator.remove();
                continue;
            }
            Container container1 = this.highLowContainer.getContainer(containerIdx);
            Container freshContainer = container1.iand(containerWithIdx.getContainer());
            if (!freshContainer.isEmpty()) {
                this.highLowContainer.replaceContainer(containerIdx, freshContainer);
                continue;
            }
            thisIterator.remove();
        }
    }

    public void andNot(Roaring64Bitmap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        KeyIterator thisKeyIterator = this.highLowContainer.highKeyIterator();
        while (thisKeyIterator.hasNext()) {
            byte[] high = thisKeyIterator.next();
            long containerIdx = thisKeyIterator.currentContainerIdx();
            ContainerWithIndex containerWithIdx2 = x2.highLowContainer.searchContainer(high);
            if (containerWithIdx2 == null) continue;
            Container thisContainer = this.highLowContainer.getContainer(containerIdx);
            Container freshContainer = thisContainer.iandNot(containerWithIdx2.getContainer());
            this.highLowContainer.replaceContainer(containerIdx, freshContainer);
            if (!freshContainer.isEmpty()) {
                this.highLowContainer.replaceContainer(containerIdx, freshContainer);
                continue;
            }
            thisKeyIterator.remove();
        }
    }

    public void flip(long rangeStart, long rangeEnd) {
        if (rangeStart >= 0L && rangeEnd >= 0L && rangeStart >= rangeEnd) {
            return;
        }
        if (rangeStart < 0L && rangeEnd < 0L && rangeStart >= rangeEnd) {
            return;
        }
        if (rangeStart < 0L && rangeEnd > 0L) {
            return;
        }
        byte[] hbStart = LongUtils.highPart(rangeStart);
        char lbStart = LongUtils.lowPart(rangeStart);
        int lbLast = LongUtils.lowPart(rangeEnd - 1L);
        long shStart = LongUtils.rightShiftHighPart(rangeStart);
        long shEnd = LongUtils.rightShiftHighPart(rangeEnd - 1L);
        for (long hb = shStart; hb <= shEnd; ++hb) {
            char containerStart = hb == shStart ? lbStart : (char)'\u0000';
            int containerLast = hb == shEnd ? lbLast : LongUtils.maxLowBitAsInteger();
            ContainerWithIndex cwi = this.highLowContainer.searchContainer(LongUtils.highPartInPlace(LongUtils.leftShiftHighPart(hb), hbStart));
            if (cwi != null) {
                long i = cwi.getContainerIdx();
                Container c = cwi.getContainer().inot(containerStart, containerLast + 1);
                if (!c.isEmpty()) {
                    this.highLowContainer.replaceContainer(i, c);
                    continue;
                }
                this.highLowContainer.remove(hbStart);
                continue;
            }
            Container newContainer = Container.rangeOfOnes(containerStart, containerLast + 1);
            this.highLowContainer.put(hbStart, newContainer);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    public String toString() {
        StringBuilder answer = new StringBuilder("{}".length() + "-1234567890123456789,".length() * 256);
        PeekableLongIterator i = this.getLongIterator();
        answer.append('{');
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(',');
            if (answer.length() > 524288) {
                answer.append('.').append('.').append('.');
                break;
            }
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    @Override
    public PeekableLongIterator getLongIterator() {
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIterator(false);
        return new ForwardPeekableIterator(leafNodeIterator);
    }

    LeafNodeIterator getLeafNodeIterator() {
        return this.highLowContainer.highKeyLeafNodeIterator(false);
    }

    public PeekableLongIterator getLongIteratorFrom(long minval) {
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIteratorFrom(minval, false);
        ForwardPeekableIterator fpi = new ForwardPeekableIterator(leafNodeIterator);
        fpi.advanceIfNeeded(minval);
        return fpi;
    }

    @Override
    public boolean contains(long x) {
        byte[] high = LongUtils.highPart(x);
        ContainerWithIndex containerWithIdx = this.highLowContainer.searchContainer(high);
        if (containerWithIdx == null) {
            return false;
        }
        char low = LongUtils.lowPart(x);
        return containerWithIdx.getContainer().contains(low);
    }

    @Override
    public int getSizeInBytes() {
        return (int)this.getLongSizeInBytes();
    }

    @Override
    public long getLongSizeInBytes() {
        return this.serializedSizeInBytes();
    }

    @Override
    public boolean isEmpty() {
        return this.getLongCardinality() == 0L;
    }

    @Override
    public ImmutableLongBitmapDataProvider limit(long x) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean runOptimize() {
        boolean hasChanged = false;
        ContainerIterator containerIterator = this.highLowContainer.containerIterator();
        while (containerIterator.hasNext()) {
            Container container = containerIterator.next();
            Container freshContainer = container.runOptimize();
            if (!(freshContainer instanceof RunContainer)) continue;
            hasChanged = true;
            containerIterator.replace(freshContainer);
        }
        return hasChanged;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    public void serialize(ByteBuffer byteBuffer) throws IOException {
        this.highLowContainer.serialize(byteBuffer);
    }

    public void deserialize(DataInput in) throws IOException {
        this.clear();
        this.highLowContainer.deserialize(in);
    }

    public void deserialize(ByteBuffer in) throws IOException {
        this.clear();
        this.highLowContainer.deserialize(in);
    }

    @Override
    public long serializedSizeInBytes() {
        long nbBytes = this.highLowContainer.serializedSizeInBytes();
        return nbBytes;
    }

    public void clear() {
        this.highLowContainer.clear();
    }

    @Override
    public long[] toArray() {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new IllegalStateException("The cardinality does not fit in an array");
        }
        long[] array = new long[(int)cardinality];
        int pos = 0;
        PeekableLongIterator it = this.getLongIterator();
        while (it.hasNext()) {
            array[pos++] = it.next();
        }
        return array;
    }

    public static Roaring64Bitmap bitmapOf(long ... dat) {
        Roaring64Bitmap ans = new Roaring64Bitmap();
        ans.add(dat);
        return ans;
    }

    public void add(long ... dat) {
        for (long oneLong : dat) {
            this.addLong(oneLong);
        }
    }

    @Deprecated
    public void add(long rangeStart, long rangeEnd) {
        this.addRange(rangeStart, rangeEnd);
    }

    public void addRange(long rangeStart, long rangeEnd) {
        if (rangeEnd == 0L || Long.compareUnsigned(rangeStart, rangeEnd) >= 0) {
            throw new IllegalArgumentException("Invalid range [" + rangeStart + "," + rangeEnd + ")");
        }
        byte[] startHigh = LongUtils.highPart(rangeStart);
        char startLow = LongUtils.lowPart(rangeStart);
        byte[] endHigh = LongUtils.highPart(rangeEnd - 1L);
        int endLow = LongUtils.lowPart(rangeEnd - 1L);
        long rangeStartVal = rangeStart;
        byte[] startHighKey = startHigh;
        while (LongUtils.compareHigh(startHighKey, endHigh) <= 0) {
            char containerStart = LongUtils.compareHigh(startHighKey, startHigh) == 0 ? startLow : (char)'\u0000';
            int containerLast = LongUtils.compareHigh(startHighKey, endHigh) == 0 ? endLow : Util.maxLowBitAsInteger();
            ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(startHighKey);
            if (containerWithIndex != null) {
                long containerIdx = containerWithIndex.getContainerIdx();
                Container freshContainer = this.highLowContainer.getContainer(containerIdx).iadd(containerStart, containerLast + 1);
                this.highLowContainer.replaceContainer(containerIdx, freshContainer);
            } else {
                Container freshContainer = Container.rangeOfOnes(containerStart, containerLast + 1);
                this.highLowContainer.put(startHighKey, freshContainer);
            }
            if (LongUtils.isMaxHigh(startHighKey)) break;
            rangeStartVal = rangeStartVal + (long)(containerLast - containerStart) + 1L;
            startHighKey = LongUtils.highPart(rangeStartVal);
        }
    }

    @Override
    public PeekableLongIterator getReverseLongIterator() {
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIterator(true);
        return new ReversePeekableIterator(leafNodeIterator);
    }

    public PeekableLongIterator getReverseLongIteratorFrom(long maxval) {
        LeafNodeIterator leafNodeIterator = this.highLowContainer.highKeyLeafNodeIteratorFrom(maxval, true);
        ReversePeekableIterator rpi = new ReversePeekableIterator(leafNodeIterator);
        rpi.advanceIfNeeded(maxval);
        return rpi;
    }

    @Override
    public void removeLong(long x) {
        byte[] high = LongUtils.highPart(x);
        ContainerWithIndex containerWithIdx = this.highLowContainer.searchContainer(high);
        if (containerWithIdx != null) {
            char low = LongUtils.lowPart(x);
            Container container = containerWithIdx.getContainer();
            Container freshContainer = container.remove(low);
            if (freshContainer.isEmpty()) {
                this.highLowContainer.remove(high);
            } else {
                this.highLowContainer.replaceContainer(containerWithIdx.getContainerIdx(), freshContainer);
            }
        }
    }

    @Override
    public void trim() {
        if (this.highLowContainer.isEmpty()) {
            return;
        }
        KeyIterator keyIterator = this.highLowContainer.highKeyIterator();
        while (keyIterator.hasNext()) {
            long containerIdx = keyIterator.currentContainerIdx();
            Container container = this.highLowContainer.getContainer(containerIdx);
            if (container.isEmpty()) {
                keyIterator.remove();
                continue;
            }
            container.trim();
        }
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Roaring64Bitmap other = (Roaring64Bitmap)obj;
        return Objects.equals(this.highLowContainer, other.highLowContainer);
    }

    public void flip(long x) {
        byte[] high = LongUtils.highPart(x);
        ContainerWithIndex containerWithIndex = this.highLowContainer.searchContainer(high);
        if (containerWithIndex == null) {
            this.addLong(x);
        } else {
            char low = LongUtils.lowPart(x);
            Container freshOne = containerWithIndex.getContainer().flip(low);
            this.highLowContainer.replaceContainer(containerWithIndex.getContainerIdx(), freshOne);
        }
    }

    public Roaring64Bitmap clone() {
        long sizeInBytesL = this.serializedSizeInBytes();
        if (sizeInBytesL >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        int sizeInBytesInt = (int)sizeInBytesL;
        ByteBuffer byteBuffer = ByteBuffer.allocate(sizeInBytesInt).order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.serialize(byteBuffer);
            byteBuffer.flip();
            Roaring64Bitmap freshOne = new Roaring64Bitmap();
            freshOne.deserialize(byteBuffer);
            return freshOne;
        }
        catch (Exception e) {
            throw new RuntimeException("fail to clone thorough the ser/deser", e);
        }
    }

    private class ForwardPeekableIterator
    extends PeekableIterator {
        public ForwardPeekableIterator(LeafNodeIterator keyIte) {
            super(keyIte);
        }

        @Override
        PeekableCharIterator getIterator(Container container) {
            return container.getCharIterator();
        }

        @Override
        boolean compare(long next, long val) {
            return Long.compareUnsigned(next, val) >= 0;
        }

        @Override
        boolean compareHigh(byte[] next, byte[] val) {
            return LongUtils.compareHigh(next, val) >= 0;
        }
    }

    private class ReversePeekableIterator
    extends PeekableIterator {
        public ReversePeekableIterator(LeafNodeIterator keyIte) {
            super(keyIte);
        }

        @Override
        PeekableCharIterator getIterator(Container container) {
            return container.getReverseCharIterator();
        }

        @Override
        boolean compare(long next, long val) {
            return Long.compareUnsigned(next, val) <= 0;
        }

        @Override
        boolean compareHigh(byte[] next, byte[] val) {
            return LongUtils.compareHigh(next, val) <= 0;
        }
    }

    private abstract class PeekableIterator
    implements PeekableLongIterator {
        private final LeafNodeIterator keyIte;
        private byte[] high;
        private PeekableCharIterator charIterator;

        PeekableIterator(LeafNodeIterator keyIte) {
            this.keyIte = keyIte;
        }

        abstract PeekableCharIterator getIterator(Container var1);

        abstract boolean compare(long var1, long var3);

        abstract boolean compareHigh(byte[] var1, byte[] var2);

        @Override
        public boolean hasNext() {
            if (this.charIterator != null && this.charIterator.hasNext()) {
                return true;
            }
            while (this.keyIte.hasNext()) {
                LeafNode leafNode = this.keyIte.next();
                this.high = leafNode.getKeyBytes();
                long containerIdx = leafNode.getContainerIdx();
                Container container = Roaring64Bitmap.this.highLowContainer.getContainer(containerIdx);
                this.charIterator = this.getIterator(container);
                if (!this.charIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public long next() {
            if (this.hasNext()) {
                char low = this.charIterator.next();
                return LongUtils.toLong(this.high, low);
            }
            throw new IllegalStateException("empty");
        }

        @Override
        public void advanceIfNeeded(long minval) {
            if (!this.hasNext()) {
                return;
            }
            if (this.compare(this.peekNext(), minval)) {
                return;
            }
            if (this.high == null) {
                return;
            }
            byte[] minHigh = LongUtils.highPart(minval);
            if (!Arrays.equals(this.high, minHigh) && this.keyIte.hasNext()) {
                LeafNode leafNode = this.keyIte.next();
                this.high = leafNode.getKeyBytes();
                if (this.compareHigh(this.high, minHigh)) {
                    long containerIdx = leafNode.getContainerIdx();
                    Container container = Roaring64Bitmap.this.highLowContainer.getContainer(containerIdx);
                    this.charIterator = this.getIterator(container);
                    if (!this.charIterator.hasNext()) {
                        return;
                    }
                } else {
                    this.keyIte.seek(minval);
                    if (this.keyIte.hasNext()) {
                        leafNode = this.keyIte.next();
                        this.high = leafNode.getKeyBytes();
                        long containerIdx = leafNode.getContainerIdx();
                        Container container = Roaring64Bitmap.this.highLowContainer.getContainer(containerIdx);
                        this.charIterator = this.getIterator(container);
                        if (!this.charIterator.hasNext()) {
                            return;
                        }
                    } else {
                        this.charIterator = null;
                        return;
                    }
                }
            }
            if (Arrays.equals(this.high, minHigh)) {
                char low = LongUtils.lowPart(minval);
                this.charIterator.advanceIfNeeded(low);
            }
        }

        @Override
        public long peekNext() {
            if (this.hasNext()) {
                char low = this.charIterator.peekNext();
                return LongUtils.toLong(this.high, low);
            }
            throw new IllegalStateException("empty");
        }

        @Override
        public PeekableLongIterator clone() {
            throw new UnsupportedOperationException("TODO");
        }
    }
}

