/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.util.Arrays;

public enum StorageSchemes {
    FILE("file", false, true),
    HDFS("hdfs", false, true),
    AFS("afs", null, null),
    MAPRFS("maprfs", null, null),
    IGNITE("igfs", null, null),
    S3A("s3a", true, null),
    S3("s3", true, null),
    GCS("gs", true, null),
    WASB("wasb", null, null),
    WASBS("wasbs", null, null),
    ADL("adl", null, null),
    ABFS("abfs", null, null),
    ABFSS("abfss", null, null),
    OSS("oss", null, null),
    VIEWFS("viewfs", null, true),
    ALLUXIO("alluxio", null, null),
    COSN("cosn", null, null),
    CHDFS("ofs", null, null),
    GOOSEFS("gfs", null, null),
    DBFS("dbfs", null, null),
    COS("cos", null, null),
    OBS("obs", null, null),
    KS3("ks3", null, null),
    NOS("nos", null, null),
    JFS("jfs", null, null),
    BOS("bos", null, null),
    OCI("oci", null, null),
    TOS("tos", null, null),
    CFS("cfs", null, null),
    HOPSFS("hopsfs", false, true);

    private String scheme;
    private Boolean isWriteTransactional;
    private Boolean supportAtomicCreation;

    private StorageSchemes(String scheme2, Boolean isWriteTransactional, Boolean supportAtomicCreation) {
        this.scheme = scheme2;
        this.isWriteTransactional = isWriteTransactional;
        this.supportAtomicCreation = supportAtomicCreation;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isWriteTransactional() {
        return this.isWriteTransactional != null && this.isWriteTransactional != false;
    }

    public boolean isAtomicCreationSupported() {
        return this.supportAtomicCreation != null && this.supportAtomicCreation != false;
    }

    public static boolean isSchemeSupported(String scheme2) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme2));
    }

    public static boolean isWriteTransactional(String scheme2) {
        if (!StorageSchemes.isSchemeSupported(scheme2)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme2);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isWriteTransactional() && s.scheme.equals(scheme2));
    }

    public static boolean isAtomicCreationSupported(String scheme2) {
        if (!StorageSchemes.isSchemeSupported(scheme2)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme2);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isAtomicCreationSupported() && s.scheme.equals(scheme2));
    }
}

