/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileWriter {
    public static final String MANIFEST_FOLDER_NAME = "manifest";
    public static final String ABSOLUTE_PATH_MANIFEST_FOLDER_NAME = "absolute-path-manifest";
    public static final String MANIFEST_FILE_NAME = "latest-snapshot.csv";
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFileWriter.class);
    private final HoodieTableMetaClient metaClient;
    private final boolean useFileListingFromMetadata;

    protected ManifestFileWriter(HoodieTableMetaClient metaClient, boolean useFileListingFromMetadata) {
        this.metaClient = metaClient;
        this.useFileListingFromMetadata = useFileListingFromMetadata;
    }

    public synchronized void writeManifestFile(boolean useAbsolutePath) {
        try {
            List baseFiles = this.fetchLatestBaseFilesForAllPartitions(useAbsolutePath).collect(Collectors.toList());
            if (baseFiles.isEmpty()) {
                LOG.warn("No base file to generate manifest file.");
                return;
            }
            LOG.info("Writing base file names to manifest file: {}", (Object)baseFiles.size());
            StoragePath manifestFilePath = this.getManifestFilePath(useAbsolutePath);
            try (OutputStream outputStream = this.metaClient.getStorage().create(manifestFilePath, true);
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
                for (String f : baseFiles) {
                    writer.write(f);
                    writer.write("\n");
                }
            }
        }
        catch (Exception e) {
            throw new HoodieException("Error in writing manifest file.", e);
        }
    }

    @VisibleForTesting
    public Stream<String> fetchLatestBaseFilesForAllPartitions(boolean useAbsolutePath) {
        try {
            StorageConfiguration<?> storageConf = this.metaClient.getStorageConf();
            HoodieLocalEngineContext engContext = new HoodieLocalEngineContext(storageConf);
            boolean canUseMetadataTable = this.useFileListingFromMetadata && this.metaClient.getTableConfig().isMetadataTableAvailable();
            return ManifestFileWriter.getLatestBaseFiles(canUseMetadataTable, engContext, this.metaClient, useAbsolutePath);
        }
        catch (Exception e) {
            throw new HoodieException("Error in fetching latest base files.", e);
        }
    }

    public StoragePath getManifestFolder(boolean useAbsolutePath) {
        return new StoragePath(this.metaClient.getMetaPath(), useAbsolutePath ? ABSOLUTE_PATH_MANIFEST_FOLDER_NAME : MANIFEST_FOLDER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static Stream<String> getLatestBaseFiles(boolean canUseMetadataTable, HoodieEngineContext engContext, HoodieTableMetaClient metaClient, boolean useAbsolutePath) {
        List<String> partitions = FSUtils.getAllPartitionPaths(engContext, metaClient.getStorage(), metaClient.getBasePath(), canUseMetadataTable);
        LOG.info("Retrieve all partitions: " + partitions.size());
        try (HoodieTableFileSystemView fsView = null;){
            fsView = FileSystemViewManager.createInMemoryFileSystemViewWithTimeline(engContext, metaClient, HoodieMetadataConfig.newBuilder().enable(canUseMetadataTable).build(), metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants());
            if (canUseMetadataTable) {
                fsView.loadAllPartitions();
            }
            HoodieTableFileSystemView finalFsView = fsView;
            Stream<String> stream = partitions.parallelStream().flatMap(partition -> finalFsView.getLatestBaseFiles((String)partition).map(useAbsolutePath ? BaseFile::getPath : BaseFile::getFileName)).collect(Collectors.toList()).stream();
            return stream;
        }
    }

    public StoragePath getManifestFilePath(boolean useAbsolutePath) {
        return new StoragePath(this.getManifestFolder(useAbsolutePath), MANIFEST_FILE_NAME);
    }

    public String getManifestSourceUri(boolean useAbsolutePath) {
        return new Path(this.getManifestFolder(useAbsolutePath).toString(), "*").toUri().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean useFileListingFromMetadata;
        private HoodieTableMetaClient metaClient;

        public Builder setUseFileListingFromMetadata(boolean useFileListingFromMetadata) {
            this.useFileListingFromMetadata = useFileListingFromMetadata;
            return this;
        }

        public Builder setMetaClient(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
            return this;
        }

        public ManifestFileWriter build() {
            ValidationUtils.checkArgument(this.metaClient != null, "MetaClient needs to be set to init ManifestFileGenerator");
            return new ManifestFileWriter(this.metaClient, this.useFileListingFromMetadata);
        }
    }
}

