/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusteringExecutionStrategy<T, I, K, O>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringExecutionStrategy.class);
    private final HoodieTable<T, I, K, O> hoodieTable;
    private final transient HoodieEngineContext engineContext;
    protected final HoodieWriteConfig writeConfig;
    protected final HoodieRecord.HoodieRecordType recordType;

    public ClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
        this.hoodieTable = table;
        this.engineContext = engineContext;
        this.recordType = table.getConfig().getRecordMerger().getRecordType();
    }

    public abstract HoodieWriteMetadata<O> performClustering(HoodieClusteringPlan var1, Schema var2, String var3);

    protected HoodieTable<T, I, K, O> getHoodieTable() {
        return this.hoodieTable;
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    protected HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }
}

