/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;

public class CompositeCompactionStrategy
extends CompactionStrategy {
    private List<CompactionStrategy> strategies;

    public CompositeCompactionStrategy(List<CompactionStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        List<HoodieCompactionOperation> finalOperations = operations;
        for (CompactionStrategy strategy : this.strategies) {
            finalOperations = strategy.orderAndFilter(writeConfig, finalOperations, pendingCompactionPlans);
        }
        return finalOperations;
    }

    @Override
    public List<String> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        List<String> finalPartitionPaths = allPartitionPaths;
        for (CompactionStrategy strategy : this.strategies) {
            finalPartitionPaths = strategy.filterPartitionPaths(writeConfig, finalPartitionPaths);
        }
        return finalPartitionPaths;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompactionStrategyChain [");
        for (CompactionStrategy strategy : this.strategies) {
            builder.append(strategy.getClass());
            builder.append(" ===> ");
        }
        builder.append("]");
        return builder.toString();
    }
}

