/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index.functional;

import java.util.Map;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieIndexClient {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieIndexClient.class);

    public void register(HoodieTableMetaClient metaClient, HoodieIndexDefinition indexDefinition) {
        LOG.info("Registering index {} of using {}", (Object)indexDefinition.getIndexName(), (Object)indexDefinition.getIndexType());
        metaClient.buildIndexDefinition(indexDefinition);
        String indexMetaPath = metaClient.getIndexDefinitionPath();
        if (!metaClient.getTableConfig().getProps().containsKey(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH) || !metaClient.getTableConfig().getRelativeIndexDefinitionPath().isPresent()) {
            metaClient.getTableConfig().setValue(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH, FSUtils.getRelativePartitionPath(metaClient.getBasePath(), new StoragePath(indexMetaPath)));
            HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), metaClient.getTableConfig().getProps());
        }
    }

    public abstract void create(HoodieTableMetaClient var1, String var2, String var3, Map<String, Map<String, String>> var4, Map<String, String> var5) throws Exception;

    public abstract void drop(HoodieTableMetaClient var1, String var2, boolean var3);
}

