/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRestoreException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.restore.RestoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestoreActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieRestoreMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRestoreActionExecutor.class);
    private final String savepointToRestoreTimestamp;
    private final TransactionManager txnManager;

    public BaseRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime);
        this.savepointToRestoreTimestamp = savepointToRestoreTimestamp;
        this.txnManager = new TransactionManager(config, table.getStorage());
    }

    @Override
    public HoodieRestoreMetadata execute() {
        HoodieTimer restoreTimer = HoodieTimer.start();
        Option<HoodieInstant> restoreInstant = this.table.getRestoreTimeline().filterInflightsAndRequested().filter(instant -> instant.requestedTime().equals(this.instantTime)).firstInstant();
        if (!restoreInstant.isPresent()) {
            throw new HoodieRollbackException("No pending restore instants found to execute restore");
        }
        try {
            List<HoodieInstant> instantsToRollback = this.getInstantsToRollback(restoreInstant.get());
            ValidationUtils.checkArgument(restoreInstant.get().getState().equals((Object)HoodieInstant.State.REQUESTED) || restoreInstant.get().getState().equals((Object)HoodieInstant.State.INFLIGHT));
            HashMap<String, List<HoodieRollbackMetadata>> instantToMetadata = new HashMap<String, List<HoodieRollbackMetadata>>();
            if (restoreInstant.get().isRequested()) {
                this.table.getActiveTimeline().transitionRestoreRequestedToInflight(restoreInstant.get());
            }
            instantsToRollback.forEach(instant -> {
                instantToMetadata.put(instant.requestedTime(), Collections.singletonList(this.rollbackInstant((HoodieInstant)instant)));
                LOG.info("Deleted instant " + instant);
            });
            return this.finishRestore(instantToMetadata, instantsToRollback, restoreTimer.endTimer());
        }
        catch (IOException io) {
            throw new HoodieRestoreException("unable to Restore instant " + restoreInstant.get(), io);
        }
    }

    private List<HoodieInstant> getInstantsToRollback(HoodieInstant restoreInstant) throws IOException {
        ArrayList<HoodieInstant> instantsToRollback = new ArrayList<HoodieInstant>();
        HoodieRestorePlan restorePlan = RestoreUtils.getRestorePlan(this.table.getMetaClient(), restoreInstant);
        for (HoodieInstantInfo instantInfo : restorePlan.getInstantsToRollback()) {
            Option<HoodieInstant> rollbackInstantOpt = this.table.getActiveTimeline().getWriteTimeline().filter(instant -> instant.requestedTime().equals(instantInfo.getCommitTime()) && instant.getAction().equals(instantInfo.getAction())).firstInstant();
            if (rollbackInstantOpt.isPresent()) {
                instantsToRollback.add(rollbackInstantOpt.get());
                continue;
            }
            LOG.warn("Ignoring already rolledback instant " + instantInfo.toString());
        }
        return instantsToRollback;
    }

    protected abstract HoodieRollbackMetadata rollbackInstant(HoodieInstant var1);

    private HoodieRestoreMetadata finishRestore(Map<String, List<HoodieRollbackMetadata>> instantToMetadata, List<HoodieInstant> instantsRolledBack, long durationInMs) throws IOException {
        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.convertRestoreMetadata(this.instantTime, durationInMs, instantsRolledBack, instantToMetadata);
        HoodieInstant restoreInflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "restore", this.instantTime);
        this.writeToMetadata(restoreMetadata, restoreInflightInstant);
        this.table.getActiveTimeline().saveAsComplete(restoreInflightInstant, TimelineMetadataUtils.serializeRestoreMetadata(restoreMetadata));
        List<HoodieInstant> instantsToRollback = this.table.getActiveTimeline().getRollbackTimeline().getReverseOrderedInstants().filter(instant -> InstantComparison.GREATER_THAN.test(instant.requestedTime(), this.savepointToRestoreTimestamp)).collect(Collectors.toList());
        instantsToRollback.forEach(entry -> {
            if (entry.isCompleted()) {
                this.table.getActiveTimeline().deleteCompletedRollback((HoodieInstant)entry);
            }
            this.table.getActiveTimeline().deletePending(this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "rollback", entry.requestedTime()));
            this.table.getActiveTimeline().deletePending(this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "rollback", entry.requestedTime()));
        });
        LOG.info("Commits " + instantsRolledBack + " rollback is complete. Restored table to " + this.savepointToRestoreTimestamp);
        return restoreMetadata;
    }

    private void writeToMetadata(HoodieRestoreMetadata restoreMetadata, HoodieInstant restoreInflightInstant) {
        try {
            this.txnManager.beginTransaction(Option.of(restoreInflightInstant), Option.empty());
            this.writeTableMetadata(restoreMetadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of(restoreInflightInstant));
        }
    }
}

