/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.sql.HoodieSchemaUtils;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieParquetFileFormatHelper$ {
    public static HoodieParquetFileFormatHelper$ MODULE$;

    static {
        new HoodieParquetFileFormatHelper$();
    }

    public Tuple2<java.util.Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(Configuration hadoopConf, FileMetaData parquetFileMetaData, StructType requiredSchema) {
        ParquetToSparkSchemaConverter convert = new ParquetToSparkSchemaConverter(hadoopConf);
        StructType fileStruct = convert.convert(parquetFileMetaData.getSchema());
        return this.buildImplicitSchemaChangeInfo(fileStruct, requiredSchema);
    }

    public Tuple2<java.util.Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(StructType fileStruct, StructType requiredSchema) {
        HashMap implicitTypeChangeInfo = new HashMap();
        Map fileStructMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStruct.fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Seq sparkRequestStructFields = (Seq)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> {
            DataType requiredType = f.dataType();
            if (fileStructMap.contains((Object)f.name()) && !MODULE$.isDataTypeEqual(requiredType, (DataType)fileStructMap.apply((Object)f.name()))) {
                DataType readerType = MODULE$.addMissingFields(requiredType, (DataType)fileStructMap.apply((Object)f.name()));
                implicitTypeChangeInfo.put(new Integer(requiredSchema.fieldIndex(f.name())), Pair.of(requiredType, readerType));
                return new StructField(f.name(), readerType, f.nullable(), StructField$.MODULE$.apply$default$4());
            }
            return f;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2(implicitTypeChangeInfo, (Object)StructType$.MODULE$.apply(sparkRequestStructFields));
    }

    public boolean isDataTypeEqual(DataType requiredType, DataType fileType) {
        Tuple2 tuple2;
        block9: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)requiredType, (Object)fileType)) != null) {
                    DataType requiredType2 = (DataType)tuple2._1();
                    DataType fileType2 = (DataType)tuple2._2();
                    DataType dataType = requiredType2;
                    DataType dataType2 = fileType2;
                    if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType3 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType rt = arrayType.elementType();
                        if (dataType3 instanceof ArrayType) {
                            DataType ft;
                            ArrayType arrayType2 = (ArrayType)dataType3;
                            fileType = ft = arrayType2.elementType();
                            requiredType = rt;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block9;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType4 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block9;
                MapType mapType = (MapType)dataType;
                DataType requiredKey = mapType.keyType();
                DataType requiredValue = mapType.valueType();
                if (!(dataType4 instanceof MapType)) break block9;
                MapType mapType2 = (MapType)dataType4;
                DataType fileKey = mapType2.keyType();
                DataType fileValue = mapType2.valueType();
                if (!this.isDataTypeEqual(requiredKey, fileKey)) break;
                fileType = fileValue;
                requiredType = requiredValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] requiredFields = structType.fields();
                if (dataType5 instanceof StructType) {
                    StructType structType2 = (StructType)dataType5;
                    StructField[] fileFields = structType2.fields();
                    String[] commonFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).intersect((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
                    StructField[] fileFilteredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$3(commonFieldNames, f))))).sortWith((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$4(x$3, x$4)));
                    StructField[] requiredFilteredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$5(commonFieldNames, f))))).sortWith((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$6(x$5, x$6)));
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFilteredFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fileFilteredFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$7(x0$1)));
                }
            }
        }
        return false;
    }

    public DataType addMissingFields(DataType requiredType, DataType fileType) {
        Tuple2 tuple2 = new Tuple2((Object)requiredType, (Object)fileType);
        if (tuple2 != null) {
            DataType requiredType2 = (DataType)tuple2._1();
            DataType fileType2 = (DataType)tuple2._2();
            DataType dataType = requiredType2;
            DataType dataType2 = fileType2;
            if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                return fileType2;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType rt = arrayType.elementType();
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType3;
                    DataType ft = arrayType2.elementType();
                    return ArrayType$.MODULE$.apply(this.addMissingFields(rt, ft));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType requiredKey = mapType.keyType();
                DataType requiredValue = mapType.valueType();
                if (dataType4 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType4;
                    DataType fileKey = mapType2.keyType();
                    DataType fileValue = mapType2.valueType();
                    return MapType$.MODULE$.apply(this.addMissingFields(requiredKey, fileKey), this.addMissingFields(requiredValue, fileValue));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] requiredFields = structType.fields();
                if (dataType5 instanceof StructType) {
                    StructType structType2 = (StructType)dataType5;
                    StructField[] fileFields = structType2.fields();
                    Map fileFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                    return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).map((Function1 & Serializable & scala.Serializable)f -> {
                        Option option = fileFieldMap.get((Object)f.name());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            StructField ff = (StructField)some.value();
                            return new StructField(ff.name(), MODULE$.addMissingFields(f.dataType(), ff.dataType()), ff.nullable(), ff.metadata());
                        }
                        if (None$.MODULE$.equals(option)) {
                            return f;
                        }
                        throw new MatchError((Object)option);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        return fileType;
    }

    public UnsafeProjection generateUnsafeProjection(Seq<Attribute> fullSchema, Option<String> timeZoneId, java.util.Map<Integer, Pair<DataType, DataType>> typeChangeInfos, StructType requiredSchema, StructType partitionSchema, HoodieSchemaUtils schemaUtils) {
        if (typeChangeInfos.isEmpty()) {
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate(fullSchema, fullSchema);
        }
        StructType newSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i))) {
                    return new StructField(f.name(), (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight(), f.nullable(), f.metadata());
                }
                return f;
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Seq newFullSchema = (Seq)schemaUtils.toAttributes(newSchema).$plus$plus(schemaUtils.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
        Seq castSchema = (Seq)((TraversableLike)newFullSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i))) {
                    DataType dstType;
                    DataType srcType = (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight();
                    boolean needTimeZone = Cast$.MODULE$.needsTimeZone(srcType, dstType = (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getLeft());
                    return new Cast((Expression)attr, dstType, (Option)(needTimeZone ? timeZoneId : None$.MODULE$), Cast$.MODULE$.apply$default$4());
                }
                return attr;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)castSchema, newFullSchema);
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$3(String[] commonFieldNames$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$4(StructField x$3, StructField x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.name())).$less((Object)x$4.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$5(String[] commonFieldNames$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$6(StructField x$5, StructField x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.name())).$less((Object)x$6.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField requiredField = (StructField)tuple2._1();
            StructField fileFilteredField = (StructField)tuple2._2();
            return MODULE$.isDataTypeEqual(requiredField.dataType(), fileFilteredField.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    private HoodieParquetFileFormatHelper$() {
        MODULE$ = this;
    }
}

