/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class HoodieSqlCommonUtils$
implements SparkAdapterSupport {
    public static HoodieSqlCommonUtils$ MODULE$;
    private Set<String> metaFields;
    private final ThreadLocal<SimpleDateFormat> defaultDateFormat;
    private SparkAdapter sparkAdapter;
    private volatile byte bitmap$0;

    static {
        new HoodieSqlCommonUtils$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSqlCommonUtils$ hoodieSqlCommonUtils$ = this;
        synchronized (hoodieSqlCommonUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private ThreadLocal<SimpleDateFormat> defaultDateFormat() {
        return this.defaultDateFormat;
    }

    public Option<StructType> getTableSqlSchema(HoodieTableMetaClient metaClient, boolean includeMetadataFields) {
        Some some;
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        try {
            some = new Some((Object)schemaResolver.getTableAvroSchema(includeMetadataFields));
        }
        catch (Throwable throwable) {
            some = None$.MODULE$;
        }
        Some avroSchema2 = some;
        return avroSchema2.map((Function1 & Serializable & scala.Serializable)avroSchema -> AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType((Schema)avroSchema));
    }

    public boolean getTableSqlSchema$default$2() {
        return false;
    }

    public Seq<String> getAllPartitionPaths(SparkSession spark, CatalogTable table, HoodieStorage storage) {
        HoodieSparkEngineContext sparkEngine = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        TypedProperties properties = TypedProperties.fromMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)spark.sessionState().conf().getAllConfs().$plus$plus((GenTraversableOnce)table.storage().properties()).$plus$plus((GenTraversableOnce)table.properties())).asJava());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(FSUtils.getAllPartitionPaths((HoodieEngineContext)sparkEngine, storage, metadataConfig, this.getTableLocation(table, spark))).asScala()).toSeq();
    }

    public scala.collection.immutable.Map<String, Seq<StoragePathInfo>> getFilesInPartitions(SparkSession spark, CatalogTable table, HoodieStorage storage, Seq<String> partitionPaths) {
        HoodieSparkEngineContext sparkEngine = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        TypedProperties properties = TypedProperties.fromMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)spark.sessionState().conf().getAllConfs().$plus$plus((GenTraversableOnce)table.storage().properties()).$plus$plus((GenTraversableOnce)table.properties())).asJava());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(FSUtils.getFilesInPartitions(sparkEngine, storage, metadataConfig, this.getTableLocation(table, spark), (String[])partitionPaths.toArray(ClassTag$.MODULE$.apply(String.class)))).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e._1(), (Object)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)e._2()).asScala()).toSeq()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isHiveStyledPartitioning(Seq<String> partitionPaths, CatalogTable table) {
        if (table.partitionColumnNames().nonEmpty()) {
            Function1 & Serializable & scala.Serializable isHiveStylePartitionPath = (Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.$anonfun$isHiveStyledPartitioning$1(table, path));
            return partitionPaths.forall((Function1)isHiveStylePartitionPath);
        }
        return true;
    }

    public boolean isUrlEncodeEnabled(Seq<String> partitionPaths, CatalogTable table) {
        if (table.partitionColumnNames().nonEmpty()) {
            return partitionPaths.forall((Function1 & Serializable & scala.Serializable)partitionPath -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.$anonfun$isUrlEncodeEnabled$1(table, partitionPath)));
        }
        return false;
    }

    public StructType addMetaFields(StructType schema) {
        Buffer metaFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala();
        StructField[] dataFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)metaFields.contains((Object)f.name())));
        Buffer fields = ((BufferLike)metaFields.map((Function1 & Serializable & scala.Serializable)x$1 -> new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFields)));
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    private Set<String> metaFields$lzycompute() {
        HoodieSqlCommonUtils$ hoodieSqlCommonUtils$ = this;
        synchronized (hoodieSqlCommonUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metaFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metaFields;
    }

    private Set<String> metaFields() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metaFields$lzycompute();
        }
        return this.metaFields;
    }

    public StructType removeMetaFields(StructType schema) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.MODULE$.isMetaField(f.name()))));
    }

    public boolean isMetaField(String name) {
        return this.metaFields().contains((Object)name);
    }

    public <T extends Attribute> Seq<T> removeMetaFields(Seq<T> attrs) {
        return (Seq)attrs.filterNot((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.MODULE$.isMetaField(attr.name())));
    }

    public String getTableLocation(TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return this.getTableLocation(table, spark);
    }

    public String getTableLocation(scala.collection.immutable.Map<String, String> properties, TableIdentifier identifier, SparkSession sparkSession) {
        Some location = new Some(properties.getOrElse((Object)"location", (Function0 & Serializable & scala.Serializable)() -> ""));
        boolean isManaged = location.isEmpty() || ((String)location.get()).isEmpty();
        Some uri2 = isManaged ? new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(identifier)) : new Some((Object)new StoragePath((String)location.get()).toUri());
        return this.getTableLocation((Option<URI>)uri2, identifier, sparkSession);
    }

    public String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        Option uri2 = table.storage().locationUri().orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(table.identifier())));
        return this.getTableLocation((Option<URI>)uri2, table.identifier(), sparkSession);
    }

    public String getTableLocation(Option<URI> uri2, TableIdentifier identifier, SparkSession sparkSession) {
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return (String)uri2.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.makePathQualified((URI)x$2, conf)).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.removePlaceHolder((String)path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(21).append("Missing location for ").append(identifier).toString());
        });
    }

    private String removePlaceHolder(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path.endsWith("-__PLACEHOLDER__")) {
            return path.substring(0, path.length() - 16);
        }
        return path;
    }

    public String makePathQualified(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri().toString();
    }

    public boolean tableExistsInPath(String tablePath, HoodieStorage storage) {
        StoragePath basePath = new StoragePath(tablePath);
        StoragePath metaPath = new StoragePath(basePath, ".hoodie");
        return storage.exists(metaPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHoodieConfigKey(String key, String commitMetadataKeyPrefix) {
        if (key.startsWith("hoodie.")) return true;
        if (key.startsWith(commitMetadataKeyPrefix)) return true;
        String string = key;
        String string2 = DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public scala.collection.immutable.Map<String, String> filterHoodieConfigs(scala.collection.immutable.Map<String, String> opts) {
        return opts.filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.MODULE$.isHoodieConfigKey(x$3, (String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().defaultValue())))).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isUsingHiveCatalog(SparkSession sparkSession) {
        Object object = sparkSession.sessionState().conf().getConf(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
        String string = "hive";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public String formatQueryInstant(String queryInstant) {
        int instantLength = queryInstant.length();
        if (instantLength == 19 || instantLength == 23) {
            return HoodieInstantTimeGenerator.getInstantForDateString(queryInstant);
        }
        if (instantLength == HoodieInstantTimeGenerator.SECS_INSTANT_ID_LENGTH || instantLength == HoodieInstantTimeGenerator.MILLIS_INSTANT_ID_LENGTH) {
            this.validateInstant(queryInstant);
            return queryInstant;
        }
        if (instantLength == 10) {
            return TimelineUtils.formatDate(((DateFormat)this.defaultDateFormat().get()).parse(queryInstant));
        }
        throw new IllegalArgumentException(new StringBuilder(132).append("Unsupported query instant time format: ").append(queryInstant).append(",").append("Supported time format are: 'yyyy-MM-dd: HH:mm:ss.SSS' or 'yyyy-MM-dd' or 'yyyyMMddHHmmssSSS'").toString());
    }

    public String formatName(SparkSession sparkSession, String name) {
        if (sparkSession.sessionState().conf().caseSensitiveAnalysis()) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public boolean isEmptyPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        if (fs.exists(basePath)) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(basePath))).isEmpty();
        }
        return true;
    }

    public Option<StructField> findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).collectFirst((PartialFunction)new scala.Serializable(resolver2, name){
            public static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String name$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1))) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
            }
            {
                this.resolver$1 = resolver$1;
                this.name$1 = name$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver2) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver2.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public Expression castIfNeeded(Expression child, DataType dataType) {
        Expression expression = child;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object nul = literal.value();
            DataType dataType2 = literal.dataType();
            if (NullType$.MODULE$.equals(dataType2)) {
                return new Literal(nul, dataType);
            }
        }
        DataType dataType3 = child.dataType();
        DataType dataType4 = dataType;
        if (dataType3 == null ? dataType4 != null : !dataType3.equals(dataType4)) {
            return new Cast(expression, dataType, Option$.MODULE$.apply((Object)SQLConf$.MODULE$.get().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
        }
        return child;
    }

    public <T> scala.collection.immutable.Map<String, T> normalizePartitionSpec(scala.collection.immutable.Map<String, T> partitionSpec, Seq<String> partColNames, String tblName, Function2<String, String, Object> resolver2) {
        Seq normalizedPartSpec = (Seq)partitionSpec.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                String normalizedKey = (String)partColNames.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.$anonfun$normalizePartitionSpec$2(resolver2, key, x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new AnalysisException(new StringBuilder(43).append(key).append(" is not a valid partition column in table ").append(tblName).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)normalizedKey), value);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        if (normalizedPartSpec.size() < partColNames.size()) {
            throw new AnalysisException("All partition columns need to be specified for Hoodie's partition", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        Seq lowerPartColNames = (Seq)partColNames.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(), Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)lowerPartColNames.distinct()).length() != lowerPartColNames.length()) {
            Iterable duplicateColumns = (Iterable)lowerPartColNames.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            return (B1)new StringBuilder(2).append("`").append(x).append("`").toString();
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringBuilder(51).append("Found duplicate column(s) in the partition schema: ").append(duplicateColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        return normalizedPartSpec.toMap(Predef$.MODULE$.$conforms());
    }

    public String getPartitionPathToDrop(HoodieCatalogTable hoodieCatalogTable, Seq<scala.collection.immutable.Map<String, String>> normalizedSpecs) {
        return ((TraversableOnce)normalizedSpecs.map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.makePartitionPath(hoodieCatalogTable, (scala.collection.immutable.Map<String, String>)x$6), Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private String makePartitionPath(Seq<String> partitionFields, scala.collection.immutable.Map<String, String> normalizedSpecs, boolean enableEncodeUrl, boolean enableHiveStylePartitioning) {
        return ((TraversableOnce)partitionFields.map((Function1 & Serializable & scala.Serializable)partitionColumn -> {
            String encodedPartitionValue;
            String string = encodedPartitionValue = enableEncodeUrl ? PartitionPathEncodeUtils.escapePathName((String)normalizedSpecs.apply(partitionColumn)) : (String)normalizedSpecs.apply(partitionColumn);
            if (enableHiveStylePartitioning) {
                return new StringBuilder(1).append((String)partitionColumn).append("=").append(encodedPartitionValue).toString();
            }
            return encodedPartitionValue;
        }, Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public String makePartitionPath(HoodieCatalogTable hoodieCatalogTable, scala.collection.immutable.Map<String, String> normalizedSpecs) {
        HoodieTableConfig tableConfig = hoodieCatalogTable.tableConfig();
        boolean enableHiveStylePartitioning = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        boolean enableEncodeUrl = Boolean.parseBoolean(tableConfig.getUrlEncodePartitioning());
        return this.makePartitionPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])hoodieCatalogTable.partitionFields()), normalizedSpecs, enableEncodeUrl, enableHiveStylePartitioning);
    }

    private void validateInstant(String queryInstant) {
        boolean valid;
        String string = queryInstant;
        boolean bl = valid = ("00000000000000".equals(string) ? true : ("00000000000001".equals(string) ? true : "00000000000002".equals(string))) ? true : Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimelineUtils.parseDateFromInstantTime(queryInstant)).isSuccess();
        if (!valid) {
            throw new HoodieException(new StringBuilder(25).append("Got an invalid instant (").append(queryInstant).append(")").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isHiveStyledPartitioning$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String pathFragment = (String)tuple2._1();
            String partitionColumn = (String)tuple2._2();
            return pathFragment.startsWith(new StringBuilder(1).append(partitionColumn).append("=").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isHiveStyledPartitioning$1(CatalogTable table$1, String path) {
        String[] fragments = path.split("/");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fragments)).size() != table$1.partitionColumnNames().size()) {
            return false;
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fragments)).zip((GenIterable)table$1.partitionColumnNames(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.$anonfun$isHiveStyledPartitioning$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isUrlEncodeEnabled$1(CatalogTable table$2, String partitionPath) {
        return partitionPath.split("/").length == table$2.partitionColumnNames().size();
    }

    public static final /* synthetic */ boolean $anonfun$normalizePartitionSpec$2(Function2 resolver$2, String key$1, String x$4) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)x$4, (Object)key$1));
    }

    private HoodieSqlCommonUtils$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
        this.defaultDateFormat = ThreadLocal.withInitial(new Supplier<SimpleDateFormat>(){

            public SimpleDateFormat get() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        });
    }
}

