/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.utils.SparkInternalSchemaConverter;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.command.AlterTableCommand;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class AlterTableCommand$
implements Logging,
scala.Serializable {
    public static AlterTableCommand$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AlterTableCommand$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void commitWithSchema(InternalSchema internalSchema, String historySchemaStr, CatalogTable table, SparkSession sparkSession) {
        Schema schema = AvroInternalSchemaConverter.convert(internalSchema, AvroSchemaUtils.getAvroRecordQualifiedName(table.identifier().table()));
        String path = this.getTableLocation(table, sparkSession);
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        SparkRDDWriteClient client = DataSourceUtils.createHoodieClient(jsc, schema.toString(), path, table.identifier().table(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)HoodieOptionConfig$.MODULE$.mapSqlOptionsToDataSourceWriteConfigs((scala.collection.immutable.Map<String, String>)table.storage().properties().$plus$plus((GenTraversableOnce)table.properties())).$plus$plus((GenTraversableOnce)sparkSession.sqlContext().conf().getAllConfs()))).asJava());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(path).setConf(HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf())).setTimeGeneratorConfig(client.getConfig().getTimeGeneratorConfig()).build();
        String commitActionType = CommitUtils.getCommitActionType(WriteOperationType.ALTER_SCHEMA, metaClient.getTableType());
        String instantTime = client.createNewInstantTime();
        client.startCommitWithTime(instantTime, commitActionType);
        client.setOperationType(WriteOperationType.ALTER_SCHEMA);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create(client.getConfig(), client.getEngineContext());
        HoodieActiveTimeline timeLine = hoodieTable.getActiveTimeline();
        InstantGenerator instantGenerator = metaClient.getTimelineLayout().getInstantGenerator();
        HoodieInstant requested = instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
        timeLine.transitionRequestedToInflight(requested, TimelineMetadataUtils.serializeCommitMetadata(metaClient.getTimelineLayout().getCommitMetadataSerDe(), metadata));
        HashMap<String, String> extraMeta = new HashMap<String, String>();
        extraMeta.put("latest_schema", SerDeHelper.toJson(internalSchema.setSchemaId(new StringOps(Predef$.MODULE$.augmentString(instantTime)).toLong())));
        FileBasedInternalSchemaStorageManager schemaManager = new FileBasedInternalSchemaStorageManager(metaClient);
        schemaManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas(internalSchema, historySchemaStr));
        client.commit(instantTime, jsc.emptyRDD(), org.apache.hudi.common.util.Option.of(extraMeta));
        boolean existRoTable = sparkSession.catalog().tableExists(new StringBuilder(3).append(table.identifier().unquotedString()).append("_ro").toString());
        boolean existRtTable = sparkSession.catalog().tableExists(new StringBuilder(3).append(table.identifier().unquotedString()).append("_rt").toString());
        try {
            sparkSession.catalog().refreshTable(table.identifier().unquotedString());
            if (existRoTable) {
                sparkSession.catalog().refreshTable(new StringBuilder(3).append(table.identifier().unquotedString()).append("_ro").toString());
            }
            if (existRoTable) {
                sparkSession.catalog().refreshTable(new StringBuilder(3).append(table.identifier().unquotedString()).append("_rt").toString());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log().error(new StringBuilder(43).append("Exception when attempting to refresh table ").append(table.identifier().quotedString()).toString(), e);
            }
            throw throwable;
        }
        StructType fullSparkSchema = SparkInternalSchemaConverter.constructSparkSchemaFromInternalSchema(internalSchema);
        StructType dataSparkSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullSparkSchema.fields())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand$.$anonfun$commitWithSchema$1(table, sparkSession, p))));
        this.alterTableDataSchema(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), table.identifier().table(), dataSparkSchema);
        if (existRoTable) {
            this.alterTableDataSchema(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), new StringBuilder(3).append(table.identifier().table()).append("_ro").toString(), dataSparkSchema);
        }
        if (existRtTable) {
            this.alterTableDataSchema(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), new StringBuilder(3).append(table.identifier().table()).append("_rt").toString(), dataSparkSchema);
            return;
        }
    }

    public void alterTableDataSchema(SparkSession sparkSession, String db, String tableName, StructType dataSparkSchema) {
        sparkSession.sessionState().catalog().externalCatalog().alterTableDataSchema(db, tableName, dataSparkSchema);
    }

    public String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        Some uri2 = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) ? new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(table.identifier())) : table.storage().locationUri();
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return (String)uri2.map((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.makePathQualified((URI)x$17, conf)).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.removePlaceHolder((String)path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(21).append("Missing location for ").append(table.identifier()).toString());
        });
    }

    private String removePlaceHolder(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path.endsWith("-PLACEHOLDER")) {
            return path.substring(0, path.length() - 16);
        }
        return path;
    }

    public String makePathQualified(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri().toString();
    }

    public String getParentName(String[] names) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).size() > 1) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).dropRight(1))).mkString(".");
        }
        return "";
    }

    public AlterTableCommand apply(CatalogTable table, Seq<TableChange> changes, TableChange.ColumnChangeID changeType) {
        return new AlterTableCommand(table, changes, changeType);
    }

    public Option<Tuple3<CatalogTable, Seq<TableChange>, TableChange.ColumnChangeID>> unapply(AlterTableCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.table(), x$0.changes(), (Object)x$0.changeType()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$commitWithSchema$2(SparkSession sparkSession$1, StructField p$1, String f) {
        return BoxesRunTime.unboxToBoolean((Object)sparkSession$1.sessionState().conf().resolver().apply((Object)f, (Object)p$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$commitWithSchema$1(CatalogTable table$1, SparkSession sparkSession$1, StructField p) {
        return !table$1.partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AlterTableCommand$.$anonfun$commitWithSchema$2(sparkSession$1, p, f)));
    }

    private AlterTableCommand$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

