/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.hudi.HoodieSparkIndexClient;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.command.CreateIndexCommand$;
import org.apache.spark.sql.hudi.command.IndexBaseCommand;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0012%\u0001FB\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u0003\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005X\u0001\tE\t\u0015!\u0003M\u0011!A\u0006A!f\u0001\n\u0003Y\u0005\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u0011i\u0003!Q3A\u0005\u0002mC\u0001b\u0018\u0001\u0003\u0012\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011)\u001a!C\u0001C\"A!\u000f\u0001B\tB\u0003%!\r\u0003\u0005t\u0001\tU\r\u0011\"\u0001u\u0011!)\bA!E!\u0002\u0013y\u0007\"\u0002<\u0001\t\u00039\bBB@\u0001\t\u0003\n\t\u0001C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0001\u0002\u001a!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003\u0003B\u0011\"!\u0012\u0001#\u0003%\t!!\u0011\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005%\u0003\"CA'\u0001E\u0005I\u0011AA(\u0011%\t\u0019\u0006AI\u0001\n\u0003\t)\u0006C\u0005\u0002Z\u0001\t\t\u0011\"\u0011\u0002\\!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003k\u0002\u0011\u0011!C\u0001\u0003oB\u0011\"a!\u0001\u0003\u0003%\t%!\"\t\u0013\u0005M\u0005!!A\u0005\u0002\u0005U\u0005\"CAM\u0001\u0005\u0005I\u0011IAN\u000f\u001d\ty\n\nE\u0001\u0003C3aa\t\u0013\t\u0002\u0005\r\u0006B\u0002<\u001e\t\u0003\tY\u000bC\u0004\u0002.v!\t!a,\t\u0013\u0005=W$!A\u0005\u0002\u0006E\u0007\"CAp;\u0005\u0005I\u0011QAq\u0011%\t\u00190HA\u0001\n\u0013\t)P\u0001\nDe\u0016\fG/Z%oI\u0016D8i\\7nC:$'BA\u0013'\u0003\u001d\u0019w.\\7b]\u0012T!a\n\u0015\u0002\t!,H-\u001b\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0005\u0001I2D\b\u0005\u00024i5\tA%\u0003\u00026I\t\u0001\u0012J\u001c3fq\n\u000b7/Z\"p[6\fg\u000e\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\t9T(\u0003\u0002?q\ta1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u000691-\u0019;bY><'B\u0001$)\u0003!\u0019\u0017\r^1msN$\u0018B\u0001%D\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005I\u0011N\u001c3fq:\u000bW.Z\u000b\u0002\u0019B\u0011Q\n\u0016\b\u0003\u001dJ\u0003\"a\u0014\u001d\u000e\u0003AS!!\u0015\u0019\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0006(\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*9\u0003)Ig\u000eZ3y\u001d\u0006lW\rI\u0001\nS:$W\r\u001f+za\u0016\f!\"\u001b8eKb$\u0016\u0010]3!\u00039IwM\\8sK&3W\t_5tiN,\u0012\u0001\u0018\t\u0003ouK!A\u0018\u001d\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001c\b%A\u0004d_2,XN\\:\u0016\u0003\t\u00042a\u00195l\u001d\t!gM\u0004\u0002PK&\t\u0011(\u0003\u0002hq\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005\r\u0019V-\u001d\u0006\u0003Ob\u0002Ba\u000e7o_&\u0011Q\u000e\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\rDG\n\u0005\u0003Na2c\u0015BA9W\u0005\ri\u0015\r]\u0001\tG>dW/\u001c8tA\u00059q\u000e\u001d;j_:\u001cX#A8\u0002\u0011=\u0004H/[8og\u0002\na\u0001P5oSRtDc\u0002=zundXP \t\u0003g\u0001AQaP\u0007A\u0002\u0005CQAS\u0007A\u00021CQ\u0001W\u0007A\u00021CQAW\u0007A\u0002qCQ\u0001Y\u0007A\u0002\tDQa]\u0007A\u0002=\f1A];o)\u0011\t\u0019!!\u0004\u0011\t\rD\u0017Q\u0001\t\u0005\u0003\u000f\tI!D\u0001)\u0013\r\tY\u0001\u000b\u0002\u0004%><\bbBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003\u000f\t\u0019\"C\u0002\u0002\u0016!\u0012Ab\u00159be.\u001cVm]:j_:\fAaY8qsRi\u00010a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003KAqaP\b\u0011\u0002\u0003\u0007\u0011\tC\u0004K\u001fA\u0005\t\u0019\u0001'\t\u000fa{\u0001\u0013!a\u0001\u0019\"9!l\u0004I\u0001\u0002\u0004a\u0006b\u00021\u0010!\u0003\u0005\rA\u0019\u0005\bg>\u0001\n\u00111\u0001p\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000b+\u0007\u0005\u000bic\u000b\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C;oG\",7m[3e\u0015\r\tI\u0004O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001f\u0003g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0011+\u00071\u000bi#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\n\u0016\u00049\u00065\u0012AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003#R3AYA\u0017\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"!a\u0016+\u0007=\fi#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0003mC:<'BAA4\u0003\u0011Q\u0017M^1\n\u0007U\u000b\t'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002pA\u0019q'!\u001d\n\u0007\u0005M\u0004HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002z\u0005}\u0004cA\u001c\u0002|%\u0019\u0011Q\u0010\u001d\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0002b\t\t\u00111\u0001\u0002p\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\"\u0011\r\u0005%\u0015qRA=\u001b\t\tYIC\u0002\u0002\u000eb\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t*a#\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00049\u0006]\u0005\"CAA5\u0005\u0005\t\u0019AA=\u0003\u0019)\u0017/^1mgR\u0019A,!(\t\u0013\u0005\u00055$!AA\u0002\u0005e\u0014AE\"sK\u0006$X-\u00138eKb\u001cu.\\7b]\u0012\u0004\"aM\u000f\u0014\tu\t)\u000b\u0010\t\u0004o\u0005\u001d\u0016bAAUq\t1\u0011I\\=SK\u001a$\"!!)\u0002#5\fGo\u00195fgJ+7m\u001c:e\u0017\u0016L8\u000fF\u0003]\u0003c\u000bY\fC\u0004\u00024~\u0001\r!!.\u0002\u0017\r|G.^7o\u001d\u0006lWm\u001d\t\u0005\u001b\u0006]F*C\u0002\u0002:Z\u00131aU3u\u0011\u001d\til\ba\u0001\u0003\u007f\u000b1\u0002^1cY\u0016\u001cuN\u001c4jOB!\u0011\u0011YAf\u001b\t\t\u0019MC\u0002@\u0003\u000bTA!a2\u0002J\u000611m\\7n_:T!a\n\u0017\n\t\u00055\u00171\u0019\u0002\u0012\u0011>|G-[3UC\ndWmQ8oM&<\u0017!B1qa2LH#\u0004=\u0002T\u0006U\u0017q[Am\u00037\fi\u000eC\u0003@A\u0001\u0007\u0011\tC\u0003KA\u0001\u0007A\nC\u0003YA\u0001\u0007A\nC\u0003[A\u0001\u0007A\fC\u0003aA\u0001\u0007!\rC\u0003tA\u0001\u0007q.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0018q\u001e\t\u0006o\u0005\u0015\u0018\u0011^\u0005\u0004\u0003OD$AB(qi&|g\u000eE\u00058\u0003W\fE\n\u0014/c_&\u0019\u0011Q\u001e\u001d\u0003\rQ+\b\u000f\\37\u0011!\t\t0IA\u0001\u0002\u0004A\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u0010\u0005\u0003\u0002`\u0005e\u0018\u0002BA~\u0003C\u0012aa\u00142kK\u000e$\b")
public class CreateIndexCommand
extends IndexBaseCommand
implements scala.Serializable {
    private final CatalogTable table;
    private final String indexName;
    private final String indexType;
    private final boolean ignoreIfExists;
    private final Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns;
    private final scala.collection.immutable.Map<String, String> options;

    public static Option<Tuple6<CatalogTable, String, String, Object, Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>>, scala.collection.immutable.Map<String, String>>> unapply(CreateIndexCommand createIndexCommand) {
        return CreateIndexCommand$.MODULE$.unapply(createIndexCommand);
    }

    public static boolean matchesRecordKeys(Set<String> set, HoodieTableConfig hoodieTableConfig) {
        return CreateIndexCommand$.MODULE$.matchesRecordKeys(set, hoodieTableConfig);
    }

    public CatalogTable table() {
        return this.table;
    }

    public String indexName() {
        return this.indexName;
    }

    public String indexType() {
        return this.indexType;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    public Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns() {
        return this.columns;
    }

    public scala.collection.immutable.Map<String, String> options() {
        return this.options;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        TableIdentifier tableId = this.table().identifier();
        HoodieTableMetaClient metaClient = this.createHoodieTableMetaClient(tableId, sparkSession);
        LinkedHashMap<String, java.util.Map<String, String>> columnsMap = new LinkedHashMap<String, java.util.Map<String, String>>();
        this.columns().map((Function1 & Serializable & scala.Serializable)c -> (java.util.Map)columnsMap.put(((TraversableOnce)c._1()).mkString("."), (java.util.Map<String, String>)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)c._2()).asJava()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map extraOpts = this.options().$plus$plus((GenTraversableOnce)this.table().properties());
        if (this.indexType().equals("column_stats") || this.indexType().equals("bloom_filters")) {
            if (this.indexType().equals("column_stats") && ((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava()).getOrDefault("expr", "identity").equals("identity")) {
                throw new HoodieIndexException("Column stats index without expression on any column can be created using datasource configs. Please refer https://hudi.apache.org/docs/metadata for more info");
            }
            new HoodieSparkIndexClient(sparkSession).create(metaClient, this.indexName(), this.indexType(), columnsMap, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava());
        } else if (this.indexName().equals("record_index")) {
            ValidationUtils.checkArgument(CreateIndexCommand$.MODULE$.matchesRecordKeys((Set<String>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(columnsMap.keySet()).asScala()).toSet(), metaClient.getTableConfig()), new StringBuilder(58).append("Input columns should match configured record key columns: ").append(metaClient.getTableConfig().getRecordKeyFieldProp()).toString());
            new HoodieSparkIndexClient(sparkSession).create(metaClient, this.indexName(), "record_index", columnsMap, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava());
        } else if (StringUtils.isNullOrEmpty(this.indexType())) {
            String derivedIndexType;
            Set columnNames = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(columnsMap.keySet()).asScala()).toSet();
            String string = derivedIndexType = CreateIndexCommand$.MODULE$.matchesRecordKeys((Set<String>)columnNames, metaClient.getTableConfig()) ? "record_index" : "secondary_index";
            if (derivedIndexType.equals("secondary_index") && (metaClient.getTableConfig().getPayloadClass() != null && !metaClient.getTableConfig().getPayloadClass().equals(OverwriteWithLatestAvroPayload.class.getCanonicalName()) || metaClient.getTableConfig().getRecordMergeMode() != RecordMergeMode.COMMIT_TIME_ORDERING)) {
                throw new HoodieIndexException("Secondary Index can only be enabled on table with OverwriteWithLatestAvroPayload payload class or Merge mode set to OVERWRITE_WITH_LATEST");
            }
            new HoodieSparkIndexClient(sparkSession).create(metaClient, this.indexName(), derivedIndexType, columnsMap, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraOpts).asJava());
        } else {
            throw new HoodieIndexException(String.format("%s is not supported", this.indexType()));
        }
        sparkSession.sessionState().catalog().invalidateCachedTable(tableId);
        return (Seq)Nil$.MODULE$;
    }

    public CreateIndexCommand copy(CatalogTable table, String indexName, String indexType, boolean ignoreIfExists, Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns, scala.collection.immutable.Map<String, String> options) {
        return new CreateIndexCommand(table, indexName, indexType, ignoreIfExists, columns, options);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.indexName();
    }

    public String copy$default$3() {
        return this.indexType();
    }

    public boolean copy$default$4() {
        return this.ignoreIfExists();
    }

    public Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> copy$default$5() {
        return this.columns();
    }

    public scala.collection.immutable.Map<String, String> copy$default$6() {
        return this.options();
    }

    public String productPrefix() {
        return "CreateIndexCommand";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.indexName();
            }
            case 2: {
                return this.indexType();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
            }
            case 4: {
                return this.columns();
            }
            case 5: {
                return this.options();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateIndexCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateIndexCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateIndexCommand createIndexCommand = (CreateIndexCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createIndexCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        String string = this.indexName();
        String string2 = createIndexCommand.indexName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.indexType();
        String string4 = createIndexCommand.indexType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.ignoreIfExists() != createIndexCommand.ignoreIfExists()) return false;
        Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> seq = this.columns();
        Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> seq2 = createIndexCommand.columns();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        scala.collection.immutable.Map<String, String> map = this.options();
        scala.collection.immutable.Map<String, String> map2 = createIndexCommand.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!createIndexCommand.canEqual(this)) return false;
        return true;
    }

    public CreateIndexCommand(CatalogTable table, String indexName, String indexType, boolean ignoreIfExists, Seq<Tuple2<Seq<String>, scala.collection.immutable.Map<String, String>>> columns, scala.collection.immutable.Map<String, String> options) {
        this.table = table;
        this.indexName = indexName;
        this.indexType = indexType;
        this.ignoreIfExists = ignoreIfExists;
        this.columns = columns;
        this.options = options;
    }
}

