/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.avro.AvroRuntimeException;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RepairCorruptedCleanFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qO\u0001\u0012SKB\f\u0017N]\"peJ,\b\u000f^3e\u00072,\u0017M\u001c$jY\u0016\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003%M\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t!R#A\u0004d_6l\u0017M\u001c3\u000b\u0005Y9\u0012\u0001\u00025vI&T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0011&QA\u0011!eI\u0007\u0002#%\u0011A%\u0005\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005\t2\u0013BA\u0014\u0012\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'\u000f\u0005\u0002*Y5\t!F\u0003\u0002,3\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00011!\t\u0011\u0003!\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012a\r\t\u0004i]JT\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\tR\u0014BA\u001e\u0012\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000bI\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011u#A\u0003usB,7/\u0003\u0002E\u0003\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011!J\u0017\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tyu$\u0001\u0004=e>|GOP\u0005\u0002m%\u0011!+N\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0002TKFT!AU\u001b\u0011\u0005]CV\"A\f\n\u0005e;\"a\u0001*po\")1\f\u0003a\u00019\u0006!\u0011M]4t!\t\u0011S,\u0003\u0002_#\ti\u0001K]8dK\u0012,(/Z!sON\fQAY;jY\u0012,\u0012!\u0019\t\u0003E\tL!aY\t\u0003\u0013A\u0013xnY3ekJ,\u0017A\t*fa\u0006L'oQ8seV\u0004H/\u001a3DY\u0016\fgNR5mKN\u0004&o\\2fIV\u0014X\r\u0005\u0002#\u0017M\u00111b\u001a\t\u0003i!L!![\u001b\u0003\r\u0005s\u0017PU3g)\u0005)\u0017\u0001\u0002(B\u001b\u0016+\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fA\u0001\\1oO*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0019\u0019FO]5oO\u0006)a*Q'FA\u00059!-^5mI\u0016\u0014X#\u0001=\u0011\u0007etX%D\u0001{\u0015\tYH0\u0001\u0005gk:\u001cG/[8o\u0015\ti\u0018/\u0001\u0003vi&d\u0017BA@{\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class RepairCorruptedCleanFilesProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RepairCorruptedCleanFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RepairCorruptedCleanFilesProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String tablePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), tablePath);
        InstantFileNameGenerator instantFileNameGenerator = metaClient.getTimelineLayout().getInstantFileNameGenerator();
        HoodieTimeline cleanerTimeline = metaClient.getActiveTimeline().getCleanerTimeline();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Inspecting pending clean metadata in timeline for corrupted files");
        BooleanRef result = BooleanRef.create((boolean)true);
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(cleanerTimeline.filterInflightsAndRequested().getInstants().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)instant -> {
            HoodieCleanerPlan hoodieCleanerPlan;
            try {
                hoodieCleanerPlan = CleanerUtils.getCleanerPlan(metaClient, instant);
            }
            catch (AvroRuntimeException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Corruption found. Trying to remove corrupted clean instant file: ").append(instant).toString());
                TimelineUtils.deleteInstantFile(metaClient.getStorage(), metaClient.getTimelinePath(), instant, instantFileNameGenerator);
                hoodieCleanerPlan = BoxedUnit.UNIT;
            }
            catch (IOException ioe) {
                if (ioe.getMessage().contains("Not an Avro data file")) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Corruption found. Trying to remove corrupted clean instant file: ").append(instant).toString());
                    TimelineUtils.deleteInstantFile(metaClient.getStorage(), metaClient.getTimelinePath(), instant, instantFileNameGenerator);
                    hoodieCleanerPlan = BoxedUnit.UNIT;
                }
                result$1.elem = false;
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
            return hoodieCleanerPlan;
        });
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result.elem)})), (List)Nil$.MODULE$);
    }

    @Override
    public Procedure build() {
        return new RepairCorruptedCleanFilesProcedure();
    }

    public RepairCorruptedCleanFilesProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

