/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.Serializable;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.IncrementalRelationV2;
import org.apache.hudi.MergeOnReadIncrementalRelationV2;
import org.apache.hudi.MergeOnReadIncrementalRelationV2$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.cdc.CDCRelation$;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.cdc.HoodieCDCUtils;
import org.apache.hudi.common.table.checkpoint.CheckpointUtils;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.streaming.HoodieEarliestOffsetRangeLimit$;
import org.apache.spark.sql.hudi.streaming.HoodieLatestOffsetRangeLimit$;
import org.apache.spark.sql.hudi.streaming.HoodieMetadataLog;
import org.apache.spark.sql.hudi.streaming.HoodieOffsetRangeLimit;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import org.apache.spark.sql.hudi.streaming.HoodieSpecifiedOffsetRangeLimit;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u000b\u0016\u0001\tB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!9\u0007A!A!\u0002\u0013A\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011A\u0004!\u0011!Q\u0001\nEDQ\u0001\u001e\u0001\u0005\u0002UD\u0001B \u0001\t\u0006\u0004%Ia \u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0003\u0005\u000b\u00033\u0001\u0001R1A\u0005\n\u0005m\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u00111\u0015\u0001\u0005B\u0005\u0015&\u0001\u0006%p_\u0012LWm\u0015;sK\u0006l7k\\;sG\u00164&G\u0003\u0002\u0017/\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00031e\tA\u0001[;eS*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M1\u0001aI\u00163qy\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004PE*,7\r\u001e\t\u0003YAj\u0011!\f\u0006\u0003-9R!aL\r\u0002\u0013\u0015DXmY;uS>t\u0017BA\u0019.\u0005\u0019\u0019v.\u001e:dKB\u00111GN\u0007\u0002i)\u0011QgG\u0001\tS:$XM\u001d8bY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u00051\u0019VM]5bY&T\u0018M\u00197f!\ty\u0014)D\u0001A\u0015\tAR$\u0003\u0002C\u0001\n\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8si\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u0005\u00153U\"A\r\n\u0005\u001dK\"AC*R\u0019\u000e{g\u000e^3yi\u0006QQ.\u001a;b\u00072LWM\u001c;\u0011\u0005){U\"A&\u000b\u00051k\u0015!\u0002;bE2,'B\u0001(A\u0003\u0019\u0019w.\\7p]&\u0011\u0001k\u0013\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u00031iW\r^1eCR\f\u0007+\u0019;i!\t\u0019&L\u0004\u0002U1B\u0011QKO\u0007\u0002-*\u0011q+I\u0001\u0007yI|w\u000e\u001e \n\u0005eS\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\u001e\u0002\u0019M\u001c\u0007.Z7b\u001fB$\u0018n\u001c8\u0011\u0007ez\u0016-\u0003\u0002au\t1q\n\u001d;j_:\u0004\"AY3\u000e\u0003\rT!\u0001Z\r\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'AC*ueV\u001cG\u000fV=qK\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\tMK'KU\u0005\u0003Ur\u00131!T1q\u0003AygMZ:fiJ\u000bgnZ3MS6LG\u000f\u0005\u0002n]6\tQ#\u0003\u0002p+\t1\u0002j\\8eS\u0016|eMZ:fiJ\u000bgnZ3MS6LG/A\txe&$X\rV1cY\u00164VM]:j_:\u0004\"A\u0013:\n\u0005M\\%A\u0005%p_\u0012LW\rV1cY\u00164VM]:j_:\fa\u0001P5oSRtD\u0003\u0003<xqfT8\u0010`?\u0011\u00055\u0004\u0001\"B\"\t\u0001\u0004!\u0005\"\u0002%\t\u0001\u0004I\u0005\"B)\t\u0001\u0004\u0011\u0006\"B/\t\u0001\u0004q\u0006\"B4\t\u0001\u0004A\u0007\"B6\t\u0001\u0004a\u0007\"\u00029\t\u0001\u0004\t\u0018!\u0003;bE2,G+\u001f9f+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9!T\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u0017\t)AA\bI_>$\u0017.\u001a+bE2,G+\u001f9f\u0003)I7o\u0011#D#V,'/_\u000b\u0003\u0003#\u00012!OA\n\u0013\r\t)B\u000f\u0002\b\u0005>|G.Z1o\u0003-I7o\u0011#D#V,'/\u001f\u0011\u0002\u001d%t\u0017\u000e^5bY>3gm]3ugV\u0011\u0011Q\u0004\t\u0004[\u0006}\u0011bAA\u0011+\t\u0011\u0002j\\8eS\u0016\u001cv.\u001e:dK>3gm]3uQ\ra\u0011Q\u0005\t\u0004s\u0005\u001d\u0012bAA\u0015u\tIAO]1og&,g\u000e^\u0001\u0007g\u000eDW-\\1\u0016\u0003\u0005\fqbZ3u\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^\u000b\u0003\u0003g\u0001B!O0\u0002\u001e\u0005Iq-\u001a;PM\u001a\u001cX\r^\u000b\u0003\u0003s\u0001B!O0\u0002<A\u0019A&!\u0010\n\u0007\u0005}RF\u0001\u0004PM\u001a\u001cX\r^\u0001\tO\u0016$()\u0019;dQR1\u0011QIA2\u0003O\u0002B!a\u0012\u0002^9!\u0011\u0011JA-\u001d\u0011\tY%a\u0016\u000f\t\u00055\u0013Q\u000b\b\u0005\u0003\u001f\n\u0019FD\u0002V\u0003#J\u0011\u0001I\u0005\u0003=}I!\u0001H\u000f\n\u0005iY\u0012bAA.3\u00059\u0001/Y2lC\u001e,\u0017\u0002BA0\u0003C\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005m\u0013\u0004C\u0004\u0002fA\u0001\r!!\u000f\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005%\u0004\u00031\u0001\u0002<\u0005\u0019QM\u001c3\u0002E\u001d,Go\u0015;beR\u001cu.\u001c9mKRLwN\u001c+j[\u0016\fe\u000e\u001a*b]\u001e,G+\u001f9f)\u0011\ty'a&\u0011\re\n\tHUA;\u0013\r\t\u0019H\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005]\u0014\u0011\u0013\b\u0005\u0003s\nYI\u0004\u0003\u0002|\u0005\u001de\u0002BA?\u0003\u000bsA!a \u0002\u0004:!\u0011QJAA\u0013\tAR$\u0003\u0002O\u0001&\u0011A*T\u0005\u0004\u0003\u0013[\u0015a\u00017pO&!\u0011QRAH\u00031Ien\u001d;b]R\u0014\u0016M\\4f\u0015\r\tIiS\u0005\u0005\u0003'\u000b)JA\u0005SC:<W\rV=qK*!\u0011QRAH\u0011\u001d\tI*\u0005a\u0001\u0003;\t1b\u001d;beR|eMZ:fi\u0006\u0019BO]1og2\fG/Z\"iK\u000e\\\u0007o\\5oiR\u0019!+a(\t\r\u0005\u0005&\u00031\u0001S\u0003)\u0019w.\\7jiRKW.Z\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002(B\u0019\u0011(!+\n\u0007\u0005-&H\u0001\u0003V]&$\b")
public class HoodieStreamSourceV2
implements Source,
Logging,
scala.Serializable,
SparkAdapterSupport {
    private HoodieTableType tableType;
    private transient HoodieSourceOffset initialOffsets;
    private final SQLContext sqlContext;
    private final HoodieTableMetaClient metaClient;
    private final String metadataPath;
    private final Option<StructType> schemaOption;
    private final Map<String, String> parameters;
    private final HoodieOffsetRangeLimit offsetRangeLimit;
    private final HoodieTableVersion writeTableVersion;
    private final boolean isCDCQuery;
    private SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieStreamSourceV2 hoodieStreamSourceV2 = this;
        synchronized (hoodieStreamSourceV2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieStreamSourceV2 hoodieStreamSourceV2 = this;
        synchronized (hoodieStreamSourceV2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableType = this.metaClient.getTableType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableType;
    }

    private HoodieTableType tableType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.tableType$lzycompute();
        }
        return this.tableType;
    }

    private boolean isCDCQuery() {
        return this.isCDCQuery;
    }

    private HoodieSourceOffset initialOffsets$lzycompute() {
        HoodieStreamSourceV2 hoodieStreamSourceV2 = this;
        synchronized (hoodieStreamSourceV2) {
            if (!this.bitmap$trans$0) {
                HoodieMetadataLog metadataLog = new HoodieMetadataLog(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialOffsets = (HoodieSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    HoodieSourceOffset hoodieSourceOffset;
                    HoodieOffsetRangeLimit hoodieOffsetRangeLimit = $this.offsetRangeLimit;
                    if (HoodieEarliestOffsetRangeLimit$.MODULE$.equals(hoodieOffsetRangeLimit)) {
                        hoodieSourceOffset = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    } else if (HoodieLatestOffsetRangeLimit$.MODULE$.equals(hoodieOffsetRangeLimit)) {
                        hoodieSourceOffset = (HoodieSourceOffset)((Object)((Object)this.getLatestOffset().getOrElse((Function0 & Serializable & scala.Serializable)() -> HoodieSourceOffset$.MODULE$.INIT_OFFSET())));
                    } else if (hoodieOffsetRangeLimit instanceof HoodieSpecifiedOffsetRangeLimit) {
                        HoodieSpecifiedOffsetRangeLimit hoodieSpecifiedOffsetRangeLimit = (HoodieSpecifiedOffsetRangeLimit)hoodieOffsetRangeLimit;
                        String completionTime = hoodieSpecifiedOffsetRangeLimit.instantTime();
                        hoodieSourceOffset = new HoodieSourceOffset(completionTime);
                    } else {
                        throw new MatchError((Object)hoodieOffsetRangeLimit);
                    }
                    HoodieSourceOffset offset = hoodieSourceOffset;
                    metadataLog.add(0L, (Object)offset);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("The initial offset is ").append((Object)offset).toString());
                    return offset;
                }));
                this.bitmap$trans$0 = true;
            }
        }
        return this.initialOffsets;
    }

    private HoodieSourceOffset initialOffsets() {
        if (!this.bitmap$trans$0) {
            return this.initialOffsets$lzycompute();
        }
        return this.initialOffsets;
    }

    public StructType schema() {
        if (this.isCDCQuery()) {
            return CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA();
        }
        return (StructType)this.schemaOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            TableSchemaResolver schemaUtil = new TableSchemaResolver($this.metaClient);
            return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaUtil.getTableAvroSchema());
        });
    }

    private Option<HoodieSourceOffset> getLatestOffset() {
        this.metaClient.reloadActiveTimeline();
        org.apache.hudi.common.util.Option<String> latestCompletionTime = this.metaClient.getActiveTimeline().filterCompletedInstants().getLatestCompletionTime();
        if (latestCompletionTime.isPresent()) {
            return new Some((Object)new HoodieSourceOffset(latestCompletionTime.get()));
        }
        return None$.MODULE$;
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        return this.getLatestOffset();
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start2, org.apache.spark.sql.execution.streaming.Offset end) {
        RDD<Row> rDD;
        HoodieSourceOffset startOffset = (HoodieSourceOffset)((Object)start2.map((Function1 & Serializable & scala.Serializable)x$1 -> HoodieSourceOffset$.MODULE$.apply((org.apache.spark.sql.execution.streaming.Offset)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.initialOffsets()));
        HoodieSourceOffset endOffset = HoodieSourceOffset$.MODULE$.apply(end);
        startOffset = new HoodieSourceOffset(this.translateCheckpoint(startOffset.offsetCommitTime()));
        endOffset = new HoodieSourceOffset(this.translateCheckpoint(endOffset.offsetCommitTime()));
        HoodieSourceOffset hoodieSourceOffset = startOffset;
        HoodieSourceOffset hoodieSourceOffset2 = endOffset;
        if (!(hoodieSourceOffset != null ? !((Object)((Object)hoodieSourceOffset)).equals((Object)hoodieSourceOffset2) : hoodieSourceOffset2 != null)) {
            return this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
        }
        Tuple2<String, InstantRange.RangeType> tuple2 = this.getStartCompletionTimeAndRangeType(startOffset);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String startCompletionTime = (String)tuple2._1();
        InstantRange.RangeType rangeType = (InstantRange.RangeType)((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)startCompletionTime, (Object)rangeType);
        String startCompletionTime2 = (String)tuple22._1();
        InstantRange.RangeType rangeType2 = (InstantRange.RangeType)((Object)tuple22._2());
        if (this.isCDCQuery()) {
            Map cdcOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key()), (Object)startCompletionTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key()), (Object)endOffset.offsetCommitTime())}));
            RDD<InternalRow> rdd = CDCRelation$.MODULE$.getCDCRelation(this.sqlContext, this.metaClient, (Map<String, String>)cdcOptions, rangeType2).buildScan0(HoodieCDCUtils.CDC_COLUMNS, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
            return this.sqlContext.sparkSession().internalCreateDataFrame(rdd, CDCRelation$.MODULE$.FULL_CDC_SPARK_SCHEMA(), true);
        }
        Map incParams = this.parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key()), (Object)startCompletionTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key()), (Object)endOffset.offsetCommitTime())})));
        HoodieTableType hoodieTableType = this.tableType();
        if (((Object)((Object)HoodieTableType.COPY_ON_WRITE)).equals((Object)hoodieTableType)) {
            SparkRowSerDe serDe = this.sparkAdapter().createSparkRowSerDe(this.schema());
            rDD = new IncrementalRelationV2(this.sqlContext, (Map<String, String>)incParams, (Option<StructType>)new Some((Object)this.schema()), this.metaClient, rangeType2).buildScan().map((Function1 & Serializable & scala.Serializable)x$1 -> serDe.serializeRow((Row)x$1), ClassTag$.MODULE$.apply(InternalRow.class));
        } else if (((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieTableType)) {
            String[] requiredColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            SQLContext x$12 = this.sqlContext;
            Map x$2 = incParams;
            HoodieTableMetaClient x$32 = this.metaClient;
            Some x$4 = new Some((Object)this.schema());
            InstantRange.RangeType x$5 = rangeType2;
            Option<StructType> x$6 = MergeOnReadIncrementalRelationV2$.MODULE$.$lessinit$greater$default$5();
            rDD = new MergeOnReadIncrementalRelationV2(x$12, (Map<String, String>)x$2, x$32, (Option<StructType>)x$4, x$6, x$5).buildScan(requiredColumns, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
        } else {
            throw new IllegalArgumentException(new StringBuilder(21).append("UnSupport tableType: ").append((Object)this.tableType()).toString());
        }
        RDD<Row> rdd = rDD;
        return this.sqlContext.internalCreateDataFrame((RDD)rdd, this.schema(), true);
    }

    private Tuple2<String, InstantRange.RangeType> getStartCompletionTimeAndRangeType(HoodieSourceOffset startOffset) {
        HoodieSourceOffset hoodieSourceOffset = startOffset;
        HoodieSourceOffset hoodieSourceOffset2 = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
        HoodieSourceOffset hoodieSourceOffset3 = hoodieSourceOffset;
        if (!(hoodieSourceOffset2 != null ? !((Object)((Object)hoodieSourceOffset2)).equals((Object)hoodieSourceOffset3) : hoodieSourceOffset3 != null)) {
            return new Tuple2((Object)startOffset.offsetCommitTime(), (Object)InstantRange.RangeType.CLOSED_CLOSED);
        }
        if (hoodieSourceOffset != null) {
            String completionTime = hoodieSourceOffset.offsetCommitTime();
            return new Tuple2((Object)completionTime, (Object)InstantRange.RangeType.OPEN_CLOSED);
        }
        throw new IllegalStateException("UnKnow offset type.");
    }

    private String translateCheckpoint(String commitTime) {
        if (this.writeTableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            return commitTime;
        }
        return CheckpointUtils.convertToCheckpointV1ForCommitTime(new StreamerCheckpointV2(commitTime), this.metaClient).getCheckpointKey();
    }

    public void stop() {
    }

    public HoodieStreamSourceV2(SQLContext sqlContext, HoodieTableMetaClient metaClient, String metadataPath, Option<StructType> schemaOption, Map<String, String> parameters, HoodieOffsetRangeLimit offsetRangeLimit, HoodieTableVersion writeTableVersion) {
        this.sqlContext = sqlContext;
        this.metaClient = metaClient;
        this.metadataPath = metadataPath;
        this.schemaOption = schemaOption;
        this.parameters = parameters;
        this.offsetRangeLimit = offsetRangeLimit;
        this.writeTableVersion = writeTableVersion;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        SparkAdapterSupport.$init$(this);
        this.isCDCQuery = CDCRelation$.MODULE$.isCDCEnabled(metaClient) && parameters.get((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()).contains((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()) && parameters.get((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT().key()).contains((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT_CDC_VAL());
    }
}

