/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoAnnotationVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoParameterVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MojoMethodVisitor
extends MethodVisitor
implements MojoParameterVisitor {
    private final String className;
    private final String fieldName;
    private final List<String> typeParameters;
    private Map<String, MojoAnnotationVisitor> annotationVisitorMap = new HashMap<String, MojoAnnotationVisitor>();

    public MojoMethodVisitor(String fieldName, String className, List<String> typeParameters) {
        super(589824);
        this.fieldName = fieldName;
        this.className = className;
        this.typeParameters = typeParameters;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String annotationClassName = Type.getType((String)desc).getClassName();
        if (!MojoAnnotationsScanner.METHOD_LEVEL_ANNOTATIONS.contains(annotationClassName)) {
            return null;
        }
        MojoAnnotationVisitor mojoAnnotationVisitor = new MojoAnnotationVisitor(annotationClassName);
        this.annotationVisitorMap.put(annotationClassName, mojoAnnotationVisitor);
        return mojoAnnotationVisitor;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public List<String> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public Map<String, MojoAnnotationVisitor> getAnnotationVisitorMap() {
        return this.annotationVisitorMap;
    }

    @Override
    public boolean isAnnotationOnMethod() {
        return true;
    }
}

