/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.war.util.DependencyInfo;
import org.apache.maven.plugins.war.util.PathSet;
import org.apache.maven.plugins.war.util.WarUtils;

public class WebappStructure {
    private Map<String, PathSet> registeredFiles;
    private List<DependencyInfo> dependenciesInfo;
    private transient PathSet allFiles = new PathSet();

    public WebappStructure(List<Dependency> dependencies) {
        this.dependenciesInfo = this.createDependenciesInfoList(dependencies);
        this.registeredFiles = new HashMap<String, PathSet>();
    }

    public List<DependencyInfo> getDependenciesInfo() {
        return this.dependenciesInfo;
    }

    public List<Dependency> getDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        if (this.dependenciesInfo == null) {
            return result;
        }
        for (DependencyInfo dependencyInfo : this.dependenciesInfo) {
            result.add(dependencyInfo.getDependency());
        }
        return result;
    }

    public boolean isRegistered(String path) {
        return this.getFullStructure().contains(path);
    }

    public boolean registerFile(String id, String path) {
        if (!this.isRegistered(path)) {
            this.doRegister(id, path);
            return true;
        }
        return false;
    }

    public boolean registerFileForced(String id, String path) {
        if (!this.isRegistered(path)) {
            this.doRegister(id, path);
            return false;
        }
        this.getStructure(this.getOwner(path)).remove(path);
        this.getStructure(id).add(path);
        return true;
    }

    public void registerFile(String id, String path, RegistrationCallback callback) throws IOException {
        if (this.isRegistered(path)) {
            callback.refused(id, path, this.getOwner(path));
        } else {
            this.doRegister(id, path);
            if (this.getOwner(path) == null) {
                callback.registered(id, path);
            } else if (this.getOwner(path).equals(id)) {
                callback.alreadyRegistered(id, path);
            } else if (this.getOwners().contains(this.getOwner(path))) {
                callback.superseded(id, path, this.getOwner(path));
            } else {
                callback.supersededUnknownOwner(id, path, this.getOwner(path));
            }
        }
    }

    public String getOwner(String path) {
        if (!this.isRegistered(path)) {
            return null;
        }
        for (String owner : this.registeredFiles.keySet()) {
            PathSet structure = this.getStructure(owner);
            if (!structure.contains(path)) continue;
            return owner;
        }
        throw new IllegalStateException("Should not happen, path [" + path + "] is flagged as being registered but was not found.");
    }

    public Set<String> getOwners() {
        return this.registeredFiles.keySet();
    }

    public PathSet getFullStructure() {
        return this.allFiles;
    }

    public PathSet getStructure(String id) {
        PathSet pathSet = this.registeredFiles.get(id);
        if (pathSet == null) {
            pathSet = new PathSet();
            this.registeredFiles.put(id, pathSet);
        }
        return pathSet;
    }

    public void registerTargetFileName(Artifact artifact, String targetFileName) {
        if (this.dependenciesInfo != null) {
            for (DependencyInfo dependencyInfo : this.dependenciesInfo) {
                if (!WarUtils.isRelated(artifact, dependencyInfo.getDependency())) continue;
                dependencyInfo.setTargetFileName(targetFileName);
            }
        }
    }

    private void doRegister(String id, String path) {
        this.getFullStructure().add(path);
        this.getStructure(id).add(path);
    }

    private List<DependencyInfo> createDependenciesInfoList(List<Dependency> dependencies) {
        if (dependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<DependencyInfo> result = new ArrayList<DependencyInfo>();
        for (Dependency dependency : dependencies) {
            result.add(new DependencyInfo(dependency));
        }
        return result;
    }

    private Object readResolve() {
        this.allFiles = new PathSet();
        for (PathSet pathSet : this.registeredFiles.values()) {
            this.allFiles.addAll(pathSet);
        }
        return this;
    }

    public static interface RegistrationCallback {
        public void registered(String var1, String var2) throws IOException;

        public void alreadyRegistered(String var1, String var2) throws IOException;

        public void refused(String var1, String var2, String var3) throws IOException;

        public void superseded(String var1, String var2, String var3) throws IOException;

        public void supersededUnknownOwner(String var1, String var2, String var3) throws IOException;
    }
}

