/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.reporting.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.PluginOverviewStats;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.plexus.i18n.I18N;

public class PluginUpdatesReportRenderer
extends AbstractVersionsReportRenderer<PluginUpdatesModel> {
    public PluginUpdatesReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, PluginUpdatesModel model, boolean allowSnapshots) {
        super(i18n, sink, locale, bundleName, model, allowSnapshots);
    }

    @Override
    protected void renderSummaryTable() {
        this.renderTable("report.overview.plugin", ((PluginUpdatesModel)this.model).getArtifactUpdates(), "report.overview.noPlugin");
    }

    @Override
    protected void renderManagementSummaryTable() {
        this.renderTable("report.overview.pluginManagement", ((PluginUpdatesModel)this.model).getArtifactManagementUpdates(), "report.overview.noPluginManagement");
    }

    @Override
    protected void renderDetails() {
        ((PluginUpdatesModel)this.model).getAllUpdates().forEach(this::renderPluginDetail);
    }

    private void renderDependencyDetail(Dependency dependency, ArtifactVersions details) {
        this.startSection(MessageFormat.format(this.getText("report.pluginDependency"), ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId())));
        this.renderDependencyDetailTable(dependency, details, false);
        this.endSection();
    }

    private void renderTable(String titleKey, Map<Dependency, PluginUpdatesDetails> contents, String emptyKey) {
        this.startSection(this.getText(titleKey));
        if (contents.isEmpty()) {
            this.paragraph(this.getText(emptyKey));
        } else {
            this.renderSummaryTable(contents);
        }
        this.endSection();
    }

    protected void renderSummaryTable(Map<Dependency, PluginUpdatesDetails> contents) {
        this.startTable();
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        contents.forEach(this::renderSummaryTableRow);
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        this.endTable();
    }

    @Override
    protected PluginOverviewStats computeOverviewStats() {
        return (PluginOverviewStats)PluginOverviewStats.fromUpdates(((PluginUpdatesModel)this.model).getAllUpdates().values(), this.newestUpdateCache, this.isAllowSnapshots());
    }

    @Override
    protected void renderSummaryTableHeader(boolean hasScope, boolean hasType) {
        super.renderSummaryTableHeader(hasScope, hasType);
        this.renderTableHeaderCells("report.dependencyStatus");
    }

    @Override
    protected <T extends OverviewStats> void renderOverviewTableRow(T stats) {
        super.renderOverviewTableRow(stats);
        super.renderStatRow("report.overview.numNewerDependenciesAvailable", ((PluginOverviewStats)stats).getDependencies(), false);
    }

    protected void renderSummaryTableRow(Dependency artifact, PluginUpdatesDetails details) {
        boolean upToDate = !details.isUpdateAvailable();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderIcon(upToDate);
        this.sink.tableCell_();
        this.renderCells(artifact.getGroupId(), artifact.getArtifactId());
        this.renderBoldCell(upToDate, artifact.getVersion());
        this.renderNewestVersions((AbstractVersionDetails)details);
        this.sink.tableCell();
        this.renderIcon(!details.isDependencyUpdateAvailable());
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderPluginDetail(Dependency artifact, PluginUpdatesDetails details) {
        this.startSection(MessageFormat.format(this.getText("report.plugin"), ArtifactUtils.versionlessKey((String)details.getGroupId(), (String)details.getArtifactId())));
        this.renderPluginDetailTable(details);
        if (!details.getDependencyVersions().isEmpty()) {
            this.startSection(MessageFormat.format(this.getText("report.pluginDependencies"), ArtifactUtils.versionlessKey((String)details.getGroupId(), (String)details.getArtifactId())));
            this.renderSummaryTable(details.getDependencyVersions(), false);
            this.endSection();
            details.getDependencyVersions().forEach(this::renderDependencyDetail);
        }
        this.endSection();
    }

    private void renderPluginDetailTable(PluginUpdatesDetails details) {
        ArtifactVersion[] allUpdates = details.getAllUpdates(Optional.empty(), this.isAllowSnapshots());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.startTable(new int[]{2, 1}, false);
        this.renderTwoCellsRow("report.status", () -> this.renderStatus((AbstractVersionDetails)details));
        this.renderTwoCellsRow("report.groupId", details.getGroupId());
        this.renderTwoCellsRow("report.artifactId", details.getArtifactId());
        this.renderTwoCellsRow("report.currentVersion", details.getVersion());
        if (!upToDate) {
            this.renderTwoCellsRow("report.updateVersions", () -> this.renderVersions(allUpdates, (AbstractVersionDetails)details));
        }
        this.endTable();
    }
}

