/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.activemq.listener;

import java.util.concurrent.ExecutorService;
import org.darkphoenixs.mq.consumer.MQConsumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.listener.MQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumerListener<T>
implements MQMessageListener<T> {
    protected Logger logger = LoggerFactory.getLogger(MessageConsumerListener.class);
    private MQConsumer<T> consumer;
    private ExecutorService threadPool;

    public MQConsumer<T> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MQConsumer<T> consumer) {
        this.consumer = consumer;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void onMessage(final T message) throws MQException {
        if (this.consumer != null) {
            if (this.threadPool != null) {
                this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageConsumerListener.this.consumer.receive(message);
                        }
                        catch (MQException e) {
                            MessageConsumerListener.this.logger.error("Receive message failed.", (Throwable)e);
                        }
                    }
                });
            } else {
                this.consumer.receive(message);
            }
        } else {
            throw new MQException("MQConsumer is null !");
        }
    }
}

